/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.ipv4.APCO25IpAddress;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.SNDCPMessage;
import io.github.dsheirer.module.decode.p25.reference.DataSubscriberUnitType;
import io.github.dsheirer.module.decode.p25.reference.MDPConfigurationOption;
import io.github.dsheirer.module.decode.p25.reference.NetworkAddressType;
import java.util.ArrayList;
import java.util.List;

public class ActivateTdsContextRequest
extends SNDCPMessage {
    private static final int[] VERSION = new int[]{4, 5, 6, 7};
    private static final int[] NSAPI = new int[]{8, 9, 10, 11};
    private static final int[] NAT = new int[]{12, 13, 14, 15};
    private static final int[] IPV4_ADDRESS = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] DSUT = new int[]{48, 49, 50, 51};
    private static final int[] UDP_IP_HEADER_COMPRESSION_BITMAP = new int[]{52, 53, 54, 55};
    private static final int[] IP_HEADER_COMPRESSION_BITMAP = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int TCP_IP_HEADER_COMPRESSION = 56;
    private static final int[] TCPSS = new int[]{64, 65, 66, 67};
    private static final int[] UDPSS = new int[]{68, 69, 70, 71};
    private static final int[] MDPCO = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private Identifier mIPAddress;
    private List<Identifier> mIdentifiers;

    public ActivateTdsContextRequest(BinaryMessage message, boolean outbound) {
        super(message, outbound);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getPDUType());
        if (this.hasIPAddress()) {
            sb.append(" IP:").append(this.getIPAddress());
            sb.append(" TYPE:").append((Object)this.getNetworkAddressType());
        }
        sb.append(" NSAPI:").append(this.getNSAPI());
        return sb.toString();
    }

    public int getVersion() {
        return this.getMessage().getInt(VERSION);
    }

    public int getNSAPI() {
        return this.getMessage().getInt(NSAPI);
    }

    public NetworkAddressType getNetworkAddressType() {
        return NetworkAddressType.fromValue(this.getMessage().getInt(NAT));
    }

    public boolean hasIPAddress() {
        NetworkAddressType nat = this.getNetworkAddressType();
        return nat == NetworkAddressType.IPV4_STATIC_ADDRESS || nat == NetworkAddressType.IPV4_DYNAMIC_ADDRESS;
    }

    public Identifier getIPAddress() {
        if (this.mIPAddress == null && this.hasIPAddress()) {
            this.mIPAddress = this.isOutbound() ? APCO25IpAddress.createTo(this.getMessage().getInt(IPV4_ADDRESS)) : APCO25IpAddress.createFrom(this.getMessage().getInt(IPV4_ADDRESS));
        }
        return this.mIPAddress;
    }

    public DataSubscriberUnitType getDataSubsciberUnitType() {
        return DataSubscriberUnitType.fromValue(this.getMessage().getInt(DSUT));
    }

    public boolean isTCPIPHeaderCompression() {
        return this.getMessage().get(56);
    }

    public boolean isIPHeaderCompression() {
        return this.getMessage().getInt(IP_HEADER_COMPRESSION_BITMAP) > 0;
    }

    public int getTCPIPStateSlots() {
        return this.getMessage().getInt(TCPSS);
    }

    public int getUDPIPStateSlots() {
        return this.getMessage().getInt(UDPSS);
    }

    public boolean isUDPHeaderCompression() {
        return this.getMessage().getInt(UDP_IP_HEADER_COMPRESSION_BITMAP) > 0;
    }

    public MDPConfigurationOption getMDPConfigurationOptions() {
        return MDPConfigurationOption.fromValue(this.getMessage().getInt(MDPCO));
    }

    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasIPAddress()) {
                this.mIdentifiers.add(this.getIPAddress());
            }
        }
        return this.mIdentifiers;
    }
}

