/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.PacketMessageFactory;
import io.github.dsheirer.module.decode.ip.ipv4.IPV4Packet;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.ConfirmedDataBlock;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.DataBlock;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.PacketHeader;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.SNDCPPacketHeader;
import io.github.dsheirer.module.decode.p25.reference.IPHeaderCompression;
import io.github.dsheirer.module.decode.p25.reference.UDPHeaderCompression;
import java.util.ArrayList;
import java.util.List;

public class PacketMessage
extends P25Message {
    private PDUSequence mPDUSequence;
    private BinaryMessage mPayload;
    private CorrectedBinaryMessage mPacketMessage;
    private SNDCPPacketHeader mSNDCPPacketHeader;
    private IPacket mPacket;
    private List<Identifier> mIdentifiers;

    public PacketMessage(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(null, nac, timestamp);
        this.mPDUSequence = PDUSequence2;
    }

    public PDUSequence getPDUSequence() {
        return this.mPDUSequence;
    }

    public PacketHeader getHeader() {
        return (PacketHeader)this.getPDUSequence().getHeader();
    }

    public SNDCPPacketHeader getSNDCPPacketHeader() {
        if (this.mSNDCPPacketHeader == null) {
            if (this.getPDUSequence().isComplete() && this.getHeader().getDataHeaderOffset() == 2) {
                if (this.getPDUSequence().getDataBlocks().size() >= 1) {
                    BinaryMessage message = this.getPDUSequence().getDataBlocks().get(0).getMessage().getSubMessage(0, 16);
                    this.mSNDCPPacketHeader = new SNDCPPacketHeader(message, this.getHeader().isOutbound());
                } else {
                    this.mSNDCPPacketHeader = new SNDCPPacketHeader(this.getHeader().isOutbound());
                }
            } else {
                this.mSNDCPPacketHeader = new SNDCPPacketHeader(this.getHeader().isOutbound());
            }
        }
        return this.mSNDCPPacketHeader;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        if (!this.getPDUSequence().isComplete()) {
            sb.append(" *INCOMPLETE - RECEIVED ").append(this.getPDUSequence().getDataBlocks().size()).append("/").append(this.getPDUSequence().getHeader().getBlocksToFollowCount()).append(" DATA BLOCKS");
        }
        if (this.getPacket() instanceof IPV4Packet) {
            sb.append(" LLID:").append(this.getHeader().getLLID());
            SNDCPPacketHeader sndcpPacketHeader = this.getSNDCPPacketHeader();
            sb.append(" NSAPI:").append(sndcpPacketHeader.getNSAPI());
            if (sndcpPacketHeader.getIPHeaderCompression() != IPHeaderCompression.NONE) {
                sb.append("IP HEADER COMPRESSION:").append((Object)sndcpPacketHeader.getIPHeaderCompression());
            }
            if (sndcpPacketHeader.getUDPHeaderCompression() != UDPHeaderCompression.NONE) {
                sb.append("UDP HEADER COMPRESSION:").append((Object)sndcpPacketHeader.getUDPHeaderCompression());
            }
            sb.append(" ").append(this.getPacket());
        } else {
            sb.append(" ").append(this.getPDUSequence().getHeader().toString());
            if (this.getHeader().isConfirmationRequired()) {
                sb.append(" DATA BLOCKS ").append(this.getDataBlockSequenceNumbers());
            } else {
                sb.append(" DATA BLOCKS:").append(this.getPDUSequence().getDataBlocks().size());
            }
            if (!this.getPDUSequence().getDataBlocks().isEmpty()) {
                sb.append(" MSG:");
                for (DataBlock dataBlock : this.getPDUSequence().getDataBlocks()) {
                    sb.append(dataBlock.getMessage().toHexString());
                }
            }
            sb.append(" PAYLOAD:").append(this.getPayloadMessage().toHexString());
            sb.append(" ").append(this.getPacket());
        }
        return sb.toString();
    }

    public List<Integer> getDataBlockSequenceNumbers() {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (DataBlock dataBlock : this.getPDUSequence().getDataBlocks()) {
            int sequenceNumber;
            if (!(dataBlock instanceof ConfirmedDataBlock) || (sequenceNumber = ((ConfirmedDataBlock)dataBlock).getSequenceNumber()) == -1) continue;
            numbers.add(sequenceNumber);
        }
        return numbers;
    }

    public IPacket getPacket() {
        if (this.mPacket == null) {
            this.mPacket = PacketMessageFactory.create(this.getSNDCPPacketHeader(), this.getPacketMessage(), 0);
        }
        return this.mPacket;
    }

    public CorrectedBinaryMessage getPacketMessage() {
        if (this.mPacketMessage == null) {
            int start = this.getHeader().getDataHeaderOffset() * 8;
            if (this.getPayloadMessage().size() >= start + 32) {
                int end = this.getPayloadMessage().size() - 32;
                if ((end -= this.getHeader().getPadOctetCount() * 8) > start) {
                    BinaryMessage message = this.getPayloadMessage().getSubMessage(start, end);
                    this.mPacketMessage = new CorrectedBinaryMessage(message);
                }
            }
            if (this.mPacketMessage == null) {
                this.mPacketMessage = new CorrectedBinaryMessage(0);
            }
        }
        return this.mPacketMessage;
    }

    public BinaryMessage getPayloadMessage() {
        if (this.mPayload == null) {
            int octetCount = 0;
            octetCount = this.getHeader().isConfirmationRequired() ? (octetCount += 16 * this.getHeader().getBlocksToFollowCount()) : (octetCount += 12 * this.getHeader().getBlocksToFollowCount());
            this.mPayload = new BinaryMessage(octetCount * 8);
            int pointer = 0;
            List<DataBlock> dataBlocks = this.getPDUSequence().getDataBlocks();
            for (DataBlock dataBlock : dataBlocks) {
                BinaryMessage blockPayload = dataBlock.getMessage();
                this.mPayload.load(pointer, blockPayload);
                pointer += blockPayload.size();
            }
        }
        return this.mPayload;
    }

    @Override
    public P25P1DataUnitID getDUID() {
        return P25P1DataUnitID.IP_PACKET_DATA;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getPDUSequence().getHeader().getLLID());
            if (this.getPacket() != null) {
                this.mIdentifiers.addAll(this.getPacket().getIdentifiers());
            }
        }
        return this.mIdentifiers;
    }
}

