/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.block;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.CRCP25;
import io.github.dsheirer.edac.trellis.ViterbiDecoder_3_4_P25;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.DataBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmedDataBlock
extends DataBlock {
    private static final Logger mLog = LoggerFactory.getLogger(ConfirmedDataBlock.class);
    public static final int[] SEQUENCE_NUMBER = new int[]{0, 1, 2, 3, 4, 5, 6};
    public static final int PAYLOAD_START = 16;
    public static final int PAYLOAD_END = 144;
    private static final ViterbiDecoder_3_4_P25 VITERBI_THREE_QUARTER_RATE_DECODER = new ViterbiDecoder_3_4_P25();
    private CorrectedBinaryMessage mDecodedMessage;
    private boolean mValid;

    public ConfirmedDataBlock(CorrectedBinaryMessage correctedBinaryMessage) {
        this.mDecodedMessage = VITERBI_THREE_QUARTER_RATE_DECODER.decode(correctedBinaryMessage);
        this.mDecodedMessage.incrementCorrectedBitCount(correctedBinaryMessage.getCorrectedBitCount());
        this.checkCRC();
    }

    public int getSequenceNumber() {
        if (this.mDecodedMessage != null) {
            return this.mDecodedMessage.getInt(SEQUENCE_NUMBER);
        }
        return -1;
    }

    private void checkCRC() {
        CRC crc = CRCP25.checkCRC9(this.mDecodedMessage, 0);
        this.mValid = crc == CRC.PASSED || crc == CRC.CORRECTED;
    }

    @Override
    public BinaryMessage getMessage() {
        return this.mDecodedMessage.getSubMessage(16, 144);
    }

    @Override
    public int getBitErrorsCount() {
        return this.mDecodedMessage.getCorrectedBitCount();
    }

    @Override
    public boolean isValid() {
        return this.mValid;
    }
}

