/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Lra;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.UnconfirmedDataBlock;
import java.util.ArrayList;
import java.util.List;

public class AMBTCRFSSStatusBroadcast
extends AMBTCMessage
implements IFrequencyBandReceiver {
    private static final int[] HEADER_LRA = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int HEADER_ACTIVE_NETWORK_CONNECTION_TO_RFSS_CONTROLLER_FLAG = 35;
    private static final int[] HEADER_SYSTEM = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] BLOCK_0_RFSS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] BLOCK_0_SITE = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_DOWNLINK_FREQUENCY_BAND = new int[]{16, 17, 18, 19};
    private static final int[] BLOCK_0_DOWNLINK_CHANNEL_NUMBER = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] BLOCK_0_UPLINK_FREQUENCY_BAND = new int[]{32, 33, 34, 35};
    private static final int[] BLOCK_0_UPLINK_CHANNEL_NUMBER = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private Identifier mLra;
    private Identifier mSystem;
    private Identifier mRfss;
    private Identifier mSite;
    private IChannelDescriptor mChannel;
    private List<Identifier> mIdentifiers;
    private List<IChannelDescriptor> mChannels;

    public AMBTCRFSSStatusBroadcast(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
        this.setValid(this.hasDataBlock(0));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" SITE:").append(this.getSite());
        if (this.isActiveNetworkConnectionToRfssControllerSite()) {
            sb.append(" ACTIVE NETWORK CONNECTION");
        }
        sb.append(" RFSS:").append(this.getRFSS());
        sb.append(" LRA:").append(this.getLRA());
        sb.append(" CHAN:").append(this.getChannel());
        return sb.toString();
    }

    public Identifier getLRA() {
        if (this.mLra == null) {
            this.mLra = APCO25Lra.create(this.getHeader().getMessage().getInt(HEADER_LRA));
        }
        return this.mLra;
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getHeader().getMessage().getInt(HEADER_SYSTEM));
        }
        return this.mSystem;
    }

    public Identifier getRFSS() {
        if (this.mRfss == null && this.hasDataBlock(0)) {
            this.mRfss = APCO25Rfss.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_RFSS));
        }
        return this.mRfss;
    }

    public boolean isActiveNetworkConnectionToRfssControllerSite() {
        return this.getHeader().getMessage().get(35);
    }

    public Identifier getSite() {
        if (this.mSite == null && this.hasDataBlock(0)) {
            this.mSite = APCO25Site.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SITE));
        }
        return this.mSite;
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null && this.hasDataBlock(0)) {
            if (this.hasDataBlock(0)) {
                UnconfirmedDataBlock block = this.getDataBlock(0);
                this.mChannel = APCO25ExplicitChannel.create(block.getMessage().getInt(BLOCK_0_DOWNLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER), block.getMessage().getInt(BLOCK_0_UPLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_UPLINK_CHANNEL_NUMBER));
            } else {
                this.mChannel = APCO25Channel.create(-1, 0);
            }
        }
        return this.mChannel;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getLRA() != null) {
                this.mIdentifiers.add(this.getLRA());
            }
            if (this.getSystem() != null) {
                this.mIdentifiers.add(this.getSystem());
            }
            if (this.getRFSS() != null) {
                this.mIdentifiers.add(this.getRFSS());
            }
            if (this.getSite() != null) {
                this.mIdentifiers.add(this.getSite());
            }
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.mChannels == null) {
            this.mChannels = new ArrayList<IChannelDescriptor>();
            if (this.getChannel() != null) {
                this.mChannels.add(this.getChannel());
            }
        }
        return this.mChannels;
    }
}

