/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.encryption.EncryptionKeyIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.encryption.APCO25EncryptionKey;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import java.util.ArrayList;
import java.util.List;

public class AMBTCProtectionParameterBroadcast
extends AMBTCMessage {
    private static final int[] HEADER_ALGORITHM_ID = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_KEY_ID = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_INBOUND_MESSAGE_INDICATOR_1 = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] BLOCK_0_INBOUND_MESSAGE_INDICATOR_2 = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] BLOCK_0_OUTBOUND_MESSAGE_INDICATOR_1 = new int[]{88, 89, 90, 91, 92, 93, 94, 95};
    private static final int[] BLOCK_1_OUTBOUND_MESSAGE_INDICATOR_2 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] BLOCK_1_OUTBOUND_MESSAGE_INDICATOR_3 = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private Identifier mTargetAddress;
    private Identifier mEncryptionKey;
    private String mInboundMessageIndicator;
    private String mOutboundMessageIndicator;
    private List<Identifier> mIdentifiers;

    public AMBTCProtectionParameterBroadcast(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        if (this.getTargetAddress() != null) {
            sb.append(" TO:").append(this.getTargetAddress());
        }
        if (this.getEncryptionKey() != null) {
            sb.append(" ENCRYPTION KEY:").append(this.getEncryptionKey());
        }
        if (this.getInboundMessageIndicator() != null) {
            sb.append(" INBOUND MI:").append(this.getInboundMessageIndicator());
        }
        if (this.getOutboundMessageIndicator() != null) {
            sb.append(" OUTBOUND MI:").append(this.getOutboundMessageIndicator());
        }
        return sb.toString();
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null && this.hasDataBlock(0)) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getDataBlock(0).getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mTargetAddress;
    }

    public Identifier getEncryptionKey() {
        if (this.mEncryptionKey == null && this.hasDataBlock(0)) {
            this.mEncryptionKey = EncryptionKeyIdentifier.create(APCO25EncryptionKey.create(this.getHeader().getMessage().getInt(HEADER_ALGORITHM_ID), this.getDataBlock(0).getMessage().getInt(BLOCK_0_KEY_ID)));
        }
        return this.mEncryptionKey;
    }

    public String getInboundMessageIndicator() {
        if (this.mInboundMessageIndicator == null && this.hasDataBlock(0)) {
            this.mInboundMessageIndicator = this.getDataBlock(0).getMessage().getHex(BLOCK_0_INBOUND_MESSAGE_INDICATOR_1, 10) + this.getDataBlock(0).getMessage().getHex(BLOCK_0_INBOUND_MESSAGE_INDICATOR_2, 8);
        }
        return this.mInboundMessageIndicator;
    }

    public String getOutboundMessageIndicator() {
        if (this.mOutboundMessageIndicator == null && this.hasDataBlock(0) && this.hasDataBlock(1)) {
            this.mOutboundMessageIndicator = this.getDataBlock(0).getMessage().getHex(BLOCK_0_OUTBOUND_MESSAGE_INDICATOR_1, 2) + this.getDataBlock(1).getMessage().getHex(BLOCK_1_OUTBOUND_MESSAGE_INDICATOR_2, 8) + this.getDataBlock(1).getMessage().getHex(BLOCK_1_OUTBOUND_MESSAGE_INDICATOR_3, 8);
        }
        return this.mOutboundMessageIndicator;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getTargetAddress() != null) {
                this.mIdentifiers.add(this.getTargetAddress());
            }
            if (this.getEncryptionKey() != null) {
                this.mIdentifiers.add(this.getEncryptionKey());
            }
        }
        return this.mIdentifiers;
    }
}

