/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.UnconfirmedDataBlock;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.List;

public class AMBTCNetworkStatusBroadcast
extends AMBTCMessage
implements IFrequencyBandReceiver {
    private static final int[] HEADER_SYSTEM = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] BLOCK_0_WACN = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    private static final int[] BLOCK_0_DOWNLINK_FREQUENCY_BAND = new int[]{24, 25, 26, 27};
    private static final int[] BLOCK_0_DOWNLINK_CHANNEL_NUMBER = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] BLOCK_0_UPLINK_FREQUENCY_BAND = new int[]{40, 41, 42, 43};
    private static final int[] BLOCK_0_UPLINK_CHANNEL_NUMBER = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] BLOCK_0_SYSTEM_SERVICE_CLASS = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private ScrambleParameters mScrambleParameters;
    private Identifier mWacn;
    private Identifier mSystem;
    private IChannelDescriptor mChannel;
    private List<Identifier> mIdentifiers;
    private List<IChannelDescriptor> mChannels;
    private SystemServiceClass mSystemServiceClass;

    public AMBTCNetworkStatusBroadcast(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
        this.setValid(this.hasDataBlock(0));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" WACN:").append(this.getWacn());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" CHAN:").append(this.getChannel());
        sb.append(" SERVICES:").append(this.getSystemServiceClass());
        return sb.toString();
    }

    public SystemServiceClass getSystemServiceClass() {
        if (this.mSystemServiceClass == null && this.hasDataBlock(0)) {
            this.mSystemServiceClass = this.hasDataBlock(0) ? new SystemServiceClass(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SYSTEM_SERVICE_CLASS)) : new SystemServiceClass(0);
        }
        return this.mSystemServiceClass;
    }

    public ScrambleParameters getScrambleParameters() {
        if (this.mScrambleParameters == null) {
            int wacn = (Integer)this.getWacn().getValue();
            int system = (Integer)this.getSystem().getValue();
            int nac = (Integer)this.getNAC().getValue();
            this.mScrambleParameters = new ScrambleParameters(wacn, system, nac);
        }
        return this.mScrambleParameters;
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getHeader().getMessage().getInt(HEADER_SYSTEM));
        }
        return this.mSystem;
    }

    public Identifier getWacn() {
        if (this.mWacn == null && this.hasDataBlock(0)) {
            this.mWacn = APCO25Wacn.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_WACN));
        }
        return this.mWacn;
    }

    public boolean isExtendedChannel() {
        return this.hasDataBlock(0) && this.getDataBlock(0).getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER) != this.getDataBlock(0).getMessage().getInt(BLOCK_0_UPLINK_CHANNEL_NUMBER);
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null && this.hasDataBlock(0)) {
            if (this.hasDataBlock(0)) {
                UnconfirmedDataBlock block = this.getDataBlock(0);
                this.mChannel = this.isExtendedChannel() ? APCO25ExplicitChannel.create(block.getMessage().getInt(BLOCK_0_DOWNLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER), block.getMessage().getInt(BLOCK_0_UPLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_UPLINK_CHANNEL_NUMBER)) : APCO25Channel.create(block.getMessage().getInt(BLOCK_0_DOWNLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER));
            } else {
                this.mChannel = APCO25Channel.create(-1, 0);
            }
        }
        return this.mChannel;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getWacn() != null) {
                this.mIdentifiers.add(this.getWacn());
            }
            if (this.getSystem() != null) {
                this.mIdentifiers.add(this.getSystem());
            }
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.mChannels == null) {
            this.mChannels = new ArrayList<IChannelDescriptor>();
            if (this.getChannel() != null) {
                this.mChannels.add(this.getChannel());
            }
        }
        return this.mChannels;
    }
}

