/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.UnconfirmedDataBlock;
import io.github.dsheirer.module.decode.p25.reference.DataServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class AMBTCIndividualDataChannelGrant
extends AMBTCMessage
implements IFrequencyBandReceiver {
    private static final int[] HEADER_SERVICE_OPTIONS = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] HEADER_RESERVED = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_WACN = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    private static final int[] BLOCK_0_SYSTEM = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] BLOCK_0_SOURCE_ID = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] BLOCK_0_TARGET_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_DOWNLINK_FREQUENCY_BAND = new int[]{80, 81, 82, 83};
    private static final int[] BLOCK_0_DOWNLINK_CHANNEL_NUMBER = new int[]{84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95};
    private static final int[] BLOCK_1_UPLINK_FREQUENCY_BAND = new int[]{0, 1, 2, 3};
    private static final int[] BLOCK_1_UPLINK_CHANNEL_NUMBER = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private DataServiceOptions mDataServiceOptions;
    private Identifier mWacn;
    private Identifier mSystem;
    private Identifier mSourceAddress;
    private Identifier mSourceId;
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;
    private APCO25Channel mChannel;
    private List<IChannelDescriptor> mChannels;

    public AMBTCIndividualDataChannelGrant(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        if (this.getSourceId() != null) {
            sb.append(" FM:").append(this.getSourceId());
        }
        sb.append(" TO:").append(this.getTargetAddress());
        if (this.getWacn() != null) {
            sb.append(" WACN:").append(this.getWacn());
        }
        if (this.getSystem() != null) {
            sb.append(" SYSTEM:").append(this.getSystem());
        }
        sb.append(" SERVICE OPTIONS:").append(this.getDataServiceOptions());
        return sb.toString();
    }

    public DataServiceOptions getDataServiceOptions() {
        if (this.mDataServiceOptions == null) {
            this.mDataServiceOptions = new DataServiceOptions(this.getHeader().getMessage().getInt(HEADER_SERVICE_OPTIONS));
        }
        return this.mDataServiceOptions;
    }

    public Identifier getWacn() {
        if (this.mWacn == null && this.hasDataBlock(0)) {
            this.mWacn = APCO25Wacn.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_WACN));
        }
        return this.mWacn;
    }

    public Identifier getSystem() {
        if (this.mSystem == null && this.hasDataBlock(0)) {
            this.mSystem = APCO25System.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SYSTEM));
        }
        return this.mSystem;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getHeader().getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mSourceAddress;
    }

    public Identifier getSourceId() {
        if (this.mSourceId == null && this.hasDataBlock(0)) {
            this.mSourceId = APCO25RadioIdentifier.createFrom(this.getHeader().getMessage().getInt(BLOCK_0_SOURCE_ID));
        }
        return this.mSourceId;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null && this.hasDataBlock(0)) {
            this.mTargetAddress = APCO25Talkgroup.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getSourceAddress() != null) {
                this.mIdentifiers.add(this.getSourceAddress());
            }
            if (this.getTargetAddress() != null) {
                this.mIdentifiers.add(this.getTargetAddress());
            }
            if (this.getSourceId() != null) {
                this.mIdentifiers.add(this.getSourceId());
            }
            if (this.getWacn() != null) {
                this.mIdentifiers.add(this.getWacn());
            }
            if (this.getSystem() != null) {
                this.mIdentifiers.add(this.getSystem());
            }
        }
        return this.mIdentifiers;
    }

    public boolean isExtendedChannel() {
        return this.hasDataBlock(0) && this.getDataBlock(0).getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER) != this.getDataBlock(0).getMessage().getInt(BLOCK_1_UPLINK_CHANNEL_NUMBER);
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            if (this.hasDataBlock(0)) {
                UnconfirmedDataBlock block0 = this.getDataBlock(0);
                if (this.isExtendedChannel() && this.hasDataBlock(1)) {
                    UnconfirmedDataBlock block1 = this.getDataBlock(1);
                    this.mChannel = APCO25ExplicitChannel.create(block0.getMessage().getInt(BLOCK_0_DOWNLINK_FREQUENCY_BAND), block0.getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER), block1.getMessage().getInt(BLOCK_1_UPLINK_FREQUENCY_BAND), block1.getMessage().getInt(BLOCK_1_UPLINK_CHANNEL_NUMBER));
                } else {
                    this.mChannel = APCO25Channel.create(block0.getMessage().getInt(BLOCK_0_DOWNLINK_FREQUENCY_BAND), block0.getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER));
                }
            }
            if (this.mChannel == null) {
                this.mChannel = APCO25Channel.create(-1, 0);
            }
        }
        return this.mChannel;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.mChannels == null) {
            this.mChannels = new ArrayList<IChannelDescriptor>();
            if (this.getChannel() != null) {
                this.mChannels.add(this.getChannel());
            }
        }
        return this.mChannels;
    }
}

