/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Lra;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.UnconfirmedDataBlock;
import java.util.ArrayList;
import java.util.List;

public class AMBTCAdjacentStatusBroadcast
extends AMBTCMessage
implements IFrequencyBandReceiver {
    private static final int[] HEADER_LRA = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] HEADER_SYSTEM = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] HEADER_RFSS = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] HEADER_SITE = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_DOWNLINK_FREQUENCY_BAND = new int[]{0, 1, 2, 3};
    private static final int[] BLOCK_0_DOWNLINK_CHANNEL_NUMBER = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_UPLINK_FREQUENCY_BAND = new int[]{16, 17, 18, 19};
    private static final int[] BLOCK_0_UPLINK_CHANNEL_NUMBER = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private Identifier mSystem;
    private Identifier mLocationRegistrationArea;
    private Identifier mRfss;
    private Identifier mSite;
    private IChannelDescriptor mChannel;
    private List<Identifier> mIdentifiers;
    private List<IChannelDescriptor> mChannels;

    public AMBTCAdjacentStatusBroadcast(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
        this.setValid(this.hasDataBlock(0));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" LRA:").append(this.getLocationRegistrationArea());
        sb.append(" RFSS:").append(this.getRfss());
        sb.append(" SITE:").append(this.getSite());
        sb.append(" CHAN:").append(this.getChannel());
        return sb.toString();
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getHeader().getMessage().getInt(HEADER_SYSTEM));
        }
        return this.mSystem;
    }

    public Identifier getLocationRegistrationArea() {
        if (this.mLocationRegistrationArea == null) {
            this.mLocationRegistrationArea = APCO25Lra.create(this.getHeader().getMessage().getInt(HEADER_LRA));
        }
        return this.mLocationRegistrationArea;
    }

    public Identifier getRfss() {
        if (this.mRfss == null) {
            this.mRfss = APCO25Rfss.create(this.getHeader().getMessage().getInt(HEADER_RFSS));
        }
        return this.mRfss;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getHeader().getMessage().getInt(HEADER_SITE));
        }
        return this.mSite;
    }

    public boolean isExtendedChannel() {
        return this.hasDataBlock(0) && this.getDataBlock(0).getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER) != this.getDataBlock(0).getMessage().getInt(BLOCK_0_UPLINK_CHANNEL_NUMBER);
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null && this.hasDataBlock(0)) {
            if (this.hasDataBlock(0)) {
                UnconfirmedDataBlock block = this.getDataBlock(0);
                this.mChannel = this.isExtendedChannel() ? APCO25ExplicitChannel.create(block.getMessage().getInt(BLOCK_0_DOWNLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER), block.getMessage().getInt(BLOCK_0_UPLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_UPLINK_CHANNEL_NUMBER)) : APCO25Channel.create(block.getMessage().getInt(BLOCK_0_DOWNLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER));
            } else {
                this.mChannel = APCO25Channel.create(-1, 0);
            }
        }
        return this.mChannel;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getRfss() != null) {
                this.mIdentifiers.add(this.getRfss());
            }
            if (this.getSite() != null) {
                this.mIdentifiers.add(this.getSite());
            }
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.mChannels == null) {
            this.mChannels = new ArrayList<IChannelDescriptor>();
            if (this.getChannel() != null) {
                this.mChannels.add(this.getChannel());
            }
        }
        return this.mChannels;
    }
}

