/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import java.util.ArrayList;
import java.util.List;

public class AMBTCRoamingAddressRequest
extends AMBTCMessage {
    private static final int[] HEADER_WACN = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_WACN = new int[]{0, 1, 2, 3};
    private static final int[] BLOCK_0_SYSTEM = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_TARGET_ID = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private Identifier mWacn;
    private Identifier mSystem;
    private Identifier mTargetId;
    private Identifier mSourceAddress;
    private List<Identifier> mIdentifiers;

    public AMBTCRoamingAddressRequest(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" FM:").append(this.getSourceAddress());
        if (this.getTargetId() != null) {
            sb.append(" TO:").append(this.getTargetId());
        }
        if (this.getWacn() != null) {
            sb.append(" WACN:").append(this.getWacn());
        }
        if (this.getSystem() != null) {
            sb.append(" SYSTEM:").append(this.getSystem());
        }
        return sb.toString();
    }

    public Identifier getTargetId() {
        if (this.mTargetId == null) {
            this.mTargetId = APCO25RadioIdentifier.createTo(this.getHeader().getMessage().getInt(BLOCK_0_TARGET_ID));
        }
        return this.mTargetId;
    }

    public Identifier getWacn() {
        if (this.mWacn == null && this.hasDataBlock(0)) {
            int value = this.getHeader().getMessage().getInt(HEADER_WACN);
            value <<= 4;
            this.mWacn = APCO25Wacn.create(value += this.getDataBlock(0).getMessage().getInt(BLOCK_0_WACN));
        }
        return this.mWacn;
    }

    public Identifier getSystem() {
        if (this.mSystem == null && this.hasDataBlock(0)) {
            this.mSystem = APCO25System.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SYSTEM));
        }
        return this.mSystem;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null && this.hasDataBlock(0)) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getDataBlock(0).getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getSourceAddress() != null) {
                this.mIdentifiers.add(this.getSourceAddress());
            }
            if (this.getWacn() != null) {
                this.mIdentifiers.add(this.getWacn());
            }
            if (this.getSystem() != null) {
                this.mIdentifiers.add(this.getSystem());
            }
            if (this.getTargetId() != null) {
                this.mIdentifiers.add(this.getTargetId());
            }
        }
        return this.mIdentifiers;
    }
}

