/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.P25Utils;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUHeader;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.Opcode;
import io.github.dsheirer.module.decode.p25.reference.ServiceAccessPoint;
import io.github.dsheirer.module.decode.p25.reference.Vendor;

public class AMBTCHeader
extends PDUHeader {
    public static final int[] SAP_ID = new int[]{10, 11, 12, 13, 14, 15};
    public static final int[] OPCODE = new int[]{58, 59, 60, 61, 62, 63};
    public static final int[] DATA = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};

    public AMBTCHeader(CorrectedBinaryMessage message, boolean passesCRC) {
        super(message, passesCRC);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("*CRC-FAIL*");
        }
        sb.append("AMBTC");
        Vendor vendor = this.getVendor();
        sb.append(" ").append(this.getOpcode().getLabel());
        P25Utils.pad(sb, 22);
        if (vendor != Vendor.STANDARD) {
            sb.append(" VENDOR:").append((Object)this.getVendor());
        }
        sb.append(" HDR:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public ServiceAccessPoint getServiceAccessPoint() {
        return ServiceAccessPoint.fromValue(this.getMessage().getInt(SAP_ID));
    }

    public Opcode getOpcode() {
        return Opcode.fromValue(this.getMessage().getInt(OPCODE), this.getDirection(), this.getVendor());
    }

    public int getDataOctets() {
        return this.getMessage().getInt(DATA);
    }
}

