/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu;

import io.github.dsheirer.message.IBitErrorProvider;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUHeader;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.DataBlock;
import java.util.ArrayList;
import java.util.List;

public class PDUSequence
implements IBitErrorProvider {
    private long mTimestamp;
    private int mNAC;
    private PDUHeader mHeader;
    private List<DataBlock> mDataBlocks = new ArrayList<DataBlock>();

    public PDUSequence(PDUHeader pduHeader, long timestamp, int nac) {
        this.mHeader = pduHeader;
        this.mTimestamp = timestamp;
        this.mNAC = nac;
    }

    public int getNAC() {
        return this.mNAC;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public boolean isComplete() {
        return this.getHeader().getBlocksToFollowCount() == this.mDataBlocks.size();
    }

    public void addDataBlock(DataBlock dataBlock) {
        this.mDataBlocks.add(dataBlock);
    }

    public boolean hasDataBlock(int index) {
        return this.getDataBlock(index) != null;
    }

    public DataBlock getDataBlock(int index) {
        if (index < this.mDataBlocks.size()) {
            return this.mDataBlocks.get(index);
        }
        return null;
    }

    public List<DataBlock> getDataBlocks() {
        return this.mDataBlocks;
    }

    public PDUHeader getHeader() {
        return this.mHeader;
    }

    @Override
    public int getBitsProcessedCount() {
        int processed = this.getHeader().getBitsProcessedCount();
        for (DataBlock dataBlock : this.mDataBlocks) {
            processed += dataBlock.getBitsProcessedCount();
        }
        return processed;
    }

    @Override
    public int getBitErrorsCount() {
        int errorCount = this.getHeader().getBitErrorsCount();
        for (DataBlock dataBlock : this.mDataBlocks) {
            errorCount += dataBlock.getBitErrorsCount();
        }
        return errorCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NAC:").append(this.getNAC());
        if (!this.isComplete()) {
            sb.append(" *INCOMPLETE - RECEIVED ").append(this.mDataBlocks.size()).append("/").append(this.getHeader().getBlocksToFollowCount()).append(" DATA BLOCKS");
        }
        sb.append(" ").append(this.getHeader().toString());
        sb.append(" DATA BLOCKS:").append(this.mDataBlocks.size());
        if (!this.mDataBlocks.isEmpty()) {
            sb.append(" MSG:");
            for (DataBlock dataBlock : this.mDataBlocks) {
                sb.append(dataBlock.getMessage().toHexString());
            }
        }
        return sb.toString();
    }
}

