/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.IBitErrorProvider;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.reference.Direction;
import io.github.dsheirer.module.decode.p25.reference.PDUFormat;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDUHeader
implements IBitErrorProvider {
    private static final Logger mLog = LoggerFactory.getLogger(PDUHeader.class);
    public static final int CONFIRMATION_REQUIRED_INDICATOR = 1;
    public static final int PACKET_DIRECTION_INDICATOR = 2;
    public static final int[] PDU_FORMAT = new int[]{3, 4, 5, 6, 7};
    public static final int[] VENDOR_ID = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    public static final int[] LOGICAL_LINK_ID = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    public static final int[] BLOCKS_TO_FOLLOW = new int[]{49, 50, 51, 52, 53, 54, 55};
    public static final int[] PDU_CRC = new int[]{80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95};
    protected boolean mValid;
    private CorrectedBinaryMessage mMessage;
    private Identifier mLLID;

    public PDUHeader(CorrectedBinaryMessage message, boolean passesCRC) {
        this.mMessage = message;
        this.mValid = passesCRC;
    }

    public CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public boolean isValid() {
        return this.mValid;
    }

    public boolean isConfirmationRequired() {
        return this.getMessage().get(1);
    }

    public Direction getDirection() {
        return Direction.fromValue(this.getMessage().get(2));
    }

    public boolean isOutbound() {
        return this.getDirection() == Direction.OUTBOUND;
    }

    public PDUFormat getFormat() {
        return PDUHeader.getFormat(this.getMessage());
    }

    public static PDUFormat getFormat(BinaryMessage binaryMessage) {
        return PDUFormat.fromValue(binaryMessage.getInt(PDU_FORMAT));
    }

    @Override
    public int getBitsProcessedCount() {
        return 196;
    }

    @Override
    public int getBitErrorsCount() {
        return this.getMessage().getCorrectedBitCount();
    }

    public Vendor getVendor() {
        return Vendor.fromValue(this.getMessage().getInt(VENDOR_ID));
    }

    public Identifier getLLID() {
        if (this.mLLID == null) {
            this.mLLID = this.isOutbound() ? APCO25RadioIdentifier.createTo(this.getMessage().getInt(LOGICAL_LINK_ID)) : APCO25RadioIdentifier.createFrom(this.getMessage().getInt(LOGICAL_LINK_ID));
        }
        return this.mLLID;
    }

    public int getBlocksToFollowCount() {
        return this.getMessage().getInt(BLOCKS_TO_FOLLOW);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("***CRC-FAIL*** ");
        }
        sb.append("PDU HEADER FORMAT:");
        sb.append(this.getFormat().getLabel());
        sb.append(this.isConfirmationRequired() ? " CONFIRMED" : " UNCONFIRMED");
        sb.append(" VENDOR:").append(this.getVendor().getLabel());
        sb.append(this.isOutbound() ? "TO" : "FROM").append(" LLID").append(this.getLLID());
        return sb.toString();
    }
}

