/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.ldu;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LDUMessage
extends P25Message {
    private static final Logger mLog = LoggerFactory.getLogger(LDUMessage.class);
    public static final int IMBE_FRAME_1 = 0;
    public static final int IMBE_FRAME_2 = 144;
    public static final int IMBE_FRAME_3 = 328;
    public static final int IMBE_FRAME_4 = 512;
    public static final int IMBE_FRAME_5 = 696;
    public static final int IMBE_FRAME_6 = 880;
    public static final int IMBE_FRAME_7 = 1064;
    public static final int IMBE_FRAME_8 = 1248;
    public static final int IMBE_FRAME_9 = 1424;
    public static final int[] LOW_SPEED_DATA = new int[]{1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415};

    public LDUMessage(CorrectedBinaryMessage message, int nac, long timestamp) {
        super(message, nac, timestamp);
    }

    public String getLowSpeedData() {
        return this.getMessage().getHex(LOW_SPEED_DATA, 4);
    }

    @Override
    public String getMessageStub() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessageStub());
        sb.append(" VOICE LSD:");
        sb.append(this.getLowSpeedData());
        return sb.toString();
    }

    public List<byte[]> getIMBEFrames() {
        ArrayList<byte[]> frames = new ArrayList<byte[]>();
        frames.add(this.getMessage().get(0, 144).toByteArray());
        frames.add(this.getMessage().get(144, 288).toByteArray());
        frames.add(this.getMessage().get(328, 472).toByteArray());
        frames.add(this.getMessage().get(512, 656).toByteArray());
        frames.add(this.getMessage().get(696, 840).toByteArray());
        frames.add(this.getMessage().get(880, 1024).toByteArray());
        frames.add(this.getMessage().get(1064, 1208).toByteArray());
        frames.add(this.getMessage().get(1248, 1392).toByteArray());
        frames.add(this.getMessage().get(1424, 1568).toByteArray());
        return frames;
    }
}

