/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.ldu;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.edac.Hamming10;
import io.github.dsheirer.edac.ReedSolomon_24_12_13_P25;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWordFactory;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDUMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDU1Message
extends LDUMessage
implements IFrequencyBandReceiver {
    private static final Logger mLog = LoggerFactory.getLogger(LDU1Message.class);
    private static final int[] GOLAY_WORD_STARTS = new int[]{288, 298, 308, 318, 472, 482, 492, 502, 656, 666, 676, 686, 840, 850, 860, 870, 1024, 1034, 1044, 1054, 1208, 1218, 1228, 1238};
    private static final int[] CW_HEX_0 = new int[]{288, 289, 290, 291, 292, 293};
    private static final int[] CW_HEX_1 = new int[]{298, 299, 300, 301, 302, 303};
    private static final int[] CW_HEX_2 = new int[]{308, 309, 310, 311, 312, 313};
    private static final int[] CW_HEX_3 = new int[]{318, 319, 320, 321, 322, 323};
    private static final int[] CW_HEX_4 = new int[]{472, 473, 474, 475, 475, 477};
    private static final int[] CW_HEX_5 = new int[]{482, 483, 484, 485, 486, 487};
    private static final int[] CW_HEX_6 = new int[]{492, 493, 494, 495, 496, 497};
    private static final int[] CW_HEX_7 = new int[]{502, 503, 504, 505, 506, 507};
    private static final int[] CW_HEX_8 = new int[]{656, 657, 658, 659, 660, 661};
    private static final int[] CW_HEX_9 = new int[]{666, 667, 668, 669, 670, 671};
    private static final int[] CW_HEX_10 = new int[]{676, 677, 678, 679, 680, 681};
    private static final int[] CW_HEX_11 = new int[]{686, 686, 688, 689, 690, 691};
    private static final int[] RS_HEX_0 = new int[]{840, 841, 842, 843, 844, 845};
    private static final int[] RS_HEX_1 = new int[]{850, 851, 852, 853, 854, 855};
    private static final int[] RS_HEX_2 = new int[]{860, 861, 862, 863, 864, 865};
    private static final int[] RS_HEX_3 = new int[]{870, 871, 872, 873, 874, 875};
    private static final int[] RS_HEX_4 = new int[]{1024, 1025, 1026, 1027, 1028, 1029};
    private static final int[] RS_HEX_5 = new int[]{1034, 1035, 1036, 1037, 1038, 1039};
    private static final int[] RS_HEX_6 = new int[]{1044, 1045, 1046, 1047, 1048, 1049};
    private static final int[] RS_HEX_7 = new int[]{1054, 1055, 1056, 1057, 1058, 1059};
    private static final int[] RS_HEX_8 = new int[]{1208, 1209, 1210, 1211, 1212, 1213};
    private static final int[] RS_HEX_9 = new int[]{1218, 1219, 1220, 1221, 1222, 1223};
    private static final int[] RS_HEX_10 = new int[]{1228, 1229, 1230, 1231, 1232, 1233};
    private static final int[] RS_HEX_11 = new int[]{1238, 1239, 1240, 1241, 1242, 1243};
    private static final ReedSolomon_24_12_13_P25 REED_SOLOMON_24_12_13_P25 = new ReedSolomon_24_12_13_P25();
    private LinkControlWord mLinkControlWord;
    private List<Identifier> mIdentifiers;

    public LDU1Message(CorrectedBinaryMessage message, int nac, long timestamp) {
        super(message, nac, timestamp);
    }

    @Override
    public P25P1DataUnitID getDUID() {
        return P25P1DataUnitID.LOGICAL_LINK_DATA_UNIT_1;
    }

    public LinkControlWord getLinkControlWord() {
        if (this.mLinkControlWord == null) {
            this.createLinkControlWord();
        }
        return this.mLinkControlWord;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getNAC());
            if (this.getLinkControlWord().isValid()) {
                this.mIdentifiers.addAll(this.getLinkControlWord().getIdentifiers());
            }
        }
        return this.mIdentifiers;
    }

    private void createLinkControlWord() {
        int x;
        for (int index : GOLAY_WORD_STARTS) {
            Hamming10.checkAndCorrect(this.getMessage(), index);
        }
        int[] input = new int[63];
        int[] output = new int[63];
        input[0] = this.getMessage().getInt(RS_HEX_11);
        input[1] = this.getMessage().getInt(RS_HEX_10);
        input[2] = this.getMessage().getInt(RS_HEX_9);
        input[3] = this.getMessage().getInt(RS_HEX_8);
        input[4] = this.getMessage().getInt(RS_HEX_7);
        input[5] = this.getMessage().getInt(RS_HEX_6);
        input[6] = this.getMessage().getInt(RS_HEX_5);
        input[7] = this.getMessage().getInt(RS_HEX_4);
        input[8] = this.getMessage().getInt(RS_HEX_3);
        input[9] = this.getMessage().getInt(RS_HEX_2);
        input[10] = this.getMessage().getInt(RS_HEX_1);
        input[11] = this.getMessage().getInt(RS_HEX_0);
        input[12] = this.getMessage().getInt(CW_HEX_11);
        input[13] = this.getMessage().getInt(CW_HEX_10);
        input[14] = this.getMessage().getInt(CW_HEX_9);
        input[15] = this.getMessage().getInt(CW_HEX_8);
        input[16] = this.getMessage().getInt(CW_HEX_7);
        input[17] = this.getMessage().getInt(CW_HEX_6);
        input[18] = this.getMessage().getInt(CW_HEX_5);
        input[19] = this.getMessage().getInt(CW_HEX_4);
        input[20] = this.getMessage().getInt(CW_HEX_3);
        input[21] = this.getMessage().getInt(CW_HEX_2);
        input[22] = this.getMessage().getInt(CW_HEX_1);
        input[23] = this.getMessage().getInt(CW_HEX_0);
        boolean irrecoverableErrors = REED_SOLOMON_24_12_13_P25.decode(input, output);
        BinaryMessage binaryMessage = new BinaryMessage(72);
        int pointer = 0;
        for (x = 23; x >= 12; --x) {
            if (output[x] != -1) {
                binaryMessage.load(pointer, 6, output[x]);
            } else {
                mLog.error("-1 output");
            }
            pointer += 6;
        }
        this.mLinkControlWord = LinkControlWordFactory.create(binaryMessage);
        if (irrecoverableErrors) {
            this.mLinkControlWord.setValid(false);
        }
        for (x = 0; x < 23; ++x) {
            if (output[x] == input[x]) continue;
            this.getMessage().incrementCorrectedBitCount(Integer.bitCount(output[x] ^ input[x]));
        }
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.getLinkControlWord().isValid() && this.getLinkControlWord() instanceof IFrequencyBandReceiver) {
            return ((IFrequencyBandReceiver)((Object)this.getLinkControlWord())).getChannels();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" ").append(this.getLinkControlWord());
        return sb.toString();
    }
}

