/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.standard;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class LCTelephoneInterconnectVoiceChannelUser
extends LinkControlWord {
    private static final int[] RESERVED_1 = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] RESERVED_2 = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] CALL_TIMER = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private VoiceServiceOptions mVoiceServiceOptions;
    private Identifier mAddress;
    private List<Identifier> mIdentifiers;

    public LCTelephoneInterconnectVoiceChannelUser(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" ID:").append(this.getAddress());
        sb.append(" CALL TIMER:").append(this.getCallTimerDuration()).append("MS");
        sb.append(" ").append(this.getVoiceServiceOptions());
        return sb.toString();
    }

    public VoiceServiceOptions getVoiceServiceOptions() {
        if (this.mVoiceServiceOptions == null) {
            this.mVoiceServiceOptions = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS));
        }
        return this.mVoiceServiceOptions;
    }

    public long getCallTimerDuration() {
        return this.getMessage().getInt(CALL_TIMER) * 100;
    }

    public Identifier getAddress() {
        if (this.mAddress == null) {
            this.mAddress = APCO25Talkgroup.create(this.getMessage().getInt(ADDRESS));
        }
        return this.mAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getAddress());
        }
        return this.mIdentifiers;
    }
}

