/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.standard;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.List;

public class LCSecondaryControlChannelBroadcast
extends LinkControlWord
implements IFrequencyBandReceiver {
    private static final int[] RFSS = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] SITE = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] FREQUENCY_BAND_A = new int[]{24, 25, 26, 27};
    private static final int[] CHANNEL_NUMBER_A = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SERVICE_CLASS_A = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] FREQUENCY_BAND_B = new int[]{48, 49, 50, 51};
    private static final int[] CHANNEL_NUMBER_B = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SERVICE_CLASS_B = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private List<Identifier> mIdentifiers;
    private Identifier mRFSS;
    private Identifier mSite;
    private IChannelDescriptor mChannelA;
    private IChannelDescriptor mChannelB;
    private SystemServiceClass mSystemServiceClassA;
    private SystemServiceClass mSystemServiceClassB;

    public LCSecondaryControlChannelBroadcast(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" SITE:").append(this.getRFSS()).append("-").append(this.getSite());
        sb.append(" CHAN A:").append(this.getChannelA());
        sb.append(" SERVICE CLASS:").append(this.getSystemServiceClassA());
        if (this.hasChannelB()) {
            sb.append(" CHAN B:").append(this.getChannelB());
            sb.append(" SERVICE CLASS:").append(this.getSystemServiceClassB());
        }
        return sb.toString();
    }

    public Identifier getRFSS() {
        if (this.mRFSS == null) {
            this.mRFSS = APCO25Rfss.create(this.getMessage().getInt(RFSS));
        }
        return this.mRFSS;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getMessage().getInt(SITE));
        }
        return this.mSite;
    }

    public IChannelDescriptor getChannelA() {
        if (this.mChannelA == null) {
            this.mChannelA = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_A), this.getMessage().getInt(CHANNEL_NUMBER_A));
        }
        return this.mChannelA;
    }

    private boolean hasChannelB() {
        return this.getMessage().getInt(CHANNEL_NUMBER_A) != this.getMessage().getInt(CHANNEL_NUMBER_B) && this.getMessage().getInt(SERVICE_CLASS_B) != 0;
    }

    public IChannelDescriptor getChannelB() {
        if (this.mChannelB == null) {
            this.mChannelB = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_B), this.getMessage().getInt(CHANNEL_NUMBER_B));
        }
        return this.mChannelB;
    }

    public SystemServiceClass getSystemServiceClassA() {
        if (this.mSystemServiceClassA == null) {
            this.mSystemServiceClassA = new SystemServiceClass(this.getMessage().getInt(SERVICE_CLASS_A));
        }
        return this.mSystemServiceClassA;
    }

    public SystemServiceClass getSystemServiceClassB() {
        if (this.mSystemServiceClassB == null) {
            this.mSystemServiceClassB = new SystemServiceClass(this.getMessage().getInt(SERVICE_CLASS_B));
        }
        return this.mSystemServiceClassB;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getRFSS());
            this.mIdentifiers.add(this.getSite());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannelA());
        if (this.hasChannelB()) {
            channels.add(this.getChannelB());
        }
        return channels;
    }
}

