/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.standard;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Lra;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.List;

public class LCRFSSStatusBroadcastExplicit
extends LinkControlWord
implements IFrequencyBandReceiver {
    private static final int[] LRA = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] UPLINK_FREQUENCY_BAND = new int[]{16, 17, 18, 19};
    private static final int[] UPLINK_CHANNEL_NUMBER = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] RFSS = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SITE = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] DOWNLINK_FREQUENCY_BAND = new int[]{48, 49, 50, 51};
    private static final int[] DOWNLINK_CHANNEL_NUMBER = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SERVICE_CLASS = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private List<Identifier> mIdentifiers;
    private Identifier mLRA;
    private Identifier mRFSS;
    private Identifier mSite;
    private IChannelDescriptor mChannel;
    private SystemServiceClass mSystemServiceClass;

    public LCRFSSStatusBroadcastExplicit(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" LRA:").append(this.getLocationRegistrationArea());
        sb.append(" SITE:").append(this.getRfss()).append("-").append(this.getSite());
        sb.append(" CHAN:").append(this.getChannel());
        sb.append(" SERVICE OPTIONS:").append(this.getSystemServiceClass());
        return sb.toString();
    }

    public Identifier getLocationRegistrationArea() {
        if (this.mLRA == null) {
            this.mLRA = APCO25Lra.create(this.getMessage().getInt(LRA));
        }
        return this.mLRA;
    }

    public Identifier getRfss() {
        if (this.mRFSS == null) {
            this.mRFSS = APCO25Rfss.create(this.getMessage().getInt(RFSS));
        }
        return this.mRFSS;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getMessage().getInt(SITE));
        }
        return this.mSite;
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25ExplicitChannel.create(this.getMessage().getInt(DOWNLINK_FREQUENCY_BAND), this.getMessage().getInt(DOWNLINK_CHANNEL_NUMBER), this.getMessage().getInt(UPLINK_FREQUENCY_BAND), this.getMessage().getInt(UPLINK_CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    public SystemServiceClass getSystemServiceClass() {
        if (this.mSystemServiceClass == null) {
            this.mSystemServiceClass = new SystemServiceClass(this.getMessage().getInt(SERVICE_CLASS));
        }
        return this.mSystemServiceClass;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getLocationRegistrationArea());
            this.mIdentifiers.add(this.getRfss());
            this.mIdentifiers.add(this.getSite());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

