/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.standard;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.List;

public class LCNetworkStatusBroadcast
extends LinkControlWord
implements IFrequencyBandReceiver {
    private static final int[] RESERVED = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] WACN = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    private static final int[] SYSTEM = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] FREQUENCY_BAND = new int[]{48, 49, 50, 51};
    private static final int[] CHANNEL_NUMBER = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SERVICE_CLASS = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private List<Identifier> mIdentifiers;
    private Identifier mWACN;
    private Identifier mSystem;
    private IChannelDescriptor mChannel;
    private SystemServiceClass mSystemServiceClass;

    public LCNetworkStatusBroadcast(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" WACN:").append(this.getWACN());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" CHAN:").append(this.getChannel());
        sb.append(" SERVICE OPTIONS:").append(this.getSystemServiceClass());
        return sb.toString();
    }

    public Identifier getWACN() {
        if (this.mWACN == null) {
            this.mWACN = APCO25Wacn.create(this.getMessage().getInt(WACN));
        }
        return this.mWACN;
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getMessage().getInt(SYSTEM));
        }
        return this.mSystem;
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND), this.getMessage().getInt(CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    public SystemServiceClass getSystemServiceClass() {
        if (this.mSystemServiceClass == null) {
            this.mSystemServiceClass = new SystemServiceClass(this.getMessage().getInt(SERVICE_CLASS));
        }
        return this.mSystemServiceClass;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getWACN());
            this.mIdentifiers.add(this.getSystem());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

