/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.standard;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.reference.ExtendedFunction;
import java.util.ArrayList;
import java.util.List;

public class LCExtendedFunctionCommand
extends LinkControlWord {
    private static final int[] EXTENDED_FUNCTION = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] EXTENDED_FUNCTION_ARGUMENTS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] TARGET_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;

    public LCExtendedFunctionCommand(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" ").append((Object)this.getExtendedFunction());
        sb.append(" ARGUMENTS:").append(this.getExtendedFunctionArguments());
        return sb.toString();
    }

    public ExtendedFunction getExtendedFunction() {
        return ExtendedFunction.fromValue(this.getMessage().getInt(EXTENDED_FUNCTION));
    }

    public String getExtendedFunctionArguments() {
        return this.getMessage().getHex(EXTENDED_FUNCTION_ARGUMENTS, 6);
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
        }
        return this.mIdentifiers;
    }
}

