/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.patch.APCO25PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola.MotorolaLinkControlWord;
import java.util.ArrayList;
import java.util.List;

public class LCMotorolaPatchGroupVoiceChannelUpdate
extends MotorolaLinkControlWord
implements IFrequencyBandReceiver {
    private static final int[] UNKNOWN_1 = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] PATCH_GROUP = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] UNKNOWN_2 = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] UNKNOWN_3 = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] FREQUENCY_BAND = new int[]{56, 57, 58, 59};
    private static final int[] CHANNEL_NUMBER = new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private APCO25PatchGroup mPatchGroup;
    private IChannelDescriptor mChannel;
    private List<Identifier> mIdentifiers;
    private List<IChannelDescriptor> mChannels;

    public LCMotorolaPatchGroupVoiceChannelUpdate(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MOTOROLA PATCH VOICE CHANNEL UPDATE");
        sb.append(" PATCH GROUP:").append(this.getPatchGroup());
        sb.append(" CHANNEL:").append(this.getChannel());
        sb.append(" UNK1:").append(this.getUnknownField1());
        sb.append(" UNK2:").append(this.getUnknownField2());
        sb.append(" UNK3:").append(this.getUnknownField3());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public APCO25PatchGroup getPatchGroup() {
        if (this.mPatchGroup == null) {
            PatchGroup patchGroup = new PatchGroup(APCO25Talkgroup.create(this.getMessage().getInt(PATCH_GROUP)));
            this.mPatchGroup = APCO25PatchGroup.create(patchGroup);
        }
        return this.mPatchGroup;
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND), this.getMessage().getInt(CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    public String getUnknownField1() {
        return this.getMessage().getHex(UNKNOWN_1, 2);
    }

    public String getUnknownField2() {
        return this.getMessage().getHex(UNKNOWN_2, 2);
    }

    public String getUnknownField3() {
        return this.getMessage().getHex(UNKNOWN_3, 2);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getPatchGroup());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.mChannels == null) {
            this.mChannels = new ArrayList<IChannelDescriptor>();
            this.mChannels.add(this.getChannel());
        }
        return this.mChannels;
    }
}

