/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.l3harris;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import java.util.ArrayList;
import java.util.List;

public class LCHarrisUnknownOpcode10
extends LinkControlWord {
    private static final int[] UNKNOWN_1 = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] TARGET_RADIO = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SOURCE_RADIO = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private RadioIdentifier mSourceRadio;
    private RadioIdentifier mTargetRadio;
    private List<Identifier> mIdentifiers;

    public LCHarrisUnknownOpcode10(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("**CRC-FAILED** ");
        }
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        } else {
            sb.append("L3HARRIS UNKNOWN OPCODE 10 ");
            sb.append(" FM:").append(this.getSourceRadio());
            sb.append(" TO:").append(this.getTargetRadio());
            sb.append(" UNK:").append(this.getUnknown());
            sb.append(" MSG:").append(this.getMessage().toHexString());
        }
        return sb.toString();
    }

    public String getUnknown() {
        return this.getMessage().getHex(UNKNOWN_1, 2);
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_RADIO));
        }
        return this.mSourceRadio;
    }

    public RadioIdentifier getTargetRadio() {
        if (this.mTargetRadio == null) {
            this.mTargetRadio = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_RADIO));
        }
        return this.mTargetRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSourceRadio());
        }
        return this.mIdentifiers;
    }
}

