/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.hdu;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.encryption.EncryptionKeyIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.encryption.APCO25EncryptionKey;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.reference.Encryption;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import java.util.ArrayList;
import java.util.List;

public class HeaderData {
    private static final int[] MESSAGE_INDICATOR_A = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    private static final int[] MESSAGE_INDICATOR_B = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] VENDOR_ID = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] ALGORITHM_ID = new int[]{80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] KEY_ID = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103};
    private static final int[] TALKGROUP_ID = new int[]{104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119};
    private boolean mValid = true;
    private BinaryMessage mMessage;
    private Identifier mEncryptionKey;
    private Identifier mTalkgroup;
    private List<Identifier> mIdentifiers;

    public HeaderData(BinaryMessage message) {
        this.mMessage = message;
    }

    public BinaryMessage getMessage() {
        return this.mMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isValid()) {
            sb.append("TALKGROUP:").append(this.getTalkgroup());
            Vendor vendor = this.getVendor();
            if (vendor != Vendor.STANDARD) {
                sb.append(" VENDOR:").append(vendor.getLabel());
            }
            if (this.isEncryptedAudio()) {
                sb.append(" ENCRYPTION:").append(this.getEncryptionKey());
                sb.append(" MI:").append(this.getMessageIndicator());
            } else {
                sb.append(" UNENCRYPTED");
            }
        } else {
            sb.append(" **CRC FAILED**");
        }
        return sb.toString();
    }

    public boolean isValid() {
        return this.mValid;
    }

    public void setValid(boolean valid) {
        this.mValid = valid;
    }

    public String getMessageIndicator() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_A, 9));
        sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_B, 9));
        return sb.toString();
    }

    public Vendor getVendor() {
        return Vendor.fromValue(this.getMessage().getInt(VENDOR_ID));
    }

    public Identifier getEncryptionKey() {
        if (this.mEncryptionKey == null && this.isEncryptedAudio()) {
            this.mEncryptionKey = EncryptionKeyIdentifier.create(APCO25EncryptionKey.create(this.getMessage().getInt(ALGORITHM_ID), this.getMessage().getInt(KEY_ID)));
        }
        return this.mEncryptionKey;
    }

    public Encryption getEncryption() {
        return Encryption.fromValue(this.getMessage().getInt(ALGORITHM_ID));
    }

    public boolean isEncryptedAudio() {
        return this.getEncryption() != Encryption.UNENCRYPTED;
    }

    public Identifier getTalkgroup() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = APCO25Talkgroup.create(this.getMessage().getInt(TALKGROUP_ID));
        }
        return this.mTalkgroup;
    }

    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.isValid()) {
                this.mIdentifiers.add(this.getTalkgroup());
                this.mIdentifiers.add(this.getEncryptionKey());
            }
        }
        return this.mIdentifiers;
    }
}

