/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.hdu;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.Golay18;
import io.github.dsheirer.edac.ReedSolomon_63_47_17_P25;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.hdu.HeaderData;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDUMessage
extends P25Message {
    private static final Logger mLog = LoggerFactory.getLogger(HDUMessage.class);
    private static final int[] GOLAY_WORD_STARTS = new int[]{0, 18, 36, 54, 72, 90, 108, 126, 144, 162, 180, 198, 216, 234, 252, 270, 288, 306, 324, 342, 360, 278, 396, 414, 432, 450, 468, 486, 504, 522, 540, 558, 576, 594, 612, 630};
    private static final int[] CW_HEX_0 = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static final int[] CW_HEX_1 = new int[]{18, 19, 20, 21, 22, 23};
    private static final int[] CW_HEX_2 = new int[]{36, 37, 38, 39, 40, 41};
    private static final int[] CW_HEX_3 = new int[]{54, 55, 56, 57, 58, 59};
    private static final int[] CW_HEX_4 = new int[]{72, 73, 74, 75, 76, 77};
    private static final int[] CW_HEX_5 = new int[]{90, 91, 92, 93, 94, 95};
    private static final int[] CW_HEX_6 = new int[]{108, 109, 110, 111, 112, 113};
    private static final int[] CW_HEX_7 = new int[]{126, 127, 128, 129, 130, 131};
    private static final int[] CW_HEX_8 = new int[]{144, 145, 146, 147, 148, 149};
    private static final int[] CW_HEX_9 = new int[]{162, 163, 164, 165, 166, 167};
    private static final int[] CW_HEX_10 = new int[]{180, 181, 182, 183, 184, 185};
    private static final int[] CW_HEX_11 = new int[]{198, 199, 200, 201, 202, 203};
    private static final int[] CW_HEX_12 = new int[]{216, 217, 218, 219, 220, 221};
    private static final int[] CW_HEX_13 = new int[]{234, 235, 236, 237, 238, 239};
    private static final int[] CW_HEX_14 = new int[]{252, 253, 254, 255, 256, 257};
    private static final int[] CW_HEX_15 = new int[]{270, 271, 272, 273, 274, 275};
    private static final int[] CW_HEX_16 = new int[]{288, 289, 290, 291, 292, 293};
    private static final int[] CW_HEX_17 = new int[]{306, 307, 308, 309, 310, 311};
    private static final int[] CW_HEX_18 = new int[]{324, 325, 326, 327, 328, 329};
    private static final int[] CW_HEX_19 = new int[]{342, 343, 344, 345, 346, 347};
    private static final int[] RS_HEX_0 = new int[]{360, 361, 362, 363, 364, 365};
    private static final int[] RS_HEX_1 = new int[]{378, 379, 380, 381, 382, 383};
    private static final int[] RS_HEX_2 = new int[]{396, 397, 398, 399, 400, 401};
    private static final int[] RS_HEX_3 = new int[]{414, 415, 416, 417, 418, 419};
    private static final int[] RS_HEX_4 = new int[]{432, 433, 434, 435, 436, 437};
    private static final int[] RS_HEX_5 = new int[]{450, 451, 452, 453, 454, 455};
    private static final int[] RS_HEX_6 = new int[]{468, 469, 470, 471, 472, 473};
    private static final int[] RS_HEX_7 = new int[]{486, 487, 488, 489, 490, 491};
    private static final int[] RS_HEX_8 = new int[]{504, 505, 506, 507, 508, 509};
    private static final int[] RS_HEX_9 = new int[]{522, 523, 524, 525, 526, 527};
    private static final int[] RS_HEX_10 = new int[]{540, 541, 542, 543, 544, 545};
    private static final int[] RS_HEX_11 = new int[]{558, 559, 560, 561, 562, 563};
    private static final int[] RS_HEX_12 = new int[]{576, 577, 578, 579, 580, 581};
    private static final int[] RS_HEX_13 = new int[]{594, 595, 596, 597, 598, 599};
    private static final int[] RS_HEX_14 = new int[]{612, 613, 614, 615, 616, 617};
    private static final int[] RS_HEX_15 = new int[]{630, 631, 632, 633, 634, 635};
    private static final ReedSolomon_63_47_17_P25 reedSolomon_63_47_17 = new ReedSolomon_63_47_17_P25();
    private HeaderData mHeaderData;

    public HDUMessage(CorrectedBinaryMessage message, int nac, long timestamp) {
        super(message, nac, timestamp);
    }

    @Override
    public P25P1DataUnitID getDUID() {
        return P25P1DataUnitID.HEADER_DATA_UNIT;
    }

    public HeaderData getHeaderData() {
        if (this.mHeaderData == null) {
            this.extractHeaderData();
        }
        return this.mHeaderData;
    }

    private void extractHeaderData() {
        int x;
        boolean irrecoverableErrors;
        for (int index : GOLAY_WORD_STARTS) {
            Golay18.checkAndCorrect(this.getMessage(), index);
        }
        int[] input = new int[63];
        int[] output = new int[63];
        input[0] = this.getMessage().getInt(RS_HEX_15);
        input[1] = this.getMessage().getInt(RS_HEX_14);
        input[2] = this.getMessage().getInt(RS_HEX_13);
        input[3] = this.getMessage().getInt(RS_HEX_12);
        input[4] = this.getMessage().getInt(RS_HEX_11);
        input[5] = this.getMessage().getInt(RS_HEX_10);
        input[6] = this.getMessage().getInt(RS_HEX_9);
        input[7] = this.getMessage().getInt(RS_HEX_8);
        input[8] = this.getMessage().getInt(RS_HEX_7);
        input[9] = this.getMessage().getInt(RS_HEX_6);
        input[10] = this.getMessage().getInt(RS_HEX_5);
        input[11] = this.getMessage().getInt(RS_HEX_4);
        input[12] = this.getMessage().getInt(RS_HEX_3);
        input[13] = this.getMessage().getInt(RS_HEX_2);
        input[14] = this.getMessage().getInt(RS_HEX_1);
        input[15] = this.getMessage().getInt(RS_HEX_0);
        input[16] = this.getMessage().getInt(CW_HEX_19);
        input[17] = this.getMessage().getInt(CW_HEX_18);
        input[18] = this.getMessage().getInt(CW_HEX_17);
        input[19] = this.getMessage().getInt(CW_HEX_16);
        input[20] = this.getMessage().getInt(CW_HEX_15);
        input[21] = this.getMessage().getInt(CW_HEX_14);
        input[22] = this.getMessage().getInt(CW_HEX_13);
        input[23] = this.getMessage().getInt(CW_HEX_12);
        input[24] = this.getMessage().getInt(CW_HEX_11);
        input[25] = this.getMessage().getInt(CW_HEX_10);
        input[26] = this.getMessage().getInt(CW_HEX_9);
        input[27] = this.getMessage().getInt(CW_HEX_8);
        input[28] = this.getMessage().getInt(CW_HEX_7);
        input[29] = this.getMessage().getInt(CW_HEX_6);
        input[30] = this.getMessage().getInt(CW_HEX_5);
        input[31] = this.getMessage().getInt(CW_HEX_4);
        input[32] = this.getMessage().getInt(CW_HEX_3);
        input[33] = this.getMessage().getInt(CW_HEX_2);
        input[34] = this.getMessage().getInt(CW_HEX_1);
        input[35] = this.getMessage().getInt(CW_HEX_0);
        try {
            irrecoverableErrors = reedSolomon_63_47_17.decode(input, output);
        }
        catch (Exception e) {
            irrecoverableErrors = true;
        }
        BinaryMessage binaryMessage = new BinaryMessage(120);
        int pointer = 0;
        for (x = 35; x >= 16; --x) {
            if (output[x] != -1) {
                binaryMessage.load(pointer, 6, output[x]);
            }
            pointer += 6;
        }
        this.mHeaderData = new HeaderData(binaryMessage);
        if (irrecoverableErrors) {
            this.mHeaderData.setValid(false);
        } else {
            for (x = 0; x <= 35; ++x) {
                if (output[x] == input[x]) continue;
                this.getMessage().incrementCorrectedBitCount(Integer.bitCount(output[x] ^ input[x]));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NAC:").append(this.getNAC());
        sb.append(" HDU   ").append(this.getHeaderData());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.getHeaderData().getIdentifiers();
    }
}

