/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU1Message;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU2Message;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDUMessage;
import java.util.function.Function;

public class VoiceMessageFilter
extends Filter<IMessage, String> {
    private static final String LDU1_KEY = "LDU1 Voice Message";
    private static final String LDU2_KEY = "LDU2 Voice Message";
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public VoiceMessageFilter() {
        super("Voice Messages");
        this.add(new FilterElement<String>(LDU1_KEY));
        this.add(new FilterElement<String>(LDU2_KEY));
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof LDUMessage && super.canProcess(message);
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(VoiceMessageFilter voiceMessageFilter) {
        }

        @Override
        public String apply(IMessage message) {
            if (message instanceof LDU1Message) {
                return VoiceMessageFilter.LDU1_KEY;
            }
            if (message instanceof LDU2Message) {
                return VoiceMessageFilter.LDU2_KEY;
            }
            return null;
        }
    }
}

