/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDUMessage;
import java.util.function.Function;

public class TDUMessageFilter
extends Filter<IMessage, String> {
    private static final String TDU_KEY = "Terminator Data Unit (TDU)";
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public TDUMessageFilter() {
        super("Terminator/No Link Control messages");
        this.add(new FilterElement<String>(TDU_KEY));
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof TDUMessage && super.canProcess(message);
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(TDUMessageFilter tDUMessageFilter) {
        }

        @Override
        public String apply(IMessage message) {
            if (message instanceof TDUMessage) {
                return TDUMessageFilter.TDU_KEY;
            }
            return null;
        }
    }
}

