/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.SNDCPMessage;
import io.github.dsheirer.module.decode.p25.reference.PDUType;
import java.util.function.Function;

public class SNDCPMessageFilter
extends Filter<IMessage, PDUType> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public SNDCPMessageFilter() {
        super("Sub-Network Dependent Convergence Protocol (SNDCP) Messages");
        for (PDUType pduType : PDUType.values()) {
            this.add(new FilterElement<PDUType>(pduType));
        }
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof SNDCPMessage && super.canProcess(message);
    }

    @Override
    public Function<IMessage, PDUType> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, PDUType> {
        private KeyExtractor(SNDCPMessageFilter sNDCPMessageFilter) {
        }

        @Override
        public PDUType apply(IMessage message) {
            if (message instanceof SNDCPMessage) {
                SNDCPMessage sndcp = (SNDCPMessage)((Object)message);
                return sndcp.getPDUType();
            }
            return null;
        }
    }
}

