/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDUMessage;
import java.util.function.Function;

public class PDUMessageFilter
extends Filter<IMessage, String> {
    private static final String PDU_KEY = "Packet Data Unit (PDU)";
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public PDUMessageFilter() {
        super("Packet Data Unit messages");
        this.add(new FilterElement<String>(PDU_KEY));
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof TDUMessage && super.canProcess(message);
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(PDUMessageFilter pDUMessageFilter) {
        }

        @Override
        public String apply(IMessage message) {
            if (message instanceof PDUMessage) {
                return PDUMessageFilter.PDU_KEY;
            }
            return null;
        }
    }
}

