/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.hdu.HDUMessage;
import java.util.function.Function;

public class HeaderMessageFilter
extends Filter<IMessage, String> {
    private static final String HDU_KEY = "Header Data Unit (HDU)";
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public HeaderMessageFilter() {
        super("Header Messages");
        this.add(new FilterElement<String>(HDU_KEY));
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof HDUMessage && super.canProcess(message);
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(HeaderMessageFilter headerMessageFilter) {
        }

        @Override
        public String apply(IMessage message) {
            if (message instanceof HDUMessage) {
                return HeaderMessageFilter.HDU_KEY;
            }
            return null;
        }
    }
}

