/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.UnknownP25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.hdu.HDUMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU1Message;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU2Message;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDULinkControlMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDUMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.vselp.VSELP1Message;
import io.github.dsheirer.module.decode.p25.phase1.message.vselp.VSELP2Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25MessageFactory {
    private static final Logger mLog = LoggerFactory.getLogger(P25MessageFactory.class);

    public static P25Message create(P25P1DataUnitID dataUnitID, int nac, long timestamp, CorrectedBinaryMessage message) {
        switch (dataUnitID) {
            case HEADER_DATA_UNIT: {
                return new HDUMessage(message, nac, timestamp);
            }
            case LOGICAL_LINK_DATA_UNIT_1: {
                return new LDU1Message(message, nac, timestamp);
            }
            case LOGICAL_LINK_DATA_UNIT_2: {
                return new LDU2Message(message, nac, timestamp);
            }
            case PACKET_HEADER_DATA_UNIT: {
                mLog.warn("WARNING: PDU messages must be created by the PDUMessageFactory");
                return null;
            }
            case TERMINATOR_DATA_UNIT: {
                return new TDUMessage(message, nac, timestamp);
            }
            case TERMINATOR_DATA_UNIT_LINK_CONTROL: {
                return new TDULinkControlMessage(message, nac, timestamp);
            }
            case TRUNKING_SIGNALING_BLOCK_1: 
            case TRUNKING_SIGNALING_BLOCK_2: 
            case TRUNKING_SIGNALING_BLOCK_3: {
                mLog.warn("WARNING: TSBK messages must be created by the TSBKMessageFactory");
                return null;
            }
            case VSELP1: {
                return new VSELP1Message(message, nac, timestamp);
            }
            case VSELP2: {
                return new VSELP2Message(message, nac, timestamp);
            }
        }
        return new UnknownP25Message(message, nac, timestamp, dataUnitID);
    }
}

