/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.sample.Listener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P1MessageProcessor
implements Listener<Message> {
    private static final Logger mLog = LoggerFactory.getLogger(P25P1MessageProcessor.class);
    private Listener<IMessage> mMessageListener;
    private Map<Integer, IFrequencyBand> mFrequencyBandMap = new TreeMap<Integer, IFrequencyBand>();

    @Override
    public void receive(Message message) {
        if (message.isValid()) {
            if (message instanceof IFrequencyBandReceiver) {
                IFrequencyBandReceiver receiver = (IFrequencyBandReceiver)((Object)message);
                List<IChannelDescriptor> channels = receiver.getChannels();
                for (IChannelDescriptor channel : channels) {
                    int[] frequencyBandIdentifiers;
                    for (int id : frequencyBandIdentifiers = channel.getFrequencyBandIdentifiers()) {
                        if (!this.mFrequencyBandMap.containsKey(id)) continue;
                        channel.setFrequencyBand(this.mFrequencyBandMap.get(id));
                    }
                }
            }
            if (message instanceof IFrequencyBand) {
                IFrequencyBand bandIdentifier = (IFrequencyBand)((Object)message);
                this.mFrequencyBandMap.put(bandIdentifier.getIdentifier(), bandIdentifier);
            }
        }
        if (this.mMessageListener != null) {
            this.mMessageListener.receive(message);
        }
    }

    public void dispose() {
        this.mFrequencyBandMap.clear();
        this.mMessageListener = null;
    }

    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    public void removeMessageListener() {
        this.mMessageListener = null;
    }
}

