/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.alias.id.record.Record;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupRange;
import io.github.dsheirer.bits.BitSetFullException;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.message.MessageProviderModule;
import io.github.dsheirer.message.StuffBitsMessage;
import io.github.dsheirer.message.SyncLossMessage;
import io.github.dsheirer.module.ProcessingChain;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.ipv4.IPV4Packet;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacket;
import io.github.dsheirer.module.decode.ip.udp.UDPPacket;
import io.github.dsheirer.module.decode.p25.audio.P25P1AudioModule;
import io.github.dsheirer.module.decode.p25.phase1.DecodeConfigP25Phase1;
import io.github.dsheirer.module.decode.p25.phase1.IP25P1DataUnitDetectListener;
import io.github.dsheirer.module.decode.p25.phase1.P25P1ChannelStatusProcessor;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitDetector;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DecoderState;
import io.github.dsheirer.module.decode.p25.phase1.P25P1MessageProcessor;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.P25MessageFactory;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUMessageFactory;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.PacketMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.TSBKMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.TSBKMessageFactory;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.record.AudioRecordingManager;
import io.github.dsheirer.record.binary.BinaryReader;
import io.github.dsheirer.sample.Listener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P1MessageFramer
implements Listener<Dibit>,
IP25P1DataUnitDetectListener {
    private static final Logger mLog = LoggerFactory.getLogger(P25P1MessageFramer.class);
    private P25P1DataUnitDetector mDataUnitDetector;
    private P25P1ChannelStatusProcessor mChannelStatusProcessor = new P25P1ChannelStatusProcessor();
    private Listener<Message> mMessageListener;
    private boolean mAssemblingMessage = false;
    private CorrectedBinaryMessage mBinaryMessage;
    private P25P1DataUnitID mDataUnitID;
    private PDUSequence mPDUSequence;
    private int[] mCorrectedNID;
    private int mNAC;
    private int mStatusSymbolDibitCounter = 0;
    private int mTrailingDibitsToSuppress = 0;
    private double mBitRate;
    private long mCurrentTime = System.currentTimeMillis();
    private ISyncDetectListener mSyncDetectListener;

    public P25P1MessageFramer(IPhaseLockedLoop phaseLockedLoop, int bitRate) {
        this.mDataUnitDetector = new P25P1DataUnitDetector(this, phaseLockedLoop);
        this.mBitRate = bitRate;
    }

    public P25P1MessageFramer(int bitRate) {
        this(null, bitRate);
    }

    public void setSampleRate(double sampleRate) {
        this.mDataUnitDetector.setSampleRate(sampleRate);
    }

    public void setSyncDetectListener(ISyncDetectListener syncDetectListener) {
        this.mSyncDetectListener = syncDetectListener;
    }

    private long getTimestamp() {
        return this.mCurrentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.mCurrentTime = currentTime;
    }

    private void updateBitsProcessed(int bitsProcessed) {
        if (bitsProcessed > 0) {
            this.mCurrentTime += (long)((double)bitsProcessed / this.mBitRate * 1000.0);
        }
    }

    public void setListener(Listener<Message> messageListener) {
        this.mMessageListener = messageListener;
    }

    public P25P1DataUnitDetector getDataUnitDetector() {
        return this.mDataUnitDetector;
    }

    @Override
    public void receive(Dibit dibit) {
        if (this.mAssemblingMessage) {
            if (this.mStatusSymbolDibitCounter == 35) {
                if (this.mAssemblingMessage) {
                    this.mChannelStatusProcessor.receive(dibit);
                }
                this.mStatusSymbolDibitCounter = 0;
                return;
            }
            ++this.mStatusSymbolDibitCounter;
            try {
                this.mBinaryMessage.add(dibit.getBit1());
                this.mBinaryMessage.add(dibit.getBit2());
                if (this.mBinaryMessage.isFull()) {
                    if (this.mDataUnitID.hasTrailingStatusDibit()) {
                        this.mTrailingDibitsToSuppress = 1;
                    }
                    this.dispatchMessage();
                }
            }
            catch (BitSetFullException bsfe) {
                this.reset(0);
            }
        } else {
            if (this.mTrailingDibitsToSuppress > 0) {
                --this.mTrailingDibitsToSuppress;
                this.updateBitsProcessed(2);
                return;
            }
            this.mDataUnitDetector.receive(dibit);
        }
    }

    private void dispatchMessage() {
        block22: {
            block21: {
                if (this.mMessageListener == null) break block21;
                switch (this.mDataUnitID) {
                    case PACKET_HEADER_DATA_UNIT: {
                        this.mPDUSequence = PDUMessageFactory.createPacketSequence(this.mNAC, this.mCurrentTime, this.mBinaryMessage);
                        if (this.mPDUSequence != null) {
                            if (this.mPDUSequence.getHeader().isValid() && this.mPDUSequence.getHeader().getBlocksToFollowCount() > 0) {
                                this.mDataUnitID = P25P1DataUnitID.PACKET_DATA_UNIT;
                                this.mBinaryMessage = new CorrectedBinaryMessage(P25P1DataUnitID.PACKET_DATA_UNIT.getMessageLength());
                                this.mAssemblingMessage = true;
                                break;
                            }
                            this.mTrailingDibitsToSuppress = 22;
                            this.mMessageListener.receive(PDUMessageFactory.create(this.mPDUSequence, this.mNAC, this.getTimestamp()));
                            this.reset(this.mPDUSequence.getBitsProcessedCount());
                            this.mPDUSequence = null;
                            break;
                        }
                        break block22;
                    }
                    case PACKET_DATA_UNIT: {
                        if (this.mPDUSequence != null) {
                            if (this.mPDUSequence.getHeader().isConfirmationRequired()) {
                                this.mPDUSequence.addDataBlock(PDUMessageFactory.createConfirmedDataBlock(this.mBinaryMessage));
                            } else {
                                this.mPDUSequence.addDataBlock(PDUMessageFactory.createUnconfirmedDataBlock(this.mBinaryMessage));
                            }
                            if (this.mPDUSequence.isComplete()) {
                                this.mMessageListener.receive(PDUMessageFactory.create(this.mPDUSequence, this.mNAC, this.getTimestamp()));
                                switch (this.mPDUSequence.getHeader().getBlocksToFollowCount()) {
                                    case 1: {
                                        this.mTrailingDibitsToSuppress = 29;
                                        break;
                                    }
                                    case 2: {
                                        this.mTrailingDibitsToSuppress = 1;
                                        break;
                                    }
                                    case 3: {
                                        this.mTrailingDibitsToSuppress = 8;
                                        break;
                                    }
                                    case 4: {
                                        this.mTrailingDibitsToSuppress = 15;
                                        break;
                                    }
                                    case 5: {
                                        this.mTrailingDibitsToSuppress = 22;
                                        break;
                                    }
                                }
                                this.reset(this.mPDUSequence.getBitsProcessedCount());
                                break;
                            }
                            this.mDataUnitID = P25P1DataUnitID.PACKET_DATA_UNIT;
                            this.mBinaryMessage = new CorrectedBinaryMessage(P25P1DataUnitID.PACKET_DATA_UNIT.getMessageLength());
                            this.mAssemblingMessage = true;
                            break;
                        }
                        this.reset(this.mDataUnitID.getMessageLength());
                        break;
                    }
                    case TRUNKING_SIGNALING_BLOCK_1: 
                    case TRUNKING_SIGNALING_BLOCK_2: 
                    case TRUNKING_SIGNALING_BLOCK_3: {
                        TSBKMessage tsbkMessage = TSBKMessageFactory.create(this.mChannelStatusProcessor.getDirection(), this.mDataUnitID, this.mBinaryMessage, this.mNAC, this.getTimestamp());
                        int messageLength = this.mDataUnitID.getMessageLength();
                        this.mMessageListener.receive(tsbkMessage);
                        if (tsbkMessage.isLastBlock()) {
                            this.reset(messageLength);
                            this.mTrailingDibitsToSuppress = 1;
                            break;
                        }
                        this.updateBitsProcessed(messageLength);
                        this.mBinaryMessage = new CorrectedBinaryMessage(messageLength);
                        if (this.mDataUnitID == P25P1DataUnitID.TRUNKING_SIGNALING_BLOCK_1) {
                            this.mDataUnitID = P25P1DataUnitID.TRUNKING_SIGNALING_BLOCK_2;
                            break;
                        }
                        if (this.mDataUnitID == P25P1DataUnitID.TRUNKING_SIGNALING_BLOCK_2) {
                            this.mDataUnitID = P25P1DataUnitID.TRUNKING_SIGNALING_BLOCK_3;
                            break;
                        }
                        break block22;
                    }
                    default: {
                        P25Message message = P25MessageFactory.create(this.mDataUnitID, this.mNAC, this.getTimestamp(), this.mBinaryMessage);
                        this.mMessageListener.receive(message);
                        this.reset(this.mDataUnitID.getMessageLength());
                        break;
                    }
                }
                break block22;
            }
            this.reset(0);
        }
    }

    private void reset(int bitsProcessed) {
        this.updateBitsProcessed(bitsProcessed);
        this.mPDUSequence = null;
        this.mBinaryMessage = null;
        this.mAssemblingMessage = false;
        this.mDataUnitID = null;
        this.mNAC = 0;
        this.mDataUnitDetector.reset();
        this.mStatusSymbolDibitCounter = 0;
    }

    @Override
    public void receive(ByteBuffer buffer) {
        for (byte value : buffer.array()) {
            for (int x = 0; x <= 3; ++x) {
                this.receive(Dibit.parse(value, x));
            }
        }
    }

    @Override
    public void dataUnitDetected(P25P1DataUnitID dataUnitID, int nac, int bitErrors, int discardedDibits, int[] correctedNid) {
        if (discardedDibits > 0) {
            this.dispatchSyncLoss(discardedDibits * 2);
        }
        if (dataUnitID.getMessageLength() < 0) {
            this.dispatchSyncLoss(112);
            return;
        }
        if (this.mSyncDetectListener != null) {
            this.mSyncDetectListener.syncDetected(bitErrors);
        }
        this.mDataUnitID = dataUnitID;
        this.mNAC = nac;
        this.mCorrectedNID = correctedNid;
        this.mBinaryMessage = new CorrectedBinaryMessage(dataUnitID.getMessageLength());
        this.mBinaryMessage.incrementCorrectedBitCount(bitErrors);
        this.mAssemblingMessage = true;
        this.mStatusSymbolDibitCounter = 21;
    }

    @Override
    public void syncLost(int bitsProcessed) {
        this.dispatchSyncLoss(bitsProcessed);
        if (this.mSyncDetectListener != null) {
            this.mSyncDetectListener.syncLost(bitsProcessed);
        }
    }

    private void dispatchSyncLoss(int bitsProcessed) {
        this.updateBitsProcessed(bitsProcessed);
        if (bitsProcessed > 0 && this.mMessageListener != null) {
            if (bitsProcessed < 64) {
                this.mMessageListener.receive(new StuffBitsMessage(this.getTimestamp(), bitsProcessed, Protocol.APCO25));
            } else {
                this.mMessageListener.receive(new SyncLossMessage(this.getTimestamp(), bitsProcessed, Protocol.APCO25));
            }
        }
    }

    public static void main(String[] args) {
        Path directory = Paths.get("/home/denny/Documents/TMR/APCO25/GPS/bkmzk007", new String[0]);
        UserPreferences userPreferences = new UserPreferences();
        Channel channel = new Channel("Phase 1 Test");
        channel.setDecodeConfiguration(new DecodeConfigP25Phase1());
        AliasList aliasList = new AliasList("Test Alias List");
        Alias alias = new Alias("TG Range 1-65535");
        alias.addAliasID(new Record());
        alias.addAliasID(new TalkgroupRange(Protocol.APCO25, 1, 65535));
        aliasList.addAlias(alias);
        AudioRecordingManager recordingManager = new AudioRecordingManager(userPreferences);
        recordingManager.start();
        ProcessingChain processingChain = new ProcessingChain(channel, new AliasModel());
        processingChain.addAudioSegmentListener(recordingManager);
        processingChain.addModule(new P25P1DecoderState(channel));
        processingChain.addModule(new P25P1AudioModule(userPreferences, aliasList));
        final MessageProviderModule messageProviderModule = new MessageProviderModule();
        processingChain.addModule(messageProviderModule);
        mLog.info("Processing Directory: " + directory.toString());
        try (final OutputStream logOutput = Files.newOutputStream(directory.resolve("log.txt"), new OpenOption[0]);){
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(directory, "*.bits");
                stream.forEach(new Consumer<Path>(){

                    @Override
                    public void accept(Path path) {
                        mLog.debug("Processing:" + path.toString());
                        try {
                            logOutput.write(("Processing:" + path.toString() + "\n").getBytes());
                        }
                        catch (IOException ioe) {
                            mLog.error("Error", (Throwable)ioe);
                        }
                        P25P1MessageFramer messageFramer = new P25P1MessageFramer(null, DecoderType.P25_PHASE1.getProtocol().getBitRate());
                        P25P1MessageProcessor messageProcessor = new P25P1MessageProcessor();
                        messageFramer.setListener(messageProcessor);
                        messageProcessor.setMessageListener(new Listener<IMessage>(){

                            @Override
                            public void receive(IMessage message) {
                                if (!(message instanceof StuffBitsMessage)) {
                                    messageProviderModule.receive(message);
                                    try {
                                        UDPPacket udp;
                                        IPacket iPacket;
                                        IPV4Packet ipv4;
                                        IPacket iPacket2;
                                        PacketMessage packet;
                                        IPacket iPacket3;
                                        logOutput.write(message.toString().getBytes());
                                        logOutput.write("\n".getBytes());
                                        if (message instanceof PacketMessage && (iPacket3 = (packet = (PacketMessage)message).getPacket()) instanceof IPV4Packet && (iPacket2 = (ipv4 = (IPV4Packet)iPacket3).getPayload()) instanceof UDPPacket && (iPacket = (udp = (UDPPacket)iPacket2).getPayload()) instanceof LRRPPacket) {
                                            LRRPPacket lrrp = (LRRPPacket)iPacket;
                                            logOutput.write("\n".getBytes());
                                            logOutput.write(lrrp.getMessage().toHexString().getBytes());
                                            logOutput.write("\n\n".getBytes());
                                        }
                                    }
                                    catch (IOException ioe) {
                                        mLog.error("Error", (Throwable)ioe);
                                    }
                                    if (!(message instanceof SyncLossMessage)) {
                                        mLog.debug(message.toString());
                                    }
                                }
                            }
                        });
                        try (BinaryReader reader = new BinaryReader(path, 200);){
                            while (reader.hasNext()) {
                                ByteBuffer buffer = reader.next();
                                messageFramer.receive(buffer);
                            }
                        }
                        catch (Exception ioe) {
                            ioe.printStackTrace();
                        }
                    }
                });
            }
            catch (IOException ioe) {
                mLog.error("Error", (Throwable)ioe);
            }
        }
        catch (IOException ioe) {
            mLog.error("Error", (Throwable)ioe);
        }
        mLog.info("Finished!");
    }
}

