/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.channel.state.ChangeChannelTimeoutEvent;
import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.IChannelEventListener;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.encryption.EncryptionKey;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.patch.PatchGroupManager;
import io.github.dsheirer.identifier.patch.PatchGroupPreLoadDataContent;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.event.PlottableDecodeEvent;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.UnknownPacket;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPPacket;
import io.github.dsheirer.module.decode.ip.icmp.ICMPPacket;
import io.github.dsheirer.module.decode.ip.ipv4.IPV4Packet;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacket;
import io.github.dsheirer.module.decode.ip.udp.UDPPacket;
import io.github.dsheirer.module.decode.p25.P25DecodeEvent;
import io.github.dsheirer.module.decode.p25.P25TrafficChannelManager;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.P25Channel;
import io.github.dsheirer.module.decode.p25.phase1.DecodeConfigP25Phase1;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import io.github.dsheirer.module.decode.p25.phase1.P25P1NetworkConfigurationMonitor;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.hdu.HDUMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.hdu.HeaderData;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola.LCMotorolaUnitGPS;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCCallTermination;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCExtendedFunctionCommand;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCMessageUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCStatusUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCTelephoneInterconnectAnswerRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.EncryptionSyncParameters;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU1Message;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU2Message;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp.AMBTCAuthenticationResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp.AMBTCIndividualDataServiceRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp.AMBTCLocationRegistrationRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp.AMBTCMessageUpdateRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp.AMBTCStatusQueryResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp.AMBTCStatusUpdateRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp.AMBTCUnitAcknowledgeResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp.AMBTCUnitToUnitVoiceServiceAnswerResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp.AMBTCUnitToUnitVoiceServiceRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCGroupAffiliationResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCGroupDataChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCGroupVoiceChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCIndividualDataChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCMessageUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCProtectionParameterBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCStatusUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCTelephoneInterconnectChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCTelephoneInterconnectChannelGrantUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCUnitRegistrationResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCUnitToUnitVoiceServiceChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCUnitToUnitVoiceServiceChannelGrantUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.PacketMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.SNDCPPacketMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.umbtc.isp.UMBTCTelephoneInterconnectRequestExplicitDialing;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDULinkControlMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.Opcode;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.TSBKMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.harris.osp.HarrisGroupRegroupExplicitEncryptionCommand;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.motorola.osp.MotorolaDenyResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.motorola.osp.PatchGroupVoiceChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.motorola.osp.PatchGroupVoiceChannelGrantUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.CancelServiceRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.ExtendedFunctionResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.GroupAffiliationQueryResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.GroupDataServiceRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.GroupVoiceServiceRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.IndividualDataServiceRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.LocationRegistrationRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.MessageUpdateRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.SNDCPDataChannelRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.SNDCPDataPageResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.SNDCPReconnectRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.StatusQueryResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.StatusUpdateRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.TelephoneInterconnectAnswerResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.UnitAcknowledgeResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.UnitRegistrationRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.UnitToUnitVoiceServiceAnswerResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp.UnitToUnitVoiceServiceRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.AcknowledgeResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.DenyResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.ExtendedFunctionCommand;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.GroupAffiliationResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.GroupDataChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.GroupVoiceChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.GroupVoiceChannelGrantUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.GroupVoiceChannelGrantUpdateExplicit;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.LocationRegistrationResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.MessageUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.QueuedResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.RoamingAddressCommand;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.SNDCPDataChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.StatusUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.TelephoneInterconnectAnswerRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.TelephoneInterconnectVoiceChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.TelephoneInterconnectVoiceChannelGrantUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.UnitRegistrationResponse;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.UnitToUnitVoiceChannelGrant;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.UnitToUnitVoiceChannelGrantUpdate;
import io.github.dsheirer.module.decode.p25.reference.Encryption;
import io.github.dsheirer.module.decode.p25.reference.ServiceOptions;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.util.PacketUtil;
import java.util.List;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P1DecoderState
extends DecoderState
implements IChannelEventListener {
    private static final Logger mLog = LoggerFactory.getLogger(P25P1DecoderState.class);
    private Channel.ChannelType mChannelType;
    private P25P1Decoder.Modulation mModulation;
    private PatchGroupManager mPatchGroupManager = new PatchGroupManager();
    private P25P1NetworkConfigurationMonitor mNetworkConfigurationMonitor;
    private P25TrafficChannelManager mTrafficChannelManager;
    private Listener<ChannelEvent> mChannelEventListener;
    private DecodeEvent mCurrentCallEvent;

    public P25P1DecoderState(Channel channel, P25TrafficChannelManager trafficChannelManager) {
        this.mChannelType = channel.getChannelType();
        this.mModulation = ((DecodeConfigP25Phase1)channel.getDecodeConfiguration()).getModulation();
        this.mNetworkConfigurationMonitor = new P25P1NetworkConfigurationMonitor(this.mModulation);
        if (trafficChannelManager != null) {
            this.mTrafficChannelManager = trafficChannelManager;
            this.mChannelEventListener = trafficChannelManager.getChannelEventListener();
        } else {
            this.mChannelEventListener = channelEvent -> {};
        }
    }

    public P25P1DecoderState(Channel channel) {
        this(channel, null);
    }

    public P25P1Decoder.Modulation getModulation() {
        return this.mModulation;
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.P25_PHASE1;
    }

    @Override
    public Listener<ChannelEvent> getChannelEventListener() {
        return this.mChannelEventListener;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetState();
    }

    @Override
    protected void resetState() {
        super.resetState();
        if (this.mCurrentCallEvent != null) {
            this.mCurrentCallEvent.end(System.currentTimeMillis());
            this.broadcast(this.mCurrentCallEvent);
            this.mCurrentCallEvent = null;
        }
    }

    @Subscribe
    public void process(PatchGroupPreLoadDataContent preLoadDataContent) {
        for (Identifier identifier : ((IdentifierCollection)preLoadDataContent.getData()).getIdentifiers(Role.TO)) {
            if (!(identifier instanceof PatchGroupIdentifier)) continue;
            PatchGroupIdentifier patchGroupIdentifier = (PatchGroupIdentifier)identifier;
            this.mPatchGroupManager.addPatchGroup(patchGroupIdentifier);
        }
    }

    @Override
    public void receive(IMessage iMessage) {
        if (iMessage instanceof P25Message) {
            P25Message message = (P25Message)iMessage;
            this.getIdentifierCollection().update(message.getNAC());
            switch (message.getDUID()) {
                case ALTERNATE_MULTI_BLOCK_TRUNKING_CONTROL: {
                    this.processAMBTC(message);
                    break;
                }
                case HEADER_DATA_UNIT: {
                    this.processHDU((HDUMessage)message);
                    break;
                }
                case IP_PACKET_DATA: {
                    this.processPacketData(message);
                    break;
                }
                case LOGICAL_LINK_DATA_UNIT_1: 
                case LOGICAL_LINK_DATA_UNIT_2: {
                    this.processLDU(message);
                    break;
                }
                case PACKET_DATA_UNIT: {
                    this.processPDU(message);
                    break;
                }
                case SUBNETWORK_DEPENDENT_CONVERGENCE_PROTOCOL: {
                    this.processSNDCP(message);
                    break;
                }
                case TERMINATOR_DATA_UNIT: {
                    this.processTDU(message);
                    break;
                }
                case TERMINATOR_DATA_UNIT_LINK_CONTROL: {
                    this.processTDULC(message);
                    break;
                }
                case TRUNKING_SIGNALING_BLOCK_1: 
                case TRUNKING_SIGNALING_BLOCK_2: 
                case TRUNKING_SIGNALING_BLOCK_3: {
                    this.processTSBK(message);
                    break;
                }
                case UNCONFIRMED_MULTI_BLOCK_TRUNKING_CONTROL: {
                    this.processUMBTC(message);
                    break;
                }
            }
        }
    }

    private void processChannelGrant(APCO25Channel apco25Channel, ServiceOptions serviceOptions, IdentifierCollection identifierCollection, Opcode opcode, long timestamp) {
        if (this.mTrafficChannelManager != null && ((P25Channel)apco25Channel.getValue()).getFrequencyBand() != null) {
            this.mTrafficChannelManager.processChannelGrant(apco25Channel, serviceOptions, identifierCollection, opcode, timestamp);
        }
    }

    private void processAMBTC(P25Message message) {
        if (message instanceof AMBTCMessage && message.isValid()) {
            AMBTCMessage ambtc = (AMBTCMessage)message;
            switch (ambtc.getHeader().getOpcode()) {
                case ISP_AUTHENTICATION_RESPONSE: {
                    this.processAMBTCIspAuthenticationResponse(message, ambtc);
                    break;
                }
                case ISP_CALL_ALERT_REQUEST: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.REQUEST, "CALL ALERT");
                    break;
                }
                case ISP_GROUP_AFFILIATION_REQUEST: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.REQUEST, "GROUP AFFILIATION");
                    break;
                }
                case ISP_INDIVIDUAL_DATA_SERVICE_REQUEST: {
                    if (!(ambtc instanceof AMBTCIndividualDataServiceRequest)) break;
                    AMBTCIndividualDataServiceRequest idsr = (AMBTCIndividualDataServiceRequest)ambtc;
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.REQUEST, "INDIVIDUAL DATA SERVICE " + String.valueOf(idsr.getDataServiceOptions()));
                    break;
                }
                case ISP_LOCATION_REGISTRATION_REQUEST: {
                    if (!(ambtc instanceof AMBTCLocationRegistrationRequest)) break;
                    AMBTCLocationRegistrationRequest lrr = (AMBTCLocationRegistrationRequest)ambtc;
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.REQUEST, "LOCATION REGISTRATION - UNIQUE ID:" + String.valueOf(lrr.getSourceId()));
                    break;
                }
                case ISP_MESSAGE_UPDATE_REQUEST: {
                    if (!(ambtc instanceof AMBTCMessageUpdateRequest)) break;
                    AMBTCMessageUpdateRequest mur = (AMBTCMessageUpdateRequest)ambtc;
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.SDM, "MESSAGE:" + String.valueOf(mur.getShortDataMessage()));
                    break;
                }
                case ISP_ROAMING_ADDRESS_REQUEST: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.REQUEST, "ROAMING ADDRESS");
                    break;
                }
                case ISP_STATUS_QUERY_REQUEST: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.REQUEST, "STATUS QUERY");
                    break;
                }
                case ISP_STATUS_QUERY_RESPONSE: {
                    this.processAMBTCStatusQueryResponse(ambtc);
                    break;
                }
                case ISP_STATUS_UPDATE_REQUEST: {
                    this.processAMBTCStatusUpdateRequest(ambtc);
                    break;
                }
                case ISP_UNIT_ACKNOWLEDGE_RESPONSE: {
                    if (!(ambtc instanceof AMBTCUnitAcknowledgeResponse)) break;
                    AMBTCUnitAcknowledgeResponse uar = (AMBTCUnitAcknowledgeResponse)ambtc;
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.RESPONSE, "ACKNOWLEDGE:" + String.valueOf((Object)uar.getAcknowledgedService()));
                    break;
                }
                case ISP_UNIT_TO_UNIT_VOICE_SERVICE_REQUEST: {
                    if (!(ambtc instanceof AMBTCUnitToUnitVoiceServiceRequest)) break;
                    AMBTCUnitToUnitVoiceServiceRequest uuvsr = (AMBTCUnitToUnitVoiceServiceRequest)ambtc;
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.REQUEST, "UNIT-2-UNIT VOICE SERVICE " + String.valueOf(uuvsr.getVoiceServiceOptions()));
                    break;
                }
                case ISP_UNIT_TO_UNIT_ANSWER_RESPONSE: {
                    this.processAMBTCUnitToUnitAnswerResponse(ambtc);
                    break;
                }
                case OSP_ADJACENT_STATUS_BROADCAST: {
                    this.mNetworkConfigurationMonitor.process(ambtc);
                    break;
                }
                case OSP_NETWORK_STATUS_BROADCAST: {
                    this.mNetworkConfigurationMonitor.process(ambtc);
                    break;
                }
                case OSP_RFSS_STATUS_BROADCAST: {
                    this.mNetworkConfigurationMonitor.process(ambtc);
                    break;
                }
                case OSP_GROUP_DATA_CHANNEL_GRANT: {
                    this.processAMBTCGroupDataChannelGrant(ambtc);
                    break;
                }
                case OSP_GROUP_VOICE_CHANNEL_GRANT: {
                    this.processAMBTCGroupVoiceChannelGrant(ambtc);
                    break;
                }
                case OSP_INDIVIDUAL_DATA_CHANNEL_GRANT: {
                    this.processAMBTCIndividualDataChannelGrant(ambtc);
                    break;
                }
                case OSP_TELEPHONE_INTERCONNECT_VOICE_CHANNEL_GRANT: {
                    this.processAMBTCTelephoneInterconnectVoiceChannelGrant(ambtc);
                    break;
                }
                case OSP_TELEPHONE_INTERCONNECT_VOICE_CHANNEL_GRANT_UPDATE: {
                    this.processAMBTCTelephoneInterconnectVoiceChannelGrantUpdate(ambtc);
                    break;
                }
                case OSP_UNIT_TO_UNIT_VOICE_CHANNEL_GRANT: {
                    this.processAMBTCUnitToUnitVoiceChannelGrant(ambtc);
                    break;
                }
                case OSP_UNIT_TO_UNIT_VOICE_CHANNEL_GRANT_UPDATE: {
                    this.processAMBTCUnitToUnitVoiceChannelGrantUpdate(ambtc);
                    break;
                }
                case OSP_UNIT_TO_UNIT_ANSWER_REQUEST: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.PAGE, "ANSWER REQUEST");
                    break;
                }
                case OSP_CALL_ALERT: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.PAGE, "CALL ALERT");
                    break;
                }
                case OSP_GROUP_AFFILIATION_QUERY: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.QUERY, "GROUP AFFILIATION");
                    break;
                }
                case OSP_GROUP_AFFILIATION_RESPONSE: {
                    this.processAMBTCGroupAffiliationResponse(ambtc);
                    break;
                }
                case OSP_MESSAGE_UPDATE: {
                    if (!(ambtc instanceof AMBTCMessageUpdate)) break;
                    AMBTCMessageUpdate mu = (AMBTCMessageUpdate)ambtc;
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.SDM, "MESSAGE:" + String.valueOf(mu.getShortDataMessage()));
                    break;
                }
                case OSP_PROTECTION_PARAMETER_BROADCAST: {
                    this.processAMBTCProtectionParameterBroadcast(ambtc);
                    break;
                }
                case OSP_ROAMING_ADDRESS_UPDATE: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.RESPONSE, "ROAMING ADDRESS UPDATE");
                    break;
                }
                case OSP_ROAMING_ADDRESS_COMMAND: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.COMMAND, "ROAMING ADDRESS");
                    break;
                }
                case OSP_STATUS_QUERY: {
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.QUERY, "STATUS");
                    break;
                }
                case OSP_STATUS_UPDATE: {
                    this.processAMBTCStatusUpdate(ambtc);
                    break;
                }
                case OSP_UNIT_REGISTRATION_RESPONSE: {
                    if (!(ambtc instanceof AMBTCUnitRegistrationResponse)) break;
                    AMBTCUnitRegistrationResponse urr = (AMBTCUnitRegistrationResponse)ambtc;
                    this.processBroadcast(ambtc.getIdentifiers(), ambtc.getTimestamp(), DecodeEventType.REGISTER, String.valueOf((Object)urr.getResponse()) + " UNIT REGISTRATION");
                    break;
                }
                default: {
                    mLog.debug("Unrecognized AMBTC Opcode: " + ambtc.getHeader().getOpcode().name());
                }
            }
        }
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.CONTROL));
    }

    private void processAMBTCStatusUpdate(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCStatusUpdate) {
            AMBTCStatusUpdate su = (AMBTCStatusUpdate)ambtc;
            this.processBroadcast(ambtc, DecodeEventType.STATUS, "UNIT:" + String.valueOf(su.getUnitStatus()) + " USER:" + String.valueOf(su.getUserStatus()));
        }
    }

    private void processAMBTCProtectionParameterBroadcast(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCProtectionParameterBroadcast) {
            AMBTCProtectionParameterBroadcast ppb = (AMBTCProtectionParameterBroadcast)ambtc;
            this.processBroadcast(ambtc, DecodeEventType.RESPONSE, "USE ENCRYPTION " + String.valueOf(ppb.getEncryptionKey()) + " OUTBOUND MI:" + ppb.getOutboundMessageIndicator() + " INBOUND MI:" + ppb.getInboundMessageIndicator());
        }
    }

    private void processAMBTCGroupAffiliationResponse(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCGroupAffiliationResponse) {
            AMBTCGroupAffiliationResponse gar = (AMBTCGroupAffiliationResponse)ambtc;
            this.processBroadcast(ambtc, DecodeEventType.RESPONSE, "AFFILIATION GROUP:" + String.valueOf(gar.getGroupId()) + " ANNOUNCEMENT GROUP:" + String.valueOf(gar.getAnnouncementGroupId()));
        }
    }

    private void processAMBTCUnitToUnitVoiceChannelGrantUpdate(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCUnitToUnitVoiceServiceChannelGrantUpdate) {
            AMBTCUnitToUnitVoiceServiceChannelGrantUpdate uuvscgu = (AMBTCUnitToUnitVoiceServiceChannelGrantUpdate)ambtc;
            MutableIdentifierCollection identifierCollection = this.getMutableIdentifierCollection(uuvscgu.getIdentifiers());
            this.processChannelGrant(uuvscgu.getChannel(), uuvscgu.getVoiceServiceOptions(), identifierCollection, ambtc.getHeader().getOpcode(), ambtc.getTimestamp());
        }
    }

    private void processAMBTCUnitToUnitVoiceChannelGrant(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCUnitToUnitVoiceServiceChannelGrant) {
            AMBTCUnitToUnitVoiceServiceChannelGrant uuvscg = (AMBTCUnitToUnitVoiceServiceChannelGrant)ambtc;
            MutableIdentifierCollection identifierCollection = this.getMutableIdentifierCollection(uuvscg.getIdentifiers());
            this.processChannelGrant(uuvscg.getChannel(), uuvscg.getVoiceServiceOptions(), identifierCollection, ambtc.getHeader().getOpcode(), ambtc.getTimestamp());
        }
    }

    private void processAMBTCTelephoneInterconnectVoiceChannelGrantUpdate(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCTelephoneInterconnectChannelGrantUpdate) {
            AMBTCTelephoneInterconnectChannelGrantUpdate ticgu = (AMBTCTelephoneInterconnectChannelGrantUpdate)ambtc;
            MutableIdentifierCollection identifierCollection = this.getMutableIdentifierCollection(ticgu.getIdentifiers());
            this.processChannelGrant(ticgu.getChannel(), ticgu.getVoiceServiceOptions(), identifierCollection, ambtc.getHeader().getOpcode(), ambtc.getTimestamp());
        }
    }

    private void processAMBTCTelephoneInterconnectVoiceChannelGrant(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCTelephoneInterconnectChannelGrant) {
            AMBTCTelephoneInterconnectChannelGrant ticg = (AMBTCTelephoneInterconnectChannelGrant)ambtc;
            MutableIdentifierCollection identifierCollection = this.getMutableIdentifierCollection(ticg.getIdentifiers());
            this.processChannelGrant(ticg.getChannel(), ticg.getVoiceServiceOptions(), identifierCollection, ambtc.getHeader().getOpcode(), ambtc.getTimestamp());
        }
    }

    private void processAMBTCIndividualDataChannelGrant(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCIndividualDataChannelGrant) {
            AMBTCIndividualDataChannelGrant idcg = (AMBTCIndividualDataChannelGrant)ambtc;
            MutableIdentifierCollection identifierCollection = this.getMutableIdentifierCollection(idcg.getIdentifiers());
            this.processChannelGrant(idcg.getChannel(), idcg.getDataServiceOptions(), identifierCollection, ambtc.getHeader().getOpcode(), ambtc.getTimestamp());
        }
    }

    private void processAMBTCGroupVoiceChannelGrant(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCGroupVoiceChannelGrant) {
            AMBTCGroupVoiceChannelGrant gvcg = (AMBTCGroupVoiceChannelGrant)ambtc;
            MutableIdentifierCollection identifierCollection = this.getMutableIdentifierCollection(gvcg.getIdentifiers());
            this.processChannelGrant(gvcg.getChannel(), gvcg.getVoiceServiceOptions(), identifierCollection, ambtc.getHeader().getOpcode(), ambtc.getTimestamp());
        }
    }

    private void processAMBTCGroupDataChannelGrant(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCGroupDataChannelGrant) {
            AMBTCGroupDataChannelGrant gdcg = (AMBTCGroupDataChannelGrant)ambtc;
            MutableIdentifierCollection identifierCollection = this.getMutableIdentifierCollection(gdcg.getIdentifiers());
            this.processChannelGrant(gdcg.getChannel(), gdcg.getDataServiceOptions(), identifierCollection, ambtc.getHeader().getOpcode(), ambtc.getTimestamp());
        }
    }

    private void processAMBTCUnitToUnitAnswerResponse(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCUnitToUnitVoiceServiceAnswerResponse) {
            AMBTCUnitToUnitVoiceServiceAnswerResponse uuvsar = (AMBTCUnitToUnitVoiceServiceAnswerResponse)ambtc;
            this.processBroadcast(ambtc, DecodeEventType.RESPONSE, String.valueOf((Object)uuvsar.getAnswerResponse()) + " UNIT-2-UNIT VOICE SERVICE " + String.valueOf(uuvsar.getVoiceServiceOptions()));
        }
    }

    private void processAMBTCStatusUpdateRequest(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCStatusUpdateRequest) {
            AMBTCStatusUpdateRequest sur = (AMBTCStatusUpdateRequest)ambtc;
            this.processBroadcast(ambtc, DecodeEventType.STATUS, "UNIT:" + String.valueOf(sur.getUnitStatus()) + " USER:" + String.valueOf(sur.getUserStatus()));
        }
    }

    private void processAMBTCStatusQueryResponse(AMBTCMessage ambtc) {
        if (ambtc instanceof AMBTCStatusQueryResponse) {
            AMBTCStatusQueryResponse sqr = (AMBTCStatusQueryResponse)ambtc;
            this.processBroadcast(ambtc, DecodeEventType.STATUS, "UNIT:" + String.valueOf(sqr.getUnitStatus()) + " USER:" + String.valueOf(sqr.getUserStatus()));
        }
    }

    private void processBroadcast(AMBTCMessage ambtcMessage, DecodeEventType request, String details) {
        this.processBroadcast(ambtcMessage.getIdentifiers(), ambtcMessage.getTimestamp(), request, details);
    }

    private void processBroadcast(TSBKMessage tsbkMessage, DecodeEventType request, String details) {
        this.processBroadcast(tsbkMessage.getIdentifiers(), tsbkMessage.getTimestamp(), request, details);
    }

    private void processBroadcast(List<Identifier> identifiers, long timestamp, DecodeEventType request, String s) {
        MutableIdentifierCollection requestCollection = this.getMutableIdentifierCollection(identifiers);
        this.broadcast(P25DecodeEvent.builder(request, timestamp).channel(this.getCurrentChannel()).details(s).identifiers(requestCollection).build());
    }

    private MutableIdentifierCollection getMutableIdentifierCollection(List<Identifier> identifiers) {
        MutableIdentifierCollection requestCollection = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
        requestCollection.remove(IdentifierClass.USER);
        requestCollection.update(identifiers);
        return requestCollection;
    }

    private void processAMBTCIspAuthenticationResponse(P25Message message, AMBTCMessage ambtc) {
        if (message instanceof AMBTCAuthenticationResponse) {
            AMBTCAuthenticationResponse ar = (AMBTCAuthenticationResponse)ambtc;
            this.processBroadcast(ambtc, DecodeEventType.RESPONSE, "AUTHENTICATION:" + ar.getAuthenticationValue());
        }
    }

    private void processHDU(HDUMessage message) {
        HeaderData headerData;
        if (message.isValid() && (headerData = message.getHeaderData()).isValid()) {
            this.closeCurrentCallEvent(message.getTimestamp());
            for (Identifier identifier : headerData.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
            this.updateCurrentCall(headerData.isEncryptedAudio() ? DecodeEventType.CALL_ENCRYPTED : DecodeEventType.CALL, null, message.getTimestamp());
            return;
        }
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.ACTIVE));
    }

    private void processLDU(P25Message message) {
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.CALL));
        if (message instanceof LDU1Message) {
            LinkControlWord lcw = ((LDU1Message)message).getLinkControlWord();
            if (lcw != null && lcw.isValid()) {
                this.processLinkControl(lcw, message.getTimestamp());
            }
            this.updateCurrentCall(DecodeEventType.CALL, null, message.getTimestamp());
        } else if (message instanceof LDU2Message) {
            EncryptionSyncParameters esp = ((LDU2Message)message).getEncryptionSyncParameters();
            if (esp != null && esp.isValid()) {
                this.processEncryptionSyncParameters(esp, message.getTimestamp());
            }
            this.updateCurrentCall(DecodeEventType.CALL, null, message.getTimestamp());
        }
    }

    private void processTDULC(P25Message message) {
        LinkControlWord lcw;
        this.closeCurrentCallEvent(message.getTimestamp());
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.ACTIVE));
        if (message instanceof TDULinkControlMessage && (lcw = ((TDULinkControlMessage)message).getLinkControlWord()) != null && lcw.isValid()) {
            this.processLinkControl(lcw, message.getTimestamp());
        }
    }

    private void updateCurrentCall(DecodeEventType decodeEventType, String details, long timestamp) {
        if (this.mCurrentCallEvent == null) {
            this.mCurrentCallEvent = P25DecodeEvent.builder(DecodeEventType.CALL, timestamp).channel(this.getCurrentChannel()).details(details).identifiers(this.getIdentifierCollection().copyOf()).build();
            this.broadcast(this.mCurrentCallEvent);
            this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.START, State.CALL));
        } else {
            this.mCurrentCallEvent.setIdentifierCollection(this.getIdentifierCollection().copyOf());
            this.mCurrentCallEvent.end(timestamp);
            this.broadcast(this.mCurrentCallEvent);
            if (decodeEventType == DecodeEventType.CALL_ENCRYPTED) {
                this.mCurrentCallEvent.setDetails(details);
                this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.ENCRYPTED));
            } else {
                this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.CALL));
            }
        }
    }

    private void closeCurrentCallEvent(long timestamp) {
        if (this.mCurrentCallEvent != null) {
            this.mCurrentCallEvent.end(timestamp);
            this.broadcast(this.mCurrentCallEvent);
            this.mCurrentCallEvent = null;
            this.getIdentifierCollection().remove(IdentifierClass.USER, Role.FROM);
        }
    }

    private void processTDU(P25Message message) {
        this.closeCurrentCallEvent(message.getTimestamp());
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.ACTIVE));
    }

    private void processPDU(P25Message message) {
        if (message.isValid() && message instanceof PDUMessage) {
            PDUMessage pdu = (PDUMessage)message;
            this.processBroadcast(pdu.getIdentifiers(), message.getTimestamp(), DecodeEventType.DATA_PACKET, pdu.toString());
        }
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.DATA));
    }

    private void processUMBTC(P25Message message) {
        if (message.isValid() && message instanceof UMBTCTelephoneInterconnectRequestExplicitDialing) {
            UMBTCTelephoneInterconnectRequestExplicitDialing tired = (UMBTCTelephoneInterconnectRequestExplicitDialing)message;
            this.processBroadcast(tired.getIdentifiers(), tired.getTimestamp(), DecodeEventType.REQUEST, "TELEPHONE INTERCONNECT:" + String.valueOf(tired.getTelephoneNumber()));
        }
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.CONTROL));
    }

    private void processPacketData(P25Message message) {
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.DATA));
        if (message instanceof SNDCPPacketMessage) {
            SNDCPPacketMessage sndcp = (SNDCPPacketMessage)message;
            this.getIdentifierCollection().update(sndcp.getIdentifiers());
        } else if (message instanceof PacketMessage) {
            PacketMessage packetMessage = (PacketMessage)message;
            this.getIdentifierCollection().remove(IdentifierClass.USER);
            this.getIdentifierCollection().update(packetMessage.getIdentifiers());
            IPacket packet = packetMessage.getPacket();
            if (packet instanceof IPV4Packet) {
                IPV4Packet ipv4 = (IPV4Packet)packet;
                IPacket ipPayload = ipv4.getPayload();
                if (ipPayload instanceof UDPPacket) {
                    UDPPacket udpPacket = (UDPPacket)ipPayload;
                    IPacket udpPayload = udpPacket.getPayload();
                    if (udpPayload instanceof ARSPacket) {
                        ARSPacket arsPacket = (ARSPacket)udpPayload;
                        MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                        for (Identifier identifier : packet.getIdentifiers()) {
                            ic.update(identifier);
                        }
                        DecodeEvent packetEvent = P25DecodeEvent.builder(DecodeEventType.AUTOMATIC_REGISTRATION_SERVICE, message.getTimestamp()).channel(this.getCurrentChannel()).identifiers(ic).details(String.valueOf(arsPacket) + " " + String.valueOf(ipv4)).build();
                        this.broadcast(packetEvent);
                    } else if (udpPayload instanceof MCGPPacket) {
                        MCGPPacket mcgpPacket = (MCGPPacket)udpPayload;
                        MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                        for (Identifier identifier : packet.getIdentifiers()) {
                            ic.update(identifier);
                        }
                        DecodeEvent cellocatorEvent = P25DecodeEvent.builder(DecodeEventType.CELLOCATOR, message.getTimestamp()).channel(this.getCurrentChannel()).identifiers(ic).details(String.valueOf(mcgpPacket) + " " + String.valueOf(ipv4)).build();
                        this.broadcast(cellocatorEvent);
                    } else if (udpPayload instanceof LRRPPacket) {
                        LRRPPacket lrrpPacket = (LRRPPacket)udpPayload;
                        MutableIdentifierCollection ic = new MutableIdentifierCollection(packet.getIdentifiers());
                        DecodeEvent lrrpEvent = P25DecodeEvent.builder(DecodeEventType.LRRP, message.getTimestamp()).channel(this.getCurrentChannel()).details(String.valueOf(lrrpPacket) + " " + String.valueOf(ipv4)).identifiers(ic).protocol(Protocol.LRRP).build();
                        this.broadcast(lrrpEvent);
                        GeoPosition geoPosition = PacketUtil.extractGeoPosition(lrrpPacket);
                        if (geoPosition != null) {
                            PlottableDecodeEvent plottableDecodeEvent = PlottableDecodeEvent.plottableBuilder(DecodeEventType.GPS, message.getTimestamp()).channel(this.getCurrentChannel()).identifiers(ic).protocol(Protocol.LRRP).location(geoPosition).build();
                            this.broadcast(plottableDecodeEvent);
                        }
                    } else {
                        MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                        for (Identifier identifier : packet.getIdentifiers()) {
                            ic.update(identifier);
                        }
                        DecodeEvent packetEvent = P25DecodeEvent.builder(DecodeEventType.UDP_PACKET, message.getTimestamp()).channel(this.getCurrentChannel()).identifiers(ic).details(ipv4.toString()).build();
                        this.broadcast(packetEvent);
                    }
                } else if (ipPayload instanceof ICMPPacket) {
                    MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                    for (Identifier identifier : packet.getIdentifiers()) {
                        ic.update(identifier);
                    }
                    DecodeEvent packetEvent = P25DecodeEvent.builder(DecodeEventType.ICMP_PACKET, message.getTimestamp()).channel(this.getCurrentChannel()).identifiers(ic).details(ipv4.toString()).build();
                    this.broadcast(packetEvent);
                } else {
                    MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                    for (Identifier identifier : packet.getIdentifiers()) {
                        ic.update(identifier);
                    }
                    DecodeEvent packetEvent = P25DecodeEvent.builder(DecodeEventType.IP_PACKET, message.getTimestamp()).channel(this.getCurrentChannel()).identifiers(ic).details(ipv4.toString()).build();
                    this.broadcast(packetEvent);
                }
            } else if (packet instanceof UnknownPacket) {
                MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                for (Identifier identifier : packet.getIdentifiers()) {
                    ic.update(identifier);
                }
                DecodeEvent packetEvent = P25DecodeEvent.builder(DecodeEventType.UNKNOWN_PACKET, message.getTimestamp()).channel(this.getCurrentChannel()).identifiers(ic).details(packet.toString()).build();
                this.broadcast(packetEvent);
            }
        }
    }

    private void processSNDCP(P25Message message) {
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.DATA));
        if (message.isValid() && message instanceof SNDCPPacketMessage) {
            SNDCPPacketMessage sndcpPacket = (SNDCPPacketMessage)message;
            MutableIdentifierCollection ic = this.getMutableIdentifierCollection(sndcpPacket.getIdentifiers());
            switch (sndcpPacket.getSNDCPPacketHeader().getPDUType()) {
                case OUTBOUND_SNDCP_ACTIVATE_TDS_CONTEXT_ACCEPT: {
                    this.processBroadcast(sndcpPacket.getIdentifiers(), message.getTimestamp(), DecodeEventType.RESPONSE, "SNDCP ACTIVATE TDS CONTEXT ACCEPT");
                    break;
                }
                case OUTBOUND_SNDCP_DEACTIVATE_TDS_CONTEXT_ACCEPT: {
                    this.processBroadcast(sndcpPacket.getIdentifiers(), message.getTimestamp(), DecodeEventType.RESPONSE, "SNDCP DEACTIVATE TDS CONTEXT ACCEPT");
                    break;
                }
                case OUTBOUND_SNDCP_DEACTIVATE_TDS_CONTEXT_REQUEST: {
                    this.processBroadcast(sndcpPacket.getIdentifiers(), message.getTimestamp(), DecodeEventType.REQUEST, "SNDCP DEACTIVATE TDS CONTEXT");
                    break;
                }
                case OUTBOUND_SNDCP_ACTIVATE_TDS_CONTEXT_REJECT: {
                    this.processBroadcast(sndcpPacket.getIdentifiers(), message.getTimestamp(), DecodeEventType.RESPONSE, "SNDCP ACTIVATE TDS CONTEXT REJECT");
                    break;
                }
                case INBOUND_SNDCP_ACTIVATE_TDS_CONTEXT_REQUEST: {
                    this.processBroadcast(sndcpPacket.getIdentifiers(), message.getTimestamp(), DecodeEventType.REQUEST, "SNDCP ACTIVATE TDS CONTEXT");
                    break;
                }
                case INBOUND_SNDCP_DEACTIVATE_TDS_CONTEXT_ACCEPT: {
                    this.processBroadcast(sndcpPacket.getIdentifiers(), message.getTimestamp(), DecodeEventType.RESPONSE, "SNDCP DEACTIVATE TDS CONTEXT ACCEPT");
                    break;
                }
                case INBOUND_SNDCP_DEACTIVATE_TDS_CONTEXT_REQUEST: {
                    this.processBroadcast(sndcpPacket.getIdentifiers(), message.getTimestamp(), DecodeEventType.REQUEST, "SNDCP DEACTIVATE TDS CONTEXT");
                }
            }
        }
    }

    private void processTSBK(P25Message message) {
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.CONTROL));
        if (message.isValid() && message instanceof TSBKMessage) {
            TSBKMessage tsbk = (TSBKMessage)message;
            switch (tsbk.getOpcode()) {
                case OSP_GROUP_DATA_CHANNEL_GRANT: {
                    this.processTSBKDataChannelGrant(tsbk);
                    break;
                }
                case OSP_GROUP_VOICE_CHANNEL_GRANT: {
                    this.processTSBKGroupVoiceChannelGrant(tsbk);
                    break;
                }
                case OSP_GROUP_VOICE_CHANNEL_GRANT_UPDATE: {
                    this.processTSBKGroupVoiceChannelGrantUpdate(tsbk);
                    break;
                }
                case OSP_GROUP_VOICE_CHANNEL_GRANT_UPDATE_EXPLICIT: {
                    this.processTSBKGroupVoiceChannelGrantUpdateExplicit(tsbk);
                    break;
                }
                case OSP_UNIT_TO_UNIT_VOICE_CHANNEL_GRANT: {
                    this.processTSBKUnitToUnitVoiceChannelGrant(tsbk);
                    break;
                }
                case OSP_UNIT_TO_UNIT_VOICE_CHANNEL_GRANT_UPDATE: {
                    this.processTSBKUnitToUnitVoiceChannelGrantUpdate(tsbk);
                    break;
                }
                case OSP_TELEPHONE_INTERCONNECT_VOICE_CHANNEL_GRANT: {
                    this.processTSBKTelephoneInterconnectVoiceChannelGrant(tsbk);
                    break;
                }
                case OSP_TELEPHONE_INTERCONNECT_VOICE_CHANNEL_GRANT_UPDATE: {
                    this.processTSBKTelephoneInterconnectVoiceChannelGrantUpdate(tsbk);
                    break;
                }
                case OSP_SNDCP_DATA_CHANNEL_GRANT: {
                    this.processTSBKSndcpDataChannelGrant(tsbk);
                    break;
                }
                case MOTOROLA_OSP_PATCH_GROUP_CHANNEL_GRANT: {
                    this.processTSBKMotorolaOspPatchGroupChannelGrant(tsbk);
                    break;
                }
                case MOTOROLA_OSP_PATCH_GROUP_CHANNEL_GRANT_UPDATE: {
                    this.processTSBKMotorolaOspPatchGroupChannelGrantUpdate(tsbk);
                    break;
                }
                case OSP_ADJACENT_STATUS_BROADCAST: 
                case OSP_NETWORK_STATUS_BROADCAST: 
                case OSP_RFSS_STATUS_BROADCAST: 
                case OSP_PROTECTION_PARAMETER_BROADCAST: 
                case MOTOROLA_OSP_TRAFFIC_CHANNEL_ID: 
                case MOTOROLA_OSP_SYSTEM_LOADING: 
                case MOTOROLA_OSP_BASE_STATION_ID: 
                case MOTOROLA_OSP_CONTROL_CHANNEL_PLANNED_SHUTDOWN: 
                case OSP_IDENTIFIER_UPDATE_TDMA: 
                case OSP_IDENTIFIER_UPDATE_VHF_UHF_BANDS: 
                case OSP_SECONDARY_CONTROL_CHANNEL_BROADCAST_EXPLICIT: 
                case OSP_SNDCP_DATA_CHANNEL_ANNOUNCEMENT_EXPLICIT: 
                case OSP_TIME_DATE_ANNOUNCEMENT: 
                case OSP_TDMA_SYNC_BROADCAST: 
                case OSP_SYSTEM_SERVICE_BROADCAST: 
                case OSP_SECONDARY_CONTROL_CHANNEL_BROADCAST: 
                case OSP_IDENTIFIER_UPDATE: 
                case OSP_PROTECTION_PARAMETER_UPDATE: {
                    this.mNetworkConfigurationMonitor.process(tsbk);
                    break;
                }
                case OSP_UNIT_TO_UNIT_ANSWER_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.PAGE, "UNIT-TO-UNIT ANSWER REQUEST");
                    break;
                }
                case OSP_TELEPHONE_INTERCONNECT_ANSWER_REQUEST: {
                    this.processTSBKTelephoneInterconnectAnswerRequest(tsbk);
                    break;
                }
                case OSP_SNDCP_DATA_PAGE_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.PAGE, "SNDCP DATA PAGE REQUEST");
                    break;
                }
                case OSP_STATUS_UPDATE: {
                    this.processTSBKStatusUpdate(tsbk);
                    break;
                }
                case OSP_STATUS_QUERY: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.QUERY, "STATUS");
                    break;
                }
                case OSP_MESSAGE_UPDATE: {
                    if (!(tsbk instanceof MessageUpdate)) break;
                    MessageUpdate mu = (MessageUpdate)tsbk;
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.SDM, "MSG:" + String.valueOf(mu.getShortDataMessage()));
                    break;
                }
                case OSP_RADIO_UNIT_MONITOR_COMMAND: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.COMMAND, "RADIO UNIT MONITOR");
                    break;
                }
                case OSP_CALL_ALERT: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.PAGE, "CALL ALERT");
                    break;
                }
                case OSP_ACKNOWLEDGE_RESPONSE: {
                    this.processTSBKAcknowledgeResponse(tsbk);
                    break;
                }
                case OSP_QUEUED_RESPONSE: {
                    this.processTSBKQueuedResponse(tsbk);
                    break;
                }
                case OSP_EXTENDED_FUNCTION_COMMAND: {
                    this.processTSBKExtendedFunctionCommand(tsbk);
                    break;
                }
                case OSP_DENY_RESPONSE: {
                    this.processTSBKDenyResponse(tsbk);
                    break;
                }
                case OSP_GROUP_AFFILIATION_RESPONSE: {
                    this.processTSBKGroupAffiliationResponse(tsbk);
                    break;
                }
                case OSP_GROUP_AFFILIATION_QUERY: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.QUERY, "GROUP AFFILIATION");
                    break;
                }
                case OSP_LOCATION_REGISTRATION_RESPONSE: {
                    this.processTSBKLocationRegistrationResponse(tsbk);
                    break;
                }
                case OSP_UNIT_REGISTRATION_RESPONSE: {
                    this.processTSBKUnitRegistrationResponse(tsbk);
                    break;
                }
                case OSP_UNIT_REGISTRATION_COMMAND: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.COMMAND, "UNIT REGISTRATION");
                    break;
                }
                case OSP_AUTHENTICATION_COMMAND: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.COMMAND, "AUTHENTICATE");
                    break;
                }
                case OSP_UNIT_DEREGISTRATION_ACKNOWLEDGE: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.DEREGISTER, "ACKNOWLEDGE UNIT DE-REGISTRATION");
                    break;
                }
                case OSP_ROAMING_ADDRESS_COMMAND: {
                    if (!(tsbk instanceof RoamingAddressCommand)) break;
                    RoamingAddressCommand rac = (RoamingAddressCommand)tsbk;
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.COMMAND, String.valueOf((Object)rac.getStackOperation()) + " ROAMING ADDRESS");
                    break;
                }
                case MOTOROLA_OSP_PATCH_GROUP_ADD: {
                    this.mPatchGroupManager.addPatchGroups(tsbk.getIdentifiers());
                    break;
                }
                case MOTOROLA_OSP_PATCH_GROUP_DELETE: {
                    this.mPatchGroupManager.removePatchGroups(tsbk.getIdentifiers());
                    break;
                }
                case HARRIS_OSP_GRG_EXENC_CMD: {
                    if (!(tsbk instanceof HarrisGroupRegroupExplicitEncryptionCommand)) break;
                    HarrisGroupRegroupExplicitEncryptionCommand regroup = (HarrisGroupRegroupExplicitEncryptionCommand)tsbk;
                    if (regroup.getRegroupOptions().isActivate()) {
                        this.mPatchGroupManager.addPatchGroup(regroup.getPatchGroup());
                        break;
                    }
                    this.mPatchGroupManager.removePatchGroup(regroup.getPatchGroup());
                    break;
                }
                case ISP_GROUP_VOICE_SERVICE_REQUEST: {
                    if (!(tsbk instanceof GroupVoiceServiceRequest)) break;
                    GroupVoiceServiceRequest gvsr = (GroupVoiceServiceRequest)tsbk;
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "GROUP VOICE SERVICE " + String.valueOf(gvsr.getVoiceServiceOptions()));
                    break;
                }
                case ISP_UNIT_TO_UNIT_VOICE_SERVICE_REQUEST: {
                    if (!(tsbk instanceof UnitToUnitVoiceServiceRequest)) break;
                    UnitToUnitVoiceServiceRequest uuvsr = (UnitToUnitVoiceServiceRequest)tsbk;
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "UNIT-2-UNIT VOICE SERVICE " + String.valueOf(uuvsr.getVoiceServiceOptions()));
                    break;
                }
                case ISP_UNIT_TO_UNIT_ANSWER_RESPONSE: {
                    this.processTSBKUnitToUnitAnswerResponse(tsbk);
                    break;
                }
                case ISP_TELEPHONE_INTERCONNECT_PSTN_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "TELEPHONE INTERCONNECT");
                    break;
                }
                case ISP_TELEPHONE_INTERCONNECT_ANSWER_RESPONSE: {
                    this.processTSBKTelephoneInterconnectAnswerResponse(tsbk);
                    break;
                }
                case ISP_INDIVIDUAL_DATA_SERVICE_REQUEST: {
                    if (!(tsbk instanceof IndividualDataServiceRequest)) break;
                    IndividualDataServiceRequest idsr = (IndividualDataServiceRequest)tsbk;
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "INDIVIDUAL DATA SERVICE " + String.valueOf(idsr.getVoiceServiceOptions()));
                    break;
                }
                case ISP_GROUP_DATA_SERVICE_REQUEST: {
                    if (!(tsbk instanceof GroupDataServiceRequest)) break;
                    GroupDataServiceRequest gdsr = (GroupDataServiceRequest)tsbk;
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "GROUP DATA SERVICE " + String.valueOf(gdsr.getVoiceServiceOptions()));
                    break;
                }
                case ISP_SNDCP_DATA_CHANNEL_REQUEST: {
                    if (!(tsbk instanceof SNDCPDataChannelRequest)) break;
                    SNDCPDataChannelRequest sdcr = (SNDCPDataChannelRequest)tsbk;
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "SNDCP DATA CHANNEL " + String.valueOf(sdcr.getDataServiceOptions()));
                    break;
                }
                case ISP_SNDCP_DATA_PAGE_RESPONSE: {
                    this.processTSBKSndcpDataPageResponse(tsbk);
                    break;
                }
                case ISP_SNDCP_RECONNECT_REQUEST: {
                    this.processTSBKSndcpReconnectRequest(tsbk);
                    break;
                }
                case ISP_STATUS_UPDATE_REQUEST: {
                    this.processTSBKStatusUpdateRequest(tsbk);
                    break;
                }
                case ISP_STATUS_QUERY_RESPONSE: {
                    this.processTSBKStatusQueryResponse(tsbk);
                    break;
                }
                case ISP_STATUS_QUERY_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.QUERY, "UNIT AND USER STATUS");
                    break;
                }
                case ISP_MESSAGE_UPDATE_REQUEST: {
                    if (!(tsbk instanceof MessageUpdateRequest)) break;
                    MessageUpdateRequest mur = (MessageUpdateRequest)tsbk;
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.SDM, "MESSAGE:" + mur.getShortDataMessage());
                    break;
                }
                case ISP_RADIO_UNIT_MONITOR_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "RADIO UNIT MONITOR");
                    break;
                }
                case ISP_CALL_ALERT_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "CALL ALERT");
                    break;
                }
                case ISP_UNIT_ACKNOWLEDGE_RESPONSE: {
                    if (!(tsbk instanceof UnitAcknowledgeResponse)) break;
                    UnitAcknowledgeResponse uar = (UnitAcknowledgeResponse)tsbk;
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.RESPONSE, "UNIT ACKNOWLEDGE:" + uar.getAcknowledgedServiceType().getDescription());
                    break;
                }
                case ISP_CANCEL_SERVICE_REQUEST: {
                    this.processTSBKCancelServiceRequest(tsbk);
                    break;
                }
                case ISP_EXTENDED_FUNCTION_RESPONSE: {
                    this.processTSBKExtendedFunctionResponse(tsbk);
                    break;
                }
                case ISP_EMERGENCY_ALARM_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "EMERGENCY ALARM");
                    break;
                }
                case ISP_GROUP_AFFILIATION_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "GROUP AFFILIATION");
                    break;
                }
                case ISP_GROUP_AFFILIATION_QUERY_RESPONSE: {
                    this.processTSBKGroupAffiliationQueryResponse(tsbk);
                    break;
                }
                case ISP_UNIT_DE_REGISTRATION_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.DEREGISTER, "UNIT DE-REGISTRATION REQUEST");
                    break;
                }
                case ISP_UNIT_REGISTRATION_REQUEST: {
                    this.processTSBKUnitRegistrationRequest(tsbk);
                    break;
                }
                case ISP_LOCATION_REGISTRATION_REQUEST: {
                    this.processTSBKLocationRegistrationRequest(tsbk);
                    break;
                }
                case ISP_PROTECTION_PARAMETER_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "ENCRYPTION PARAMETERS");
                    break;
                }
                case ISP_IDENTIFIER_UPDATE_REQUEST: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.REQUEST, "FREQUENCY BAND DETAILS");
                    break;
                }
                case ISP_ROAMING_ADDRESS_REQUEST: {
                    this.processTSBKRoamingAddressRequest(tsbk);
                    break;
                }
                case ISP_ROAMING_ADDRESS_RESPONSE: {
                    this.processBroadcast(tsbk.getIdentifiers(), tsbk.getTimestamp(), DecodeEventType.RESPONSE, "ROAMING ADDRESS");
                    break;
                }
                case MOTOROLA_OSP_DENY_RESPONSE: {
                    this.processTSBKMotorolaOspDenyResponse(tsbk);
                    break;
                }
            }
        }
    }

    private void processTSBKMotorolaOspDenyResponse(TSBKMessage tsbk) {
        if (tsbk instanceof MotorolaDenyResponse) {
            MotorolaDenyResponse dr = (MotorolaDenyResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, "DENY: " + dr.getDeniedServiceType().getDescription() + " REASON: " + String.valueOf((Object)dr.getDenyReason()) + " - INFO: " + dr.getAdditionalInfo());
        }
    }

    private void processTSBKRoamingAddressRequest(TSBKMessage tsbk) {
        this.broadcast(P25DecodeEvent.builder(DecodeEventType.REQUEST, tsbk.getTimestamp()).channel(this.getCurrentChannel()).details("ROAMING ADDRESS").identifiers(new IdentifierCollection(tsbk.getIdentifiers())).build());
    }

    private void processTSBKLocationRegistrationRequest(TSBKMessage tsbk) {
        if (tsbk instanceof LocationRegistrationRequest) {
            LocationRegistrationRequest lrr = (LocationRegistrationRequest)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.REGISTER, (lrr.isEmergency() ? "EMERGENCY " : "") + "LOCATION REGISTRATION REQUEST - CAPABILITY:" + String.valueOf(lrr.getCapability()));
        }
    }

    private void processTSBKUnitRegistrationRequest(TSBKMessage tsbk) {
        if (tsbk instanceof UnitRegistrationRequest) {
            UnitRegistrationRequest urr = (UnitRegistrationRequest)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.REGISTER, (urr.isEmergency() ? "EMERGENCY " : "") + "UNIT REGISTRATION REQUEST - CAPABILITY:" + String.valueOf(urr.getCapability()));
        }
    }

    private void processTSBKGroupAffiliationQueryResponse(TSBKMessage tsbk) {
        if (tsbk instanceof GroupAffiliationQueryResponse) {
            GroupAffiliationQueryResponse gaqr = (GroupAffiliationQueryResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, "AFFILIATION - GROUP:" + String.valueOf(gaqr.getGroupAddress()) + " ANNOUNCEMENT GROUP:" + String.valueOf(gaqr.getAnnouncementGroupAddress()));
        }
    }

    private void processTSBKExtendedFunctionResponse(TSBKMessage tsbk) {
        if (tsbk instanceof ExtendedFunctionResponse) {
            ExtendedFunctionResponse efr = (ExtendedFunctionResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, "EXTENDED FUNCTION:" + String.valueOf((Object)efr.getExtendedFunction()) + " ARGUMENTS:" + efr.getArguments());
        }
    }

    private void processTSBKCancelServiceRequest(TSBKMessage tsbk) {
        if (tsbk instanceof CancelServiceRequest) {
            CancelServiceRequest csr = (CancelServiceRequest)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.REQUEST, "CANCEL SERVICE:" + String.valueOf((Object)csr.getServiceType()) + " REASON:" + String.valueOf((Object)csr.getCancelReason()) + (String)(csr.hasAdditionalInformation() ? " INFO:" + csr.getAdditionalInformation() : ""));
        }
    }

    private void processTSBKStatusQueryResponse(TSBKMessage tsbk) {
        if (tsbk instanceof StatusQueryResponse) {
            StatusQueryResponse sqr = (StatusQueryResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.STATUS, "UNIT:" + String.valueOf(sqr.getUnitStatus()) + " USER:" + String.valueOf(sqr.getUserStatus()));
        }
    }

    private void processTSBKStatusUpdateRequest(TSBKMessage tsbk) {
        if (tsbk instanceof StatusUpdateRequest) {
            StatusUpdateRequest sur = (StatusUpdateRequest)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.STATUS, "UNIT:" + String.valueOf(sur.getUnitStatus()) + " USER:" + String.valueOf(sur.getUserStatus()));
        }
    }

    private void processTSBKSndcpReconnectRequest(TSBKMessage tsbk) {
        if (tsbk instanceof SNDCPReconnectRequest) {
            SNDCPReconnectRequest srr = (SNDCPReconnectRequest)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.REQUEST, "SNDCP RECONNECT " + (srr.hasDataToSend() ? "- DATA TO SEND " : "") + String.valueOf(srr.getDataServiceOptions()));
        }
    }

    private void processTSBKSndcpDataPageResponse(TSBKMessage tsbk) {
        if (tsbk instanceof SNDCPDataPageResponse) {
            SNDCPDataPageResponse sdpr = (SNDCPDataPageResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, String.valueOf((Object)sdpr.getAnswerResponse()) + " SNDCP DATA " + String.valueOf(sdpr.getDataServiceOptions()));
        }
    }

    private void processTSBKTelephoneInterconnectAnswerResponse(TSBKMessage tsbk) {
        if (tsbk instanceof TelephoneInterconnectAnswerResponse) {
            TelephoneInterconnectAnswerResponse tiar = (TelephoneInterconnectAnswerResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, String.valueOf((Object)tiar.getAnswerResponse()) + " TELEPHONE INTERCONNECT " + String.valueOf(tiar.getVoiceServiceOptions()));
        }
    }

    private void processTSBKUnitToUnitAnswerResponse(TSBKMessage tsbk) {
        if (tsbk instanceof UnitToUnitVoiceServiceAnswerResponse) {
            UnitToUnitVoiceServiceAnswerResponse uuvsar = (UnitToUnitVoiceServiceAnswerResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, String.valueOf((Object)uuvsar.getAnswerResponse()) + " UNIT-2-UNIT VOICE SERVICE " + String.valueOf(uuvsar.getVoiceServiceOptions()));
        }
    }

    private void processTSBKUnitRegistrationResponse(TSBKMessage tsbk) {
        if (tsbk instanceof UnitRegistrationResponse) {
            UnitRegistrationResponse urr = (UnitRegistrationResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.REGISTER, String.valueOf((Object)urr.getResponse()) + " UNIT REGISTRATION - UNIT ID:" + String.valueOf(urr.getTargetUniqueId()));
        }
    }

    private void processTSBKLocationRegistrationResponse(TSBKMessage tsbk) {
        if (tsbk instanceof LocationRegistrationResponse) {
            LocationRegistrationResponse lrr = (LocationRegistrationResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.REGISTER, String.valueOf((Object)lrr.getResponse()) + " LOCATION REGISTRATION - GROUP:" + String.valueOf(lrr.getGroupAddress()));
        }
    }

    private void processTSBKGroupAffiliationResponse(TSBKMessage tsbk) {
        if (tsbk instanceof GroupAffiliationResponse) {
            GroupAffiliationResponse gar = (GroupAffiliationResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, String.valueOf((Object)gar.getAffiliationResponse()) + " AFFILIATION GROUP: " + String.valueOf(gar.getGroupAddress()) + (gar.isGlobalAffiliation() ? " (GLOBAL)" : " (LOCAL)") + " ANNOUNCEMENT GROUP:" + String.valueOf(gar.getAnnouncementGroupAddress()));
        }
    }

    private void processTSBKDenyResponse(TSBKMessage tsbk) {
        if (tsbk instanceof DenyResponse) {
            DenyResponse dr = (DenyResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, "DENY: " + dr.getDeniedServiceType().getDescription() + " REASON: " + String.valueOf((Object)dr.getDenyReason()) + " - INFO: " + dr.getAdditionalInfo());
        }
    }

    private void processTSBKExtendedFunctionCommand(TSBKMessage tsbk) {
        if (tsbk instanceof ExtendedFunctionCommand) {
            ExtendedFunctionCommand efc = (ExtendedFunctionCommand)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.COMMAND, "EXTENDED FUNCTION: " + String.valueOf((Object)efc.getExtendedFunction()) + " ARGUMENTS:" + efc.getArguments());
        }
    }

    private void processTSBKQueuedResponse(TSBKMessage tsbk) {
        if (tsbk instanceof QueuedResponse) {
            QueuedResponse qr = (QueuedResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, "QUEUED: " + qr.getQueuedResponseServiceType().getDescription() + " REASON: " + String.valueOf((Object)qr.getQueuedResponseReason()) + " INFO: " + qr.getAdditionalInfo());
        }
    }

    private void processTSBKAcknowledgeResponse(TSBKMessage tsbk) {
        if (tsbk instanceof AcknowledgeResponse) {
            AcknowledgeResponse ar = (AcknowledgeResponse)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.RESPONSE, "ACKNOWLEDGE " + ar.getAcknowledgedServiceType().getDescription());
        }
    }

    private void processTSBKStatusUpdate(TSBKMessage tsbk) {
        if (tsbk instanceof StatusUpdate) {
            StatusUpdate su = (StatusUpdate)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.STATUS, "UNIT:" + String.valueOf(su.getUnitStatus()) + " USER:" + String.valueOf(su.getUserStatus()));
        }
    }

    private void processTSBKTelephoneInterconnectAnswerRequest(TSBKMessage tsbk) {
        if (tsbk instanceof TelephoneInterconnectAnswerRequest) {
            TelephoneInterconnectAnswerRequest tiar = (TelephoneInterconnectAnswerRequest)tsbk;
            this.processBroadcast(tsbk, DecodeEventType.PAGE, "TELEPHONE ANSWER REQUEST: " + String.valueOf(tiar.getTelephoneNumber()));
        }
    }

    private void processTSBKMotorolaOspPatchGroupChannelGrantUpdate(TSBKMessage tsbk) {
        if (tsbk instanceof PatchGroupVoiceChannelGrantUpdate) {
            PatchGroupVoiceChannelGrantUpdate pgvcgu = (PatchGroupVoiceChannelGrantUpdate)tsbk;
            MutableIdentifierCollection identifiersPG1 = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
            identifiersPG1.remove(IdentifierClass.USER);
            identifiersPG1.update(this.mPatchGroupManager.update(pgvcgu.getPatchGroup1()));
            this.processChannelGrant(pgvcgu.getChannel1(), null, identifiersPG1, tsbk.getOpcode(), pgvcgu.getTimestamp());
            if (pgvcgu.hasPatchGroup2()) {
                MutableIdentifierCollection identifiersPG2 = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                identifiersPG2.remove(IdentifierClass.USER);
                identifiersPG2.update(this.mPatchGroupManager.update(pgvcgu.getPatchGroup2()));
                this.processChannelGrant(pgvcgu.getChannel2(), null, identifiersPG2, tsbk.getOpcode(), pgvcgu.getTimestamp());
            }
        }
    }

    private void processTSBKMotorolaOspPatchGroupChannelGrant(TSBKMessage tsbk) {
        if (tsbk instanceof PatchGroupVoiceChannelGrant) {
            PatchGroupVoiceChannelGrant pgvcg = (PatchGroupVoiceChannelGrant)tsbk;
            MutableIdentifierCollection identifiers = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
            identifiers.remove(IdentifierClass.USER);
            for (Identifier identifier : pgvcg.getIdentifiers()) {
                identifiers.update(this.mPatchGroupManager.update(identifier));
            }
            this.processChannelGrant(pgvcg.getChannel(), pgvcg.getVoiceServiceOptions(), identifiers, tsbk.getOpcode(), pgvcg.getTimestamp());
        }
    }

    private void processTSBKTelephoneInterconnectVoiceChannelGrantUpdate(TSBKMessage tsbk) {
        if (tsbk instanceof TelephoneInterconnectVoiceChannelGrantUpdate) {
            TelephoneInterconnectVoiceChannelGrantUpdate tivcgu = (TelephoneInterconnectVoiceChannelGrantUpdate)tsbk;
            MutableIdentifierCollection identifiers = this.getMutableIdentifierCollection(tivcgu.getIdentifiers());
            this.processChannelGrant(tivcgu.getChannel(), tivcgu.getVoiceServiceOptions(), identifiers, tsbk.getOpcode(), tivcgu.getTimestamp());
        }
    }

    private void processTSBKSndcpDataChannelGrant(TSBKMessage tsbk) {
        if (tsbk instanceof SNDCPDataChannelGrant) {
            SNDCPDataChannelGrant dcg = (SNDCPDataChannelGrant)tsbk;
            MutableIdentifierCollection identifiers = this.getMutableIdentifierCollection(dcg.getIdentifiers());
            this.processChannelGrant(dcg.getChannel(), dcg.getServiceOptions(), identifiers, tsbk.getOpcode(), dcg.getTimestamp());
        }
    }

    private void processTSBKTelephoneInterconnectVoiceChannelGrant(TSBKMessage tsbk) {
        if (tsbk instanceof TelephoneInterconnectVoiceChannelGrant) {
            TelephoneInterconnectVoiceChannelGrant tivcg = (TelephoneInterconnectVoiceChannelGrant)tsbk;
            MutableIdentifierCollection identifiers = this.getMutableIdentifierCollection(tivcg.getIdentifiers());
            this.processChannelGrant(tivcg.getChannel(), tivcg.getVoiceServiceOptions(), identifiers, tsbk.getOpcode(), tivcg.getTimestamp());
        }
    }

    private void processTSBKUnitToUnitVoiceChannelGrantUpdate(TSBKMessage tsbk) {
        if (tsbk instanceof UnitToUnitVoiceChannelGrantUpdate) {
            UnitToUnitVoiceChannelGrantUpdate uuvcgu = (UnitToUnitVoiceChannelGrantUpdate)tsbk;
            MutableIdentifierCollection identifiers = this.getMutableIdentifierCollection(uuvcgu.getIdentifiers());
            this.processChannelGrant(uuvcgu.getChannel(), null, identifiers, tsbk.getOpcode(), uuvcgu.getTimestamp());
        }
    }

    private void processTSBKUnitToUnitVoiceChannelGrant(TSBKMessage tsbk) {
        if (tsbk instanceof UnitToUnitVoiceChannelGrant) {
            UnitToUnitVoiceChannelGrant uuvcg = (UnitToUnitVoiceChannelGrant)tsbk;
            MutableIdentifierCollection identifiers = this.getMutableIdentifierCollection(uuvcg.getIdentifiers());
            this.processChannelGrant(uuvcg.getChannel(), null, identifiers, tsbk.getOpcode(), uuvcg.getTimestamp());
        }
    }

    private void processTSBKGroupVoiceChannelGrantUpdateExplicit(TSBKMessage tsbk) {
        if (tsbk instanceof GroupVoiceChannelGrantUpdateExplicit) {
            GroupVoiceChannelGrantUpdateExplicit gvcgue = (GroupVoiceChannelGrantUpdateExplicit)tsbk;
            MutableIdentifierCollection identifiers = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
            identifiers.remove(IdentifierClass.USER);
            identifiers.update(this.mPatchGroupManager.update(gvcgue.getGroupAddress()));
            this.processChannelGrant(gvcgue.getChannel(), gvcgue.getVoiceServiceOptions(), identifiers, tsbk.getOpcode(), gvcgue.getTimestamp());
        }
    }

    private void processTSBKGroupVoiceChannelGrantUpdate(TSBKMessage tsbk) {
        if (tsbk instanceof GroupVoiceChannelGrantUpdate) {
            GroupVoiceChannelGrantUpdate gvcgu = (GroupVoiceChannelGrantUpdate)tsbk;
            MutableIdentifierCollection identifiersA = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
            identifiersA.remove(IdentifierClass.USER);
            identifiersA.update(this.mPatchGroupManager.update(gvcgu.getGroupAddressA()));
            this.processChannelGrant(gvcgu.getChannelA(), null, identifiersA, tsbk.getOpcode(), gvcgu.getTimestamp());
            if (gvcgu.hasGroupB()) {
                MutableIdentifierCollection identifiersB = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                identifiersB.remove(IdentifierClass.USER);
                identifiersB.update(this.mPatchGroupManager.update(gvcgu.getGroupAddressB()));
                this.processChannelGrant(gvcgu.getChannelB(), null, identifiersB, tsbk.getOpcode(), gvcgu.getTimestamp());
            }
        }
    }

    private void processTSBKGroupVoiceChannelGrant(TSBKMessage tsbk) {
        if (tsbk instanceof GroupVoiceChannelGrant) {
            GroupVoiceChannelGrant gvcg = (GroupVoiceChannelGrant)tsbk;
            MutableIdentifierCollection identifiers = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
            identifiers.remove(IdentifierClass.USER);
            for (Identifier identifier : gvcg.getIdentifiers()) {
                identifiers.update(this.mPatchGroupManager.update(identifier));
            }
            this.processChannelGrant(gvcg.getChannel(), gvcg.getVoiceServiceOptions(), identifiers, tsbk.getOpcode(), gvcg.getTimestamp());
        }
    }

    private void processTSBKDataChannelGrant(TSBKMessage tsbk) {
        if (tsbk instanceof GroupDataChannelGrant) {
            GroupDataChannelGrant gdcg = (GroupDataChannelGrant)tsbk;
            MutableIdentifierCollection identifiers = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
            identifiers.remove(IdentifierClass.USER);
            for (Identifier identifier : gdcg.getIdentifiers()) {
                identifiers.update(this.mPatchGroupManager.update(identifier));
            }
            this.processChannelGrant(gdcg.getChannel(), gdcg.getDataServiceOptions(), identifiers, tsbk.getOpcode(), gdcg.getTimestamp());
        }
    }

    private void processEncryptionSyncParameters(EncryptionSyncParameters esp, long timestamp) {
        if (esp.isEncryptedAudio()) {
            for (Identifier identifier : esp.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
            Encryption encryption = Encryption.fromValue(((EncryptionKey)esp.getEncryptionKey().getValue()).getAlgorithm());
            this.updateCurrentCall(DecodeEventType.CALL_ENCRYPTED, "ALGORITHM:" + encryption.toString(), timestamp);
        } else {
            this.getIdentifierCollection().remove(Form.ENCRYPTION_KEY);
            this.updateCurrentCall(DecodeEventType.CALL, null, timestamp);
        }
    }

    private void processLinkControl(LinkControlWord lcw, long timestamp) {
        switch (lcw.getOpcode()) {
            case GROUP_VOICE_CHANNEL_USER: 
            case MOTOROLA_PATCH_GROUP_VOICE_CHANNEL_USER: 
            case MOTOROLA_TALK_COMPLETE: 
            case TELEPHONE_INTERCONNECT_VOICE_CHANNEL_USER: 
            case UNIT_TO_UNIT_VOICE_CHANNEL_USER: {
                for (Identifier identifier : lcw.getIdentifiers()) {
                    this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
                }
                break;
            }
            case CALL_TERMINATION_OR_CANCELLATION: {
                if (!(lcw instanceof LCCallTermination) || !((LCCallTermination)lcw).isNetworkCommandedTeardown()) break;
                this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.END, State.FADE));
                break;
            }
            case GROUP_VOICE_CHANNEL_UPDATE: 
            case GROUP_VOICE_CHANNEL_UPDATE_EXPLICIT: {
                break;
            }
            case ADJACENT_SITE_STATUS_BROADCAST: 
            case ADJACENT_SITE_STATUS_BROADCAST_EXPLICIT: 
            case NETWORK_STATUS_BROADCAST: 
            case NETWORK_STATUS_BROADCAST_EXPLICIT: 
            case PROTECTION_PARAMETER_BROADCAST: 
            case RFSS_STATUS_BROADCAST: 
            case RFSS_STATUS_BROADCAST_EXPLICIT: 
            case SECONDARY_CONTROL_CHANNEL_BROADCAST: 
            case SECONDARY_CONTROL_CHANNEL_BROADCAST_EXPLICIT: 
            case SYSTEM_SERVICE_BROADCAST: {
                this.mNetworkConfigurationMonitor.process(lcw);
                break;
            }
            case MOTOROLA_PATCH_GROUP_ADD: {
                this.mPatchGroupManager.addPatchGroups(lcw.getIdentifiers());
                break;
            }
            case MOTOROLA_PATCH_GROUP_DELETE: {
                this.mPatchGroupManager.removePatchGroups(lcw.getIdentifiers());
                break;
            }
            case MOTOROLA_PATCH_GROUP_VOICE_CHANNEL_UPDATE: {
                this.mPatchGroupManager.addPatchGroups(lcw.getIdentifiers());
                break;
            }
            case CALL_ALERT: {
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.PAGE, "Call Alert");
                break;
            }
            case EXTENDED_FUNCTION_COMMAND: {
                if (!(lcw instanceof LCExtendedFunctionCommand)) break;
                LCExtendedFunctionCommand efc = (LCExtendedFunctionCommand)lcw;
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.COMMAND, "Extended Function: " + String.valueOf((Object)efc.getExtendedFunction()) + " Arguments:" + efc.getExtendedFunctionArguments());
                break;
            }
            case GROUP_AFFILIATION_QUERY: {
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.QUERY, "Group Affiliation");
                break;
            }
            case MESSAGE_UPDATE: {
                if (!(lcw instanceof LCMessageUpdate)) break;
                LCMessageUpdate mu = (LCMessageUpdate)lcw;
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.SDM, "MSG:" + String.valueOf(mu.getShortDataMessage()));
                break;
            }
            case STATUS_QUERY: {
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.QUERY, "Status");
                break;
            }
            case STATUS_UPDATE: {
                if (!(lcw instanceof LCStatusUpdate)) break;
                LCStatusUpdate su = (LCStatusUpdate)lcw;
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.STATUS, "UNIT:" + String.valueOf(su.getUnitStatus()) + " USER:" + String.valueOf(su.getUserStatus()));
                break;
            }
            case TELEPHONE_INTERCONNECT_ANSWER_REQUEST: {
                if (!(lcw instanceof LCTelephoneInterconnectAnswerRequest)) break;
                LCTelephoneInterconnectAnswerRequest tiar = (LCTelephoneInterconnectAnswerRequest)lcw;
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.PAGE, "Telephone Call:" + String.valueOf(tiar.getTelephoneNumber()));
                break;
            }
            case UNIT_AUTHENTICATION_COMMAND: {
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.COMMAND, "Authenticate Unit");
                break;
            }
            case UNIT_REGISTRATION_COMMAND: {
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.COMMAND, "Unit Registration");
                break;
            }
            case UNIT_TO_UNIT_ANSWER_REQUEST: {
                this.processBroadcast(lcw.getIdentifiers(), timestamp, DecodeEventType.PAGE, "Unit-to-Unit Answer Request");
                break;
            }
            case MOTOROLA_UNIT_GPS: {
                if (!(lcw instanceof LCMotorolaUnitGPS)) break;
                LCMotorolaUnitGPS moto = (LCMotorolaUnitGPS)lcw;
                String gpsDetails = "LOCATION: " + moto.getLatitude() + " " + moto.getLongitude();
                PlottableDecodeEvent event = PlottableDecodeEvent.plottableBuilder(DecodeEventType.GPS, timestamp).location(new GeoPosition(moto.getLatitude(), moto.getLongitude())).channel(this.getCurrentChannel()).details(gpsDetails).end(timestamp).protocol(Protocol.APCO25).identifiers(new IdentifierCollection(this.getIdentifierCollection().getIdentifiers())).build();
                this.broadcast(event);
                break;
            }
        }
    }

    @Override
    public String getActivitySummary() {
        return this.mNetworkConfigurationMonitor.getActivitySummary();
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.resetState();
                this.mNetworkConfigurationMonitor.reset();
                break;
            }
        }
    }

    @Override
    public void start() {
        this.mPatchGroupManager.clear();
        if (this.mChannelType == Channel.ChannelType.TRAFFIC) {
            this.broadcast(new ChangeChannelTimeoutEvent((Object)this, Channel.ChannelType.TRAFFIC, 1000L));
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void stop() {
        this.mPatchGroupManager.clear();
    }
}

