/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.gain.complex.ComplexGainFactory;
import io.github.dsheirer.dsp.gain.complex.IComplexGainControl;
import io.github.dsheirer.dsp.psk.DQPSKGardnerDemodulator;
import io.github.dsheirer.dsp.psk.InterpolatingSampleBuffer;
import io.github.dsheirer.dsp.psk.pll.CostasLoop;
import io.github.dsheirer.dsp.psk.pll.FrequencyCorrectionSyncMonitor;
import io.github.dsheirer.dsp.psk.pll.PLLBandwidth;
import io.github.dsheirer.dsp.window.WindowType;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import io.github.dsheirer.module.decode.p25.phase1.P25P1MessageFramer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.SourceEvent;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P1DecoderLSM
extends P25P1Decoder {
    private static final Logger mLog = LoggerFactory.getLogger(P25P1DecoderLSM.class);
    protected static final float SAMPLE_COUNTER_GAIN = 0.3f;
    private Map<Double, float[]> mBasebandFilters = new HashMap<Double, float[]>();
    protected IRealFilter mIBasebandFilter;
    protected IRealFilter mQBasebandFilter;
    protected IComplexGainControl mAGC = ComplexGainFactory.getComplexGainControl();
    protected DQPSKGardnerDemodulator mQPSKDemodulator;
    protected P25P1MessageFramer mMessageFramer;
    protected CostasLoop mCostasLoop;
    protected InterpolatingSampleBuffer mInterpolatingSampleBuffer;
    protected FrequencyCorrectionSyncMonitor mFrequencyCorrectionSyncMonitor;

    public P25P1DecoderLSM() {
        super(4800.0);
        this.setSampleRate(25000.0);
    }

    @Override
    public void start() {
        super.start();
        this.mQPSKDemodulator.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.mQPSKDemodulator.stop();
    }

    @Override
    public void setSampleRate(double sampleRate) {
        super.setSampleRate(sampleRate);
        this.mIBasebandFilter = FilterFactory.getRealFilter(this.getBasebandFilter());
        this.mQBasebandFilter = FilterFactory.getRealFilter(this.getBasebandFilter());
        this.mCostasLoop = new CostasLoop(this.getSampleRate(), this.getSymbolRate());
        this.mCostasLoop.setPLLBandwidth(PLLBandwidth.BW_200);
        this.mFrequencyCorrectionSyncMonitor = new FrequencyCorrectionSyncMonitor(this.mCostasLoop, this);
        this.mInterpolatingSampleBuffer = new InterpolatingSampleBuffer(this.getSamplesPerSymbol(), 0.3f);
        this.mQPSKDemodulator = new DQPSKGardnerDemodulator(this.mCostasLoop, this.mInterpolatingSampleBuffer);
        if (this.mMessageFramer != null) {
            this.getDibitBroadcaster().removeListener(this.mMessageFramer);
        }
        this.mMessageFramer = new P25P1MessageFramer(this.mCostasLoop, DecoderType.P25_PHASE1.getProtocol().getBitRate());
        this.mMessageFramer.setSyncDetectListener(this.mFrequencyCorrectionSyncMonitor);
        this.mMessageFramer.setListener(this.getMessageProcessor());
        this.mMessageFramer.setSampleRate(sampleRate);
        this.mQPSKDemodulator.setSymbolListener(this.getDibitBroadcaster());
        this.getDibitBroadcaster().addListener(this.mMessageFramer);
    }

    @Override
    public void receive(ComplexSamples samples) {
        this.mMessageFramer.setCurrentTime(samples.timestamp());
        float[] i = this.mIBasebandFilter.filter(samples.i());
        float[] q = this.mQBasebandFilter.filter(samples.q());
        this.mPowerMonitor.process(i, q);
        ComplexSamples amplified = this.mAGC.process(i, q, samples.timestamp());
        this.mQPSKDemodulator.receive(amplified);
    }

    @Override
    protected void process(SourceEvent sourceEvent) {
        switch (sourceEvent.getEvent()) {
            case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                this.setSampleRate(sourceEvent.getValue().doubleValue());
                this.mCostasLoop.reset();
                break;
            }
            case NOTIFICATION_FREQUENCY_CORRECTION_CHANGE: {
                this.mCostasLoop.reset();
            }
        }
    }

    @Override
    public void reset() {
        this.mCostasLoop.reset();
        this.mFrequencyCorrectionSyncMonitor.reset();
    }

    @Override
    public P25P1Decoder.Modulation getModulation() {
        return P25P1Decoder.Modulation.CQPSK;
    }

    private float[] getBasebandFilter() {
        float[] filter = this.mBasebandFilters.get(this.getSampleRate());
        if (filter == null) {
            filter = FilterFactory.getLowPass(this.getSampleRate(), 7250, 8000, 60, WindowType.HANN, true);
            this.mBasebandFilters.put(this.getSampleRate(), filter);
        }
        return filter;
    }
}

