/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.gain.complex.ComplexGainFactory;
import io.github.dsheirer.dsp.gain.complex.IComplexGainControl;
import io.github.dsheirer.dsp.psk.DQPSKDecisionDirectedDemodulator;
import io.github.dsheirer.dsp.psk.InterpolatingSampleBuffer;
import io.github.dsheirer.dsp.psk.pll.CostasLoop;
import io.github.dsheirer.dsp.psk.pll.FrequencyCorrectionSyncMonitor;
import io.github.dsheirer.dsp.psk.pll.PLLBandwidth;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import io.github.dsheirer.module.decode.p25.phase1.P25P1MessageFramer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.SourceEvent;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P1DecoderC4FM
extends P25P1Decoder {
    private static final Logger mLog = LoggerFactory.getLogger(P25P1DecoderC4FM.class);
    protected static final float SAMPLE_COUNTER_GAIN = 0.3f;
    protected InterpolatingSampleBuffer mInterpolatingSampleBuffer;
    protected DQPSKDecisionDirectedDemodulator mQPSKDemodulator;
    protected CostasLoop mCostasLoop;
    protected FrequencyCorrectionSyncMonitor mFrequencyCorrectionSyncMonitor;
    protected P25P1MessageFramer mMessageFramer;
    protected IComplexGainControl mAGC = ComplexGainFactory.getComplexGainControl();
    private Map<Double, float[]> mBasebandFilters = new HashMap<Double, float[]>();
    protected IRealFilter mIBasebandFilter;
    protected IRealFilter mQBasebandFilter;

    public P25P1DecoderC4FM() {
        super(4800.0);
        this.setSampleRate(25000.0);
    }

    @Override
    public void start() {
        super.start();
        this.mQPSKDemodulator.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.mQPSKDemodulator.stop();
    }

    @Override
    public void setSampleRate(double sampleRate) {
        super.setSampleRate(sampleRate);
        this.mIBasebandFilter = FilterFactory.getRealFilter(this.getBasebandFilter());
        this.mQBasebandFilter = FilterFactory.getRealFilter(this.getBasebandFilter());
        this.mCostasLoop = new CostasLoop(this.getSampleRate(), this.getSymbolRate());
        this.mCostasLoop.setPLLBandwidth(PLLBandwidth.BW_300);
        this.mFrequencyCorrectionSyncMonitor = new FrequencyCorrectionSyncMonitor(this.mCostasLoop, this);
        this.mInterpolatingSampleBuffer = new InterpolatingSampleBuffer(this.getSamplesPerSymbol(), 0.3f);
        this.mQPSKDemodulator = new DQPSKDecisionDirectedDemodulator(this.mCostasLoop, this.mInterpolatingSampleBuffer);
        if (this.mMessageFramer != null) {
            this.getDibitBroadcaster().removeListener(this.mMessageFramer);
        }
        this.mMessageFramer = new P25P1MessageFramer(this.mCostasLoop, DecoderType.P25_PHASE1.getProtocol().getBitRate());
        this.mMessageFramer.setSyncDetectListener(this.mFrequencyCorrectionSyncMonitor);
        this.mMessageFramer.setListener(this.getMessageProcessor());
        this.mMessageFramer.setSampleRate(sampleRate);
        this.mQPSKDemodulator.setSymbolListener(this.getDibitBroadcaster());
        this.getDibitBroadcaster().addListener(this.mMessageFramer);
    }

    @Override
    public void receive(ComplexSamples samples) {
        this.mMessageFramer.setCurrentTime(System.currentTimeMillis());
        float[] i = this.mIBasebandFilter.filter(samples.i());
        float[] q = this.mQBasebandFilter.filter(samples.q());
        this.mPowerMonitor.process(i, q);
        ComplexSamples amplified = this.mAGC.process(i, q, samples.timestamp());
        this.mQPSKDemodulator.receive(amplified);
    }

    private float[] getBasebandFilter() {
        float[] filter = this.mBasebandFilters.get(this.getSampleRate());
        if (filter == null) {
            FIRFilterSpecification specification = FIRFilterSpecification.lowPassBuilder().sampleRate((int)this.getSampleRate()).passBandCutoff(5100.0).passBandAmplitude(1.0).passBandRipple(0.01).stopBandAmplitude(0.0).stopBandStart(6500.0).stopBandRipple(0.01).build();
            try {
                filter = FilterFactory.getTaps(specification);
            }
            catch (FilterDesignException fde) {
                mLog.error("Couldn't design low pass baseband filter for sample rate: " + this.getSampleRate());
            }
            if (filter != null) {
                this.mBasebandFilters.put(this.getSampleRate(), filter);
            } else {
                throw new IllegalStateException("Couldn't design a C4FM baseband filter for sample rate: " + this.getSampleRate());
            }
        }
        return filter;
    }

    @Override
    protected void process(SourceEvent sourceEvent) {
        switch (sourceEvent.getEvent()) {
            case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                this.mCostasLoop.reset();
                this.setSampleRate(sourceEvent.getValue().doubleValue());
                break;
            }
            case NOTIFICATION_FREQUENCY_CORRECTION_CHANGE: {
                this.mCostasLoop.reset();
            }
        }
    }

    @Override
    public P25P1Decoder.Modulation getModulation() {
        return P25P1Decoder.Modulation.C4FM;
    }

    @Override
    public void reset() {
        this.mCostasLoop.reset();
        this.mFrequencyCorrectionSyncMonitor.reset();
    }
}

