/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.identifier.encryption;

import io.github.dsheirer.identifier.encryption.EncryptionKey;
import io.github.dsheirer.module.decode.p25.reference.Encryption;

public class APCO25EncryptionKey
extends EncryptionKey {
    public APCO25EncryptionKey(int algorithm, int keyId) {
        super(algorithm, keyId);
    }

    public Encryption getEncryptionAlgorithm() {
        return Encryption.fromValue(this.getAlgorithm());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isEncrypted()) {
            Encryption encryption = this.getEncryptionAlgorithm();
            if (encryption == Encryption.UNKNOWN) {
                sb.append("ALGORITHM ID:").append(this.getAlgorithm());
            } else {
                sb.append("ENCRYPTION:").append((Object)this.getEncryptionAlgorithm());
            }
            sb.append(" KEY:").append(this.getKey());
        } else {
            sb.append("NO ENCRYPTION");
        }
        return sb.toString();
    }

    @Override
    public boolean isEncrypted() {
        return this.getEncryptionAlgorithm() != Encryption.UNENCRYPTED;
    }

    public static APCO25EncryptionKey create(int algorithm, int keyId) {
        return new APCO25EncryptionKey(algorithm, keyId);
    }
}

