/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.identifier.channel;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.protocol.Protocol;
import java.util.Objects;

public class P25Channel
implements IChannelDescriptor {
    private IFrequencyBand mFrequencyBand;
    private int mBandIdentifier;
    private int mChannelNumber;

    public P25Channel(int bandIdentifier, int channelNumber) {
        this.mBandIdentifier = bandIdentifier;
        this.mChannelNumber = channelNumber;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.APCO25;
    }

    public IFrequencyBand getFrequencyBand() {
        return this.mFrequencyBand;
    }

    public int getDownlinkBandIdentifier() {
        return this.mBandIdentifier;
    }

    public int getDownlinkChannelNumber() {
        return this.mChannelNumber;
    }

    public int getUplinkBandIdentifier() {
        return this.mBandIdentifier;
    }

    public int getUplinkChannelNumber() {
        return this.mChannelNumber;
    }

    @Override
    public long getDownlinkFrequency() {
        if (this.mFrequencyBand != null) {
            return this.mFrequencyBand.getDownlinkFrequency(this.getDownlinkChannelNumber());
        }
        return 0L;
    }

    @Override
    public long getUplinkFrequency() {
        if (this.mFrequencyBand != null) {
            return this.mFrequencyBand.getUplinkFrequency(this.getUplinkChannelNumber());
        }
        return 0L;
    }

    public boolean hasUplinkChannel() {
        return this.getUplinkChannelNumber() != 4095;
    }

    @Override
    public int[] getFrequencyBandIdentifiers() {
        if (this.getDownlinkBandIdentifier() != this.getUplinkBandIdentifier()) {
            int[] identifiers = new int[]{this.getDownlinkBandIdentifier(), this.getUplinkBandIdentifier()};
            return identifiers;
        }
        int[] identifiers = new int[]{this.getDownlinkBandIdentifier()};
        return identifiers;
    }

    @Override
    public void setFrequencyBand(IFrequencyBand frequencyBand) {
        if (frequencyBand.getIdentifier() == this.getDownlinkBandIdentifier()) {
            this.mFrequencyBand = frequencyBand;
        }
    }

    @Override
    public int getTimeslotCount() {
        if (this.mFrequencyBand != null) {
            return this.mFrequencyBand.getTimeslotCount();
        }
        return 1;
    }

    @Override
    public boolean isTDMAChannel() {
        if (this.mFrequencyBand != null) {
            return this.mFrequencyBand.isTDMA();
        }
        return false;
    }

    public int getTimeslot() {
        if (this.isTDMAChannel()) {
            return this.getDownlinkChannelNumber() % this.getTimeslotCount();
        }
        return 0;
    }

    public int getDownlinkLogicalChannelNumber() {
        return this.getDownlinkChannelNumber() / this.getTimeslotCount();
    }

    public int getUplinkLogicalChannelNumber() {
        return this.getUplinkChannelNumber() / this.getTimeslotCount();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int downlinkChannelNumber = this.getDownlinkChannelNumber();
        if (this.isTDMAChannel()) {
            downlinkChannelNumber -= downlinkChannelNumber % this.getTimeslotCount();
        }
        if (this.getDownlinkBandIdentifier() == this.getUplinkBandIdentifier() && this.getDownlinkChannelNumber() == this.getUplinkChannelNumber()) {
            sb.append(this.getDownlinkBandIdentifier()).append("-").append(downlinkChannelNumber);
        } else if (this.hasUplinkChannel()) {
            int uplinkChannelNumber = this.getUplinkChannelNumber();
            if (this.isTDMAChannel()) {
                uplinkChannelNumber -= uplinkChannelNumber % this.getTimeslotCount();
            }
            sb.append(this.getDownlinkBandIdentifier()).append("-").append(downlinkChannelNumber).append("/").append(this.getUplinkBandIdentifier()).append("-").append(uplinkChannelNumber);
        } else {
            sb.append(this.getDownlinkBandIdentifier()).append("-").append(downlinkChannelNumber).append("/-----");
        }
        if (this.isTDMAChannel()) {
            sb.append(" TS").append(this.getTimeslot());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof P25Channel)) {
            return false;
        }
        P25Channel that = (P25Channel)o;
        return this.mBandIdentifier == that.mBandIdentifier && this.getDownlinkLogicalChannelNumber() == that.getDownlinkLogicalChannelNumber();
    }

    public int hashCode() {
        return Objects.hash(this.mBandIdentifier, this.getDownlinkLogicalChannelNumber());
    }
}

