/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.p25.P25DecodeEvent;
import io.github.dsheirer.module.decode.p25.reference.ServiceOptions;
import io.github.dsheirer.protocol.Protocol;

public class P25ChannelGrantEvent
extends P25DecodeEvent {
    private ServiceOptions mServiceOptions;

    public P25ChannelGrantEvent(DecodeEventType decodeEventType, long timestamp) {
        super(decodeEventType, timestamp);
    }

    public static P25ChannelGrantDecodeEventBuilder builder(DecodeEventType decodeEventType, long timeStart, ServiceOptions serviceOptions) {
        return new P25ChannelGrantDecodeEventBuilder(decodeEventType, timeStart, serviceOptions);
    }

    public ServiceOptions getServiceOptions() {
        return this.mServiceOptions;
    }

    public void setServiceOptions(ServiceOptions serviceOptions) {
        this.mServiceOptions = serviceOptions;
    }

    public boolean hasServiceOptions() {
        return this.mServiceOptions != null;
    }

    public static class P25ChannelGrantDecodeEventBuilder {
        protected long mTimeStart;
        protected long mDuration;
        protected DecodeEventType mDecodeEventType;
        protected IdentifierCollection mIdentifierCollection;
        protected IChannelDescriptor mChannelDescriptor;
        protected String mDetails;
        private ServiceOptions mServiceOptions;

        public P25ChannelGrantDecodeEventBuilder(DecodeEventType decodeEventType, long timeStart, ServiceOptions serviceOptions) {
            this.mDecodeEventType = decodeEventType;
            this.mTimeStart = timeStart;
            this.mServiceOptions = serviceOptions;
        }

        public P25ChannelGrantDecodeEventBuilder duration(long duration) {
            this.mDuration = duration;
            return this;
        }

        public P25ChannelGrantDecodeEventBuilder end(long timestamp) {
            this.mDuration = timestamp - this.mTimeStart;
            return this;
        }

        public P25ChannelGrantDecodeEventBuilder channel(IChannelDescriptor channelDescriptor) {
            this.mChannelDescriptor = channelDescriptor;
            return this;
        }

        public P25ChannelGrantDecodeEventBuilder identifiers(IdentifierCollection identifierCollection) {
            this.mIdentifierCollection = identifierCollection;
            return this;
        }

        public P25ChannelGrantDecodeEventBuilder details(String details) {
            this.mDetails = details;
            return this;
        }

        public P25ChannelGrantEvent build() {
            P25ChannelGrantEvent decodeEvent = new P25ChannelGrantEvent(this.mDecodeEventType, this.mTimeStart);
            decodeEvent.setProtocol(Protocol.APCO25);
            decodeEvent.setChannelDescriptor(this.mChannelDescriptor);
            decodeEvent.setDetails(this.mDetails);
            decodeEvent.setDuration(this.mDuration);
            decodeEvent.setIdentifierCollection(this.mIdentifierCollection);
            decodeEvent.setServiceOptions(this.mServiceOptions);
            return decodeEvent;
        }
    }
}

