/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mpt1327.identifier;

import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.preference.identifier.talkgroup.MPT1327TalkgroupFormatter;
import io.github.dsheirer.protocol.Protocol;

public class MPT1327Talkgroup
extends TalkgroupIdentifier {
    public static final int PREFIX_MASK = 1040384;
    public static final int IDENT_MASK = 8191;

    public MPT1327Talkgroup(Integer value, Role role) {
        super(value, role);
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.MPT1327;
    }

    public int getPrefix() {
        return MPT1327TalkgroupFormatter.getPrefix((Integer)this.getValue());
    }

    public int getIdent() {
        return MPT1327TalkgroupFormatter.getIdent((Integer)this.getValue());
    }

    public static MPT1327Talkgroup createFrom(int prefix, int ident) {
        if (0 < ident && ident <= 8100) {
            return new MPT1327Talkgroup((prefix << 13) + ident, Role.FROM);
        }
        return new MPT1327Talkgroup(ident, Role.FROM);
    }

    public static MPT1327Talkgroup createTo(int prefix, int ident) {
        if (0 < ident && ident <= 8100) {
            return new MPT1327Talkgroup(MPT1327Talkgroup.encode(prefix, ident), Role.TO);
        }
        return new MPT1327Talkgroup(ident, Role.TO);
    }

    public static MPT1327Talkgroup createTo(int value) {
        return new MPT1327Talkgroup(value, Role.TO);
    }

    public static int encode(int prefix, int ident) {
        return (prefix << 13) + ident;
    }

    public static int getPrefix(int value) {
        return (value & 0xFE000) >> 13;
    }

    public static int getIdent(int value) {
        return value & 0x1FFF;
    }
}

