/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mpt1327.channel;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.controller.channel.map.ChannelMap;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.protocol.Protocol;
import java.util.Objects;

public class MPT1327Channel
implements IChannelDescriptor {
    private int mChannelNumber;
    private ChannelMap mChannelMap;

    public MPT1327Channel(int channelNumber) {
        this.mChannelNumber = channelNumber;
    }

    public String toString() {
        return String.valueOf(this.mChannelNumber);
    }

    public int getChannelNumber() {
        return this.mChannelNumber;
    }

    public void setChannelMap(ChannelMap channelMap) {
        this.mChannelMap = channelMap;
    }

    @Override
    public long getDownlinkFrequency() {
        if (this.mChannelMap != null) {
            return this.mChannelMap.getFrequency(this.mChannelNumber);
        }
        return 0L;
    }

    @Override
    public long getUplinkFrequency() {
        return 0L;
    }

    @Override
    public int[] getFrequencyBandIdentifiers() {
        return new int[0];
    }

    @Override
    public void setFrequencyBand(IFrequencyBand bandIdentifier) {
    }

    @Override
    public boolean isTDMAChannel() {
        return false;
    }

    @Override
    public int getTimeslotCount() {
        return 0;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.MPT1327;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MPT1327Channel that = (MPT1327Channel)o;
        return this.getChannelNumber() == that.getChannelNumber();
    }

    public int hashCode() {
        return Objects.hash(this.getChannelNumber());
    }

    public static MPT1327Channel create(int channelNumber) {
        return new MPT1327Channel(channelNumber);
    }
}

