/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mpt1327;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.CRCFleetsync;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.module.decode.mpt1327.identifier.MPT1327Talkgroup;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MPT1327Message
extends Message {
    private static String[] TELEX_LETTERS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "\n", "\n", "", "", " ", " "};
    private static String[] TELEX_FIGURES = new String[]{"-", "?", ":", "WRU", "3", "{6}", "{7}", "{8}", "8", "{BEEP}", "(", ")", ".", ",", "9", "0", "1", "4", "'", "5", "7", "=", "2", "/", "6", "+", "\n", "\n", "", "", " ", " "};
    private static String[] BCD = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", " ", "*", "#"};
    private static int BLOCK_1_START = 20;
    private static int BLOCK_2_START = 84;
    private static int BLOCK_3_START = 148;
    private static int BLOCK_4_START = 212;
    private static int BLOCK_5_START = 276;
    private static int BLOCK_6_START = 340;
    private static int[] REVS = new int[]{0, 1, 2, 3};
    private static int[] SYNC = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    private static int[] B1_SYSDEF = new int[]{21, 22, 23, 24, 25};
    private static int[] B1_PREFIX = new int[]{21, 22, 23, 24, 25, 26, 27};
    private static int[] B1_TRAFFIC_CHANNEL = new int[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
    private static int[] B1_SYSTEM_ID = new int[]{26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    private static int[] B1_IDENT1 = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    private static int[] B1_CONTROL_CHANNEL = new int[]{31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    private static int[] B1_CHANNEL = new int[]{35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static int[] B1_MESSAGE_TYPE = new int[]{41, 42, 43, 44, 45, 46, 47, 48, 49};
    private static int[] B1_GTC_CHAN = new int[]{43, 44, 45, 46, 47, 48, 49, 50, 51, 52};
    private static int[] B1_PREFIX2 = new int[]{48, 49, 50, 51, 52, 53, 54};
    private static int[] B1_IDENT2 = new int[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62};
    private static int[] B1_IDENT2_GTC = new int[]{53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65};
    private static int[] B1_IDENT2_HEAD = new int[]{55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
    private static int[] B1_ADJSITE = new int[]{49, 50, 51, 52};
    private static int B1_PERIODIC_CALL_MAINT_MESSAGES = 50;
    private static int[] B1_MAINT_MESSAGE_INTERVAL = new int[]{51, 52, 53, 54, 55};
    private static int[] B1_WAIT_TIME = new int[]{54, 55, 56};
    private static int B1_PRESSEL_ON_REQUIRED = 56;
    private static int[] B1_ALOHA_RSVD = new int[]{57, 58};
    private static int[] B1_ALOHA_M = new int[]{59, 60, 61, 62, 63};
    private static int[] B1_ALOHA_N = new int[]{64, 65, 66, 67};
    private static int B1_IDENT1_ID_VALUE = 57;
    private static int[] B1_SLOTS = new int[]{63, 64};
    private static int[] B1_DESCRIPTOR = new int[]{65, 66, 67};
    private static int[] B1_STATUS_MESSAGE = new int[]{63, 64, 65, 66, 67};
    private static int[] B2_SYSTEM_ID = new int[]{85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99};
    private static int[] B2_PREFIX = new int[]{112, 113, 114, 115, 116, 117, 118};
    private static int[] B2_IDENT2 = new int[]{119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131};
    private static int B2_SDM_SEGMENT_TRANSACTION_FLAG = 85;
    private static int[] B2_SDM_GENERAL_FORMAT = new int[]{86, 87, 88};
    private static int B2_SDM_INITIAL_SEGMENT_FLAG = 89;
    private static int B2_SDM_STF0_START = 86;
    private static int B2_SDM_STF0_END = 131;
    private static int B2_SDM_STF1_START = 90;
    private static int B2_SDM_STF1_END = 131;
    private static int B3_SDM_RETURN_SLOT_ACCESS = 149;
    private static int B3_SDM_START = 150;
    private static int B3_SDM_END = 195;
    private static int B4_SDM_SEGMENT_TRANSACTION_FLAG = 213;
    private static int[] B4_SDM_NUMBER_SEGMENTS = new int[]{214, 215};
    private static int B4_SDM_CONTINUATION_SEGMENT_FLAG = 216;
    private static int B4_SDM_RESERVED_FLAG = 217;
    private static int B4_SDM_STF0_START = 214;
    private static int B4_SDM_STF0_END = 259;
    private static int B4_SDM_STF1_START = 218;
    private static int B4_SDM_STF1_END = 259;
    private static int B5_SDM_RETURN_SLOT_ACCESS = 277;
    private static int B5_SDM_START = 278;
    private static int B5_SDM_END = 323;
    private BinaryMessage mMessage;
    private CRC[] mCRC = new CRC[5];
    private MPTMessageType mMessageType;
    private MPT1327Talkgroup mFromIdentifier;
    private MPT1327Talkgroup mToIdentifier;
    private List<Identifier> mIdentifiers;

    public MPT1327Message(BinaryMessage message) {
        this.mMessage = message;
        this.checkParity(0, BLOCK_1_START, BLOCK_2_START);
        if (this.isValid()) {
            this.mMessageType = this.getMessageType();
            switch (this.mMessageType) {
                case AHYC: 
                case CLEAR: 
                case MAINT: 
                case MOVE: {
                    break;
                }
                case AHYQ: 
                case ALH: 
                case HEAD_PLUS1: {
                    this.checkParity(1, BLOCK_2_START, BLOCK_3_START);
                    break;
                }
                case HEAD_PLUS2: {
                    this.checkParity(1, BLOCK_2_START, BLOCK_3_START);
                    this.checkParity(2, BLOCK_3_START, BLOCK_4_START);
                    break;
                }
                case ACKT: 
                case HEAD_PLUS3: {
                    this.checkParity(1, BLOCK_2_START, BLOCK_3_START);
                    this.checkParity(2, BLOCK_3_START, BLOCK_4_START);
                    this.checkParity(3, BLOCK_4_START, BLOCK_5_START);
                    break;
                }
                case HEAD_PLUS4: {
                    this.checkParity(1, BLOCK_2_START, BLOCK_3_START);
                    this.checkParity(2, BLOCK_3_START, BLOCK_4_START);
                    this.checkParity(3, BLOCK_4_START, BLOCK_5_START);
                    this.checkParity(4, BLOCK_5_START, BLOCK_6_START);
                    break;
                }
            }
        } else {
            this.mMessageType = MPTMessageType.UNKN;
        }
    }

    private void checkParity(int section, int start, int end) {
        this.mCRC[section] = this.detectAndCorrect(start, end);
    }

    private CRC detectAndCorrect(int start, int end) {
        int[] errorBitPositions;
        BinaryMessage original = this.mMessage.get(start, end);
        CRC retVal = CRCFleetsync.check(original);
        if (retVal == CRC.FAILED_PARITY && (errorBitPositions = CRCFleetsync.findBitErrors(original)) != null) {
            for (int errorBitPosition : errorBitPositions) {
                this.mMessage.flip(start + errorBitPosition);
            }
            retVal = CRC.CORRECTED;
        }
        return retVal;
    }

    public String getParity() {
        return "[" + CRC.format(this.mCRC) + "]";
    }

    @Override
    public boolean isValid() {
        return this.mCRC[0] == CRC.PASSED || this.mCRC[0] == CRC.CORRECTED;
    }

    public boolean isValidCall() {
        return this.getPrefix() != 0 && this.getIdent1() != 0 && this.getIdent2() != 0;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public MPTMessageType getMessageType() {
        int value = this.mMessage.getInt(B1_MESSAGE_TYPE);
        return MPTMessageType.fromNumber(value);
    }

    public String getSiteID() {
        if (this.mMessageType == MPTMessageType.BCAST) {
            return String.valueOf(this.mMessage.getInt(B1_SYSTEM_ID));
        }
        if (this.mMessageType == MPTMessageType.ALH) {
            return String.valueOf(this.mMessage.getInt(B2_SYSTEM_ID));
        }
        return null;
    }

    public boolean hasSystemID() {
        return this.getSiteID() != null;
    }

    public SystemDefinition getSystemDefinition() {
        int sysdef = this.mMessage.getInt(B1_SYSDEF);
        return SystemDefinition.fromNumber(sysdef);
    }

    public boolean getPeriodicMaintenanceMessagesRequired() {
        return this.mMessage.get(B1_PERIODIC_CALL_MAINT_MESSAGES);
    }

    public int getMaintenanceMessageInterval() {
        return this.mMessage.getInt(B1_MAINT_MESSAGE_INTERVAL);
    }

    public boolean getPresselOnRequired() {
        return this.mMessage.get(B1_PRESSEL_ON_REQUIRED);
    }

    public String getMaintMessageIDENT1Value() {
        return this.mMessage.get(B1_IDENT1_ID_VALUE) ? "GROUP ADDRESS" : "INDIVIDUAL ADDRESS";
    }

    public int getChannel() {
        switch (this.mMessageType) {
            case CLEAR: {
                return this.mMessage.getInt(B1_TRAFFIC_CHANNEL);
            }
            case GTC: {
                return this.mMessage.getInt(B1_GTC_CHAN);
            }
        }
        return this.mMessage.getInt(B1_CHANNEL);
    }

    public int getReturnToChannel() {
        if (this.mMessageType == MPTMessageType.CLEAR) {
            return this.mMessage.getInt(B1_CONTROL_CHANNEL);
        }
        return 0;
    }

    public int getAdjacentSiteSerialNumber() {
        return this.mMessage.getInt(B1_ADJSITE);
    }

    public int getPrefix() {
        return this.mMessage.getInt(B1_PREFIX);
    }

    public int getBlock2Prefix() {
        return this.mMessage.getInt(B2_PREFIX);
    }

    public int getIdent1() {
        return this.mMessage.getInt(B1_IDENT1);
    }

    public IdentType getIdent1Type() {
        return IdentType.fromIdent(this.getIdent1());
    }

    public int getIdent2() {
        MPTMessageType type = this.getMessageType();
        if (type == MPTMessageType.GTC) {
            return this.mMessage.getInt(B1_IDENT2_GTC);
        }
        if (type == MPTMessageType.HEAD_PLUS1 || type == MPTMessageType.HEAD_PLUS2 || type == MPTMessageType.HEAD_PLUS3 || type == MPTMessageType.HEAD_PLUS4) {
            return this.mMessage.getInt(B1_IDENT2_HEAD);
        }
        return this.mMessage.getInt(B1_IDENT2);
    }

    public IdentType getIdent2Type() {
        return IdentType.fromIdent(this.getIdent2());
    }

    public int getBlock2Ident2() {
        return this.mMessage.getInt(B2_IDENT2);
    }

    public String getStatusMessage() {
        int status = this.mMessage.getInt(B1_STATUS_MESSAGE);
        switch (status) {
            case 0: {
                return "STATUS: Request Speech Call";
            }
            case 31: {
                return "STATUS: Cancel Request Speech Call";
            }
        }
        return "STATUS: " + status;
    }

    public String getFiller(StringBuilder sb, int index) {
        if (sb.length() < index) {
            return String.format("%" + (index - sb.length()) + "s", " ");
        }
        return "";
    }

    public String pad(String value, int places, String padCharacter) {
        return StringUtils.rightPad((String)value, (int)places, (String)padCharacter);
    }

    public String format(int number, int decimalPlaces) {
        return StringUtils.leftPad((String)Integer.valueOf(number).toString(), (int)decimalPlaces, (char)'0');
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pad(this.mMessageType.toString(), 5, " "));
        block0 : switch (this.mMessageType) {
            case ACK: {
                sb.append(" ACKNOWLEDGE ");
                if (this.hasFromID()) {
                    sb.append(this.getFromID());
                }
                IdentType type = this.getIdent1Type();
                switch (type) {
                    case ALLI: 
                    case IPFIXI: 
                    case PABXI: 
                    case PSTNGI: 
                    case PSTNSI1: 
                    case PSTNSI2: 
                    case PSTNSI3: 
                    case PSTNSI4: 
                    case PSTNSI5: 
                    case PSTNSI6: 
                    case PSTNSI7: 
                    case PSTNSI8: 
                    case PSTNSI9: 
                    case PSTNSI10: 
                    case PSTNSI11: 
                    case PSTNSI12: 
                    case PSTNSI13: 
                    case PSTNSI14: 
                    case PSTNSI15: 
                    case USER: {
                        sb.append(type.getLabel());
                        sb.append(" CALL REQUEST");
                        break block0;
                    }
                    case TSCI: {
                        sb.append(" RQQ or RQC TRANSACTION");
                        break block0;
                    }
                    case DIVERTI: {
                        sb.append(" CANCELLATION OF CALL DIVERSION REQUEST");
                        break block0;
                    }
                }
                sb.append(" ");
                sb.append(type.getLabel());
                sb.append(" REQUEST");
                break;
            }
            case ACKI: {
                sb.append(" MESSAGE ACKNOWLEDGED - MORE TO FOLLOW");
                if (this.hasFromID()) {
                    sb.append(" FROM:");
                    sb.append(this.getFromID());
                }
                if (!this.hasToID()) break;
                sb.append(" TO:");
                sb.append(this.getToID());
                break;
            }
            case ACKT: {
                sb.append(" SITE:");
                sb.append(this.getSiteID());
                sb.append(" LONG ACK MESSAGE");
                if (this.hasFromID()) {
                    sb.append(" FROM:");
                    sb.append(this.getFromID());
                }
                if (this.hasToID()) {
                    sb.append(" TO:");
                    sb.append(this.getToID());
                }
                sb.append("**********************************");
                break;
            }
            case ACKQ: {
                sb.append(" SYSTEM:");
                sb.append(this.getSiteID());
                sb.append(" CALL QUEUED FROM:");
                if (this.hasFromID()) {
                    sb.append(" FROM:");
                    sb.append(this.getFromID());
                }
                if (!this.hasToID()) break;
                sb.append(" TO:");
                sb.append(this.getToID());
                break;
            }
            case ACKX: {
                sb.append(" SYSTEM:");
                sb.append(this.getSiteID());
                sb.append(" MESSAGE REJECTED FROM:");
                if (this.hasFromID()) {
                    sb.append(" FROM:");
                    sb.append(this.getFromID());
                }
                if (!this.hasToID()) break;
                sb.append(" TO:");
                sb.append(this.getToID());
                break;
            }
            case AHYC: {
                sb.append(" FM:");
                sb.append(this.getFromID());
                sb.append(" TO:");
                sb.append(this.getToID());
                sb.append(" ");
                sb.append(this.getRequestString());
                break;
            }
            case AHYQ: {
                sb.append(" STATUS MESSAGE");
                if (this.hasFromID()) {
                    sb.append(" FROM:");
                    sb.append(this.getFromID());
                }
                if (this.hasToID()) {
                    sb.append(" TO:");
                    sb.append(this.getToID());
                }
                sb.append(" ");
                sb.append(this.getStatusMessage());
                break;
            }
            case ALH: 
            case ALHD: 
            case ALHE: 
            case ALHF: 
            case ALHR: 
            case ALHS: 
            case ALHX: {
                sb.append(" SYSTEM:");
                sb.append(this.getSiteID());
                if (this.hasToID()) {
                    sb.append(" ID:");
                    sb.append(this.getToID());
                }
                sb.append(" WAIT:");
                sb.append(this.getWaitTime());
                sb.append(" RSVD:");
                sb.append(this.getAlohaReserved());
                sb.append(" M:");
                sb.append(this.getAlohaM());
                sb.append(" N:");
                sb.append(this.getAlohaN());
                break;
            }
            case BCAST: {
                sb.append(" SYSTEM:");
                sb.append(this.getSiteID());
                SystemDefinition sysdef = this.getSystemDefinition();
                sb.append(" ");
                sb.append(sysdef.getLabel());
                switch (sysdef) {
                    case ANNOUNCE_CONTROL_CHANNEL: 
                    case WITHDRAW_CONTROL_CHANNEL: {
                        sb.append(" CHAN:");
                        sb.append(this.getChannel());
                        break block0;
                    }
                    case BROADCAST_ADJACENT_SITE_CONTROL_CHANNEL_NUMBER: {
                        sb.append(" CHAN:");
                        sb.append(this.getChannel());
                        sb.append(" SER:");
                        sb.append(this.getAdjacentSiteSerialNumber());
                        break block0;
                    }
                    case SPECIFY_CALL_MAINTENANCE_PARAMETERS: {
                        sb.append(" PERIODIC MAINT MSG REQD:");
                        sb.append(this.getPeriodicMaintenanceMessagesRequired());
                        sb.append(" INTERVAL:");
                        sb.append(this.getMaintenanceMessageInterval());
                        sb.append("(sec) PRESSEL ON REQD:");
                        sb.append(this.getPresselOnRequired());
                        sb.append(" IDENT1 VALUE:");
                        sb.append(this.getMaintMessageIDENT1Value());
                        break block0;
                    }
                }
                break;
            }
            case CLEAR: {
                sb.append(" TRAFFIC CHANNEL:");
                sb.append(this.getChannel());
                sb.append(" RETURN TO CONTROL CHANNEL:");
                sb.append(this.getReturnToChannel());
                break;
            }
            case GTC: {
                if (this.hasFromID()) {
                    sb.append(" FROM:");
                    sb.append(this.getFromID());
                }
                if (this.hasToID()) {
                    sb.append(" TO:");
                    sb.append(this.getToID());
                }
                sb.append(" CHAN:");
                sb.append(this.getChannel());
                break;
            }
            case MAINT: {
                if (!this.hasToID()) break;
                sb.append(" ID:");
                sb.append(this.getToID());
                break;
            }
            case HEAD_PLUS1: 
            case HEAD_PLUS2: 
            case HEAD_PLUS3: 
            case HEAD_PLUS4: {
                sb.append(" ");
                sb.append(this.getSDM());
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.MPT1327;
    }

    public String getRequestString() {
        StringBuilder sb = new StringBuilder();
        IdentType type2 = this.getIdent2Type();
        if (type2 == IdentType.USER) {
            IdentType type1 = this.getIdent1Type();
            Slots slots = this.getSlots();
            switch (type1) {
                case DIVERTI: {
                    sb.append("SEND BLOCKED ADDRESS FOR THIRD-PARTY CALL DIVERSION USING ");
                    sb.append(slots.getLabel());
                    break;
                }
                case IPFIXI: {
                    sb.append("SEND INTER-PREFIX CALL EXTENDED ADDRESSING INFORMATION USING ");
                    sb.append(slots.getLabel());
                    break;
                }
                case PABXI: {
                    sb.append("SEND PABX EXTENSION USING");
                    sb.append(slots.getLabel());
                    break;
                }
                case PSTNGI: {
                    if (slots == Slots.SLOTS_1) {
                        sb.append("SEND UP TO 9 PSTN DIALED DIGITS");
                        break;
                    }
                    if (slots == Slots.SLOTS_2) {
                        sb.append("SEND 10 TO 31 PSTN DIALED DIGITS");
                        break;
                    }
                    sb.append("SEND PSTN DIALED DIGITS USING ");
                    sb.append(slots.getLabel());
                    break;
                }
                case SDMI: {
                    sb.append("SEND SHORT DATA MESSAGE USING ");
                    sb.append(slots.getLabel());
                    break;
                }
            }
        } else {
            sb.append("SEND ");
            sb.append(this.getDescriptor().getMode2Label());
        }
        return sb.toString();
    }

    public String getFromID() {
        StringBuilder sb = new StringBuilder();
        int ident2 = this.getIdent2();
        IdentType type = IdentType.fromIdent(ident2);
        if (type == IdentType.IPFIXI) {
            sb.append(this.format(this.getBlock2Prefix(), 3));
            sb.append("-");
            sb.append(this.format(this.getBlock2Ident2(), 4));
        } else {
            sb.append(this.format(this.getPrefix(), 3));
            sb.append("-");
            sb.append(this.format(ident2, 4));
        }
        return sb.toString();
    }

    public boolean hasFromID() {
        return this.getFromID() != null && !this.getFromID().isEmpty();
    }

    public String getToID() {
        StringBuilder sb = new StringBuilder();
        int prefix = this.getPrefix();
        int ident = this.getIdent1();
        switch (IdentType.fromIdent(ident)) {
            case IPFIXI: {
                sb.append("INTER-PREFIX");
                break;
            }
            case ALLI: {
                sb.append("ALL RADIOS");
                break;
            }
            case PABXI: {
                sb.append("PABX EXT");
                break;
            }
            case PSTNSI1: 
            case PSTNSI2: 
            case PSTNSI3: 
            case PSTNSI4: 
            case PSTNSI5: 
            case PSTNSI6: 
            case PSTNSI7: 
            case PSTNSI8: 
            case PSTNSI9: 
            case PSTNSI10: 
            case PSTNSI11: 
            case PSTNSI12: 
            case PSTNSI13: 
            case PSTNSI14: 
            case PSTNSI15: {
                sb.append("PRE-DEFINED PSTN");
                break;
            }
            case PSTNGI: {
                sb.append("PSTN GATEWAY");
                break;
            }
            case TSCI: {
                sb.append("SYSTEM CONTROLLER");
                break;
            }
            case DIVERTI: {
                sb.append("CALL DIVERT");
                break;
            }
            default: {
                if (prefix == 0 && ident == 0) break;
                sb.append(this.format(prefix, 3));
                sb.append("-");
                sb.append(this.format(ident, 4));
            }
        }
        return sb.toString();
    }

    public boolean hasToID() {
        return this.getToID() != null && !this.getToID().isEmpty();
    }

    public Descriptor getDescriptor() {
        return Descriptor.fromNumber(this.mMessage.getInt(B1_DESCRIPTOR));
    }

    public Slots getSlots() {
        return Slots.fromNumber(this.mMessage.getInt(B1_SLOTS));
    }

    public int getWaitTime() {
        return this.mMessage.getInt(B1_WAIT_TIME);
    }

    public int getAlohaReserved() {
        return this.mMessage.getInt(B1_ALOHA_RSVD);
    }

    public int getAlohaM() {
        return this.mMessage.getInt(B1_ALOHA_M);
    }

    public int getAlohaN() {
        return this.mMessage.getInt(B1_ALOHA_N);
    }

    public String getErrorStatus() {
        return this.getParity();
    }

    public SDMFormat getSDMFormat() {
        return SDMFormat.valueOf(this.mMessage.get(B2_SDM_SEGMENT_TRANSACTION_FLAG), this.mMessage.getInt(B2_SDM_GENERAL_FORMAT));
    }

    public String getSDM() {
        StringBuilder sb = new StringBuilder();
        sb.append("SDM:");
        MPTMessageType type = this.getMessageType();
        block0 : switch (type) {
            case HEAD_PLUS1: 
            case HEAD_PLUS2: 
            case HEAD_PLUS3: 
            case HEAD_PLUS4: {
                SDMFormat format = this.getSDMFormat();
                switch (format) {
                    case MPT1327: {
                        sb.append("MPT1327 ");
                        sb.append(this.getSDMBinary(type, format));
                        break block0;
                    }
                    case MPT1343_BINARY: {
                        sb.append("BINARY ");
                        sb.append(this.getSDMBinary(type, format));
                        break block0;
                    }
                    case MPT1343_COMMAND: {
                        sb.append("COMMAND ");
                        sb.append(this.getSDMBinary(type, format));
                        break block0;
                    }
                    case MPT1343_MAP27: {
                        sb.append("MAP27 ");
                        sb.append(this.getSDMBinary(type, format));
                        break block0;
                    }
                    case MPT1343_RESERVED: {
                        sb.append("RESERVED ");
                        sb.append(this.getSDMBinary(type, format));
                        break block0;
                    }
                    case MPT1343_SPARE: {
                        sb.append("SPARE ");
                        sb.append(this.getSDMBinary(type, format));
                        break block0;
                    }
                    case MPT1343_ASCII: {
                        sb.append("ASCII ");
                        sb.append(this.getSDMASCII(type));
                        break block0;
                    }
                    case MPT1343_BCD: {
                        sb.append("BCD ");
                        sb.append(this.getSDMBCD(type));
                        break block0;
                    }
                    case MPT1343_TELEX: {
                        sb.append("TELEX ");
                        sb.append(this.getSDMTelex(type));
                        break block0;
                    }
                }
                sb.append("UNKNOWN ");
                break;
            }
            case SAMO: {
                sb.append("SAMO ");
                break;
            }
            case SAMIS: {
                sb.append("SAMIS ");
                break;
            }
            case SAMIU: {
                sb.append("SAMIU ");
                break;
            }
        }
        return sb.toString();
    }

    public String getSDMBinary(MPTMessageType type, SDMFormat format) {
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case HEAD_PLUS1: {
                if (format == SDMFormat.MPT1327) {
                    sb.append(this.mMessage.getHex(B2_SDM_STF0_START, B2_SDM_STF0_END));
                    break;
                }
                sb.append(this.mMessage.getHex(B2_SDM_STF1_START, B2_SDM_STF1_END));
                break;
            }
            case HEAD_PLUS2: {
                if (format == SDMFormat.MPT1327) {
                    sb.append(this.mMessage.getHex(B2_SDM_STF0_START, B2_SDM_STF0_END));
                    sb.append(" ");
                    sb.append(this.mMessage.getHex(B3_SDM_START, B3_SDM_END));
                    break;
                }
                sb.append(this.mMessage.getHex(B2_SDM_STF1_START, B2_SDM_STF1_END));
                sb.append(" ");
                sb.append(this.mMessage.getHex(B3_SDM_START, B3_SDM_END));
                break;
            }
            case HEAD_PLUS3: {
                if (format == SDMFormat.MPT1327) {
                    sb.append(this.mMessage.getHex(B2_SDM_STF0_START, B2_SDM_STF0_END));
                    sb.append(" ");
                    sb.append(this.mMessage.getHex(B3_SDM_START, B3_SDM_END));
                    sb.append(" ");
                    sb.append(this.mMessage.getHex(B4_SDM_STF0_START, B4_SDM_STF0_END));
                    break;
                }
                sb.append(this.mMessage.getHex(B2_SDM_STF1_START, B2_SDM_STF1_END));
                sb.append(" ");
                sb.append(this.mMessage.getHex(B3_SDM_START, B3_SDM_END));
                sb.append(" ");
                sb.append(this.mMessage.getHex(B4_SDM_STF1_START, B4_SDM_STF1_END));
                break;
            }
            case HEAD_PLUS4: {
                if (format == SDMFormat.MPT1327) {
                    sb.append(this.mMessage.getHex(B2_SDM_STF0_START, B2_SDM_STF0_END));
                    sb.append(" ");
                    sb.append(this.mMessage.getHex(B3_SDM_START, B3_SDM_END));
                    sb.append(" ");
                    sb.append(this.mMessage.getHex(B4_SDM_STF0_START, B4_SDM_STF0_END));
                    sb.append(" ");
                    sb.append(this.mMessage.getHex(B5_SDM_START, B5_SDM_END));
                    break;
                }
                sb.append(this.mMessage.getHex(B2_SDM_STF1_START, B2_SDM_STF1_END));
                sb.append(" ");
                sb.append(this.mMessage.getHex(B3_SDM_START, B3_SDM_END));
                sb.append(" ");
                sb.append(this.mMessage.getHex(B4_SDM_STF1_START, B4_SDM_STF1_END));
                sb.append(" ");
                sb.append(this.mMessage.getHex(B5_SDM_START, B5_SDM_END));
                break;
            }
        }
        return sb.toString();
    }

    public String getSDMASCII(MPTMessageType type) {
        StringBuilder sb = new StringBuilder();
        int blocks = 0;
        switch (type) {
            case HEAD_PLUS1: {
                blocks = 1;
                break;
            }
            case HEAD_PLUS2: {
                blocks = 2;
                break;
            }
            case HEAD_PLUS3: {
                blocks = 3;
                break;
            }
            case HEAD_PLUS4: {
                blocks = 4;
                break;
            }
        }
        if (blocks >= 1) {
            sb.append((char)this.mMessage.getInt(91, 97));
            sb.append((char)this.mMessage.getInt(98, 104));
            sb.append((char)this.mMessage.getInt(105, 111));
            sb.append((char)this.mMessage.getInt(112, 118));
            sb.append((char)this.mMessage.getInt(119, 125));
        }
        if (blocks >= 2) {
            sb.append((char)this.mMessage.getInt(new int[]{126, 127, 128, 129, 130, 131, 150}));
            sb.append((char)this.mMessage.getInt(151, 157));
            sb.append((char)this.mMessage.getInt(158, 164));
            sb.append((char)this.mMessage.getInt(165, 171));
            sb.append((char)this.mMessage.getInt(172, 178));
            sb.append((char)this.mMessage.getInt(179, 185));
            sb.append((char)this.mMessage.getInt(186, 192));
        }
        if (blocks >= 3) {
            sb.append((char)this.mMessage.getInt(new int[]{193, 194, 195, 218, 219, 220, 221}));
            sb.append((char)this.mMessage.getInt(222, 228));
            sb.append((char)this.mMessage.getInt(229, 235));
            sb.append((char)this.mMessage.getInt(236, 242));
            sb.append((char)this.mMessage.getInt(243, 249));
            sb.append((char)this.mMessage.getInt(250, 256));
        }
        if (blocks == 4) {
            sb.append((char)this.mMessage.getInt(new int[]{257, 258, 259, 278, 279, 280, 281}));
            sb.append((char)this.mMessage.getInt(282, 288));
            sb.append((char)this.mMessage.getInt(289, 295));
            sb.append((char)this.mMessage.getInt(296, 302));
            sb.append((char)this.mMessage.getInt(303, 309));
            sb.append((char)this.mMessage.getInt(310, 316));
            sb.append((char)this.mMessage.getInt(317, 323));
        }
        return sb.toString();
    }

    public String getSDMBCD(MPTMessageType type) {
        StringBuilder sb = new StringBuilder();
        int blocks = 0;
        switch (type) {
            case HEAD_PLUS1: {
                blocks = 1;
                break;
            }
            case HEAD_PLUS2: {
                blocks = 2;
                break;
            }
            case HEAD_PLUS3: {
                blocks = 3;
                break;
            }
            case HEAD_PLUS4: {
                blocks = 4;
                break;
            }
        }
        if (blocks >= 1) {
            sb.append(this.getBCD(this.mMessage.getInt(90, 93)));
            sb.append(this.getBCD(this.mMessage.getInt(94, 97)));
            sb.append(this.getBCD(this.mMessage.getInt(98, 101)));
            sb.append(this.getBCD(this.mMessage.getInt(102, 105)));
            sb.append(this.getBCD(this.mMessage.getInt(106, 109)));
            sb.append(this.getBCD(this.mMessage.getInt(110, 113)));
            sb.append(this.getBCD(this.mMessage.getInt(114, 117)));
            sb.append(this.getBCD(this.mMessage.getInt(118, 121)));
            sb.append(this.getBCD(this.mMessage.getInt(122, 125)));
            sb.append(this.getBCD(this.mMessage.getInt(126, 129)));
        }
        if (blocks >= 2) {
            sb.append(this.getBCD(this.mMessage.getInt(new int[]{130, 131, 150, 151})));
            sb.append(this.getBCD(this.mMessage.getInt(152, 155)));
            sb.append(this.getBCD(this.mMessage.getInt(156, 159)));
            sb.append(this.getBCD(this.mMessage.getInt(160, 163)));
            sb.append(this.getBCD(this.mMessage.getInt(164, 167)));
            sb.append(this.getBCD(this.mMessage.getInt(168, 171)));
            sb.append(this.getBCD(this.mMessage.getInt(172, 175)));
            sb.append(this.getBCD(this.mMessage.getInt(176, 179)));
            sb.append(this.getBCD(this.mMessage.getInt(180, 183)));
            sb.append(this.getBCD(this.mMessage.getInt(184, 187)));
            sb.append(this.getBCD(this.mMessage.getInt(188, 191)));
            sb.append(this.getBCD(this.mMessage.getInt(192, 195)));
        }
        if (blocks >= 3) {
            sb.append(this.getBCD(this.mMessage.getInt(218, 221)));
            sb.append(this.getBCD(this.mMessage.getInt(222, 225)));
            sb.append(this.getBCD(this.mMessage.getInt(226, 229)));
            sb.append(this.getBCD(this.mMessage.getInt(230, 233)));
            sb.append(this.getBCD(this.mMessage.getInt(234, 237)));
            sb.append(this.getBCD(this.mMessage.getInt(238, 241)));
            sb.append(this.getBCD(this.mMessage.getInt(242, 245)));
            sb.append(this.getBCD(this.mMessage.getInt(246, 249)));
            sb.append(this.getBCD(this.mMessage.getInt(250, 253)));
            sb.append(this.getBCD(this.mMessage.getInt(254, 257)));
        }
        if (blocks == 4) {
            sb.append(this.getBCD(this.mMessage.getInt(new int[]{258, 259, 278, 279})));
            sb.append(this.getBCD(this.mMessage.getInt(280, 283)));
            sb.append(this.getBCD(this.mMessage.getInt(284, 287)));
            sb.append(this.getBCD(this.mMessage.getInt(288, 291)));
            sb.append(this.getBCD(this.mMessage.getInt(292, 295)));
            sb.append(this.getBCD(this.mMessage.getInt(296, 299)));
            sb.append(this.getBCD(this.mMessage.getInt(300, 303)));
            sb.append(this.getBCD(this.mMessage.getInt(304, 307)));
            sb.append(this.getBCD(this.mMessage.getInt(308, 311)));
            sb.append(this.getBCD(this.mMessage.getInt(312, 315)));
            sb.append(this.getBCD(this.mMessage.getInt(316, 319)));
            sb.append(this.getBCD(this.mMessage.getInt(320, 232)));
        }
        return sb.toString();
    }

    private String getBCD(int value) {
        if (0 <= value && value <= 12) {
            return BCD[value];
        }
        return "?";
    }

    public String getSDMTelex(MPTMessageType type) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int blocks = 0;
        switch (type) {
            case HEAD_PLUS1: {
                blocks = 1;
                break;
            }
            case HEAD_PLUS2: {
                blocks = 2;
                break;
            }
            case HEAD_PLUS3: {
                blocks = 3;
                break;
            }
            case HEAD_PLUS4: {
                blocks = 4;
                break;
            }
        }
        if (blocks >= 1) {
            values.add(this.mMessage.getInt(91, 95));
            values.add(this.mMessage.getInt(96, 100));
            values.add(this.mMessage.getInt(101, 105));
            values.add(this.mMessage.getInt(106, 110));
            values.add(this.mMessage.getInt(111, 115));
            values.add(this.mMessage.getInt(116, 120));
            values.add(this.mMessage.getInt(121, 125));
            values.add(this.mMessage.getInt(126, 130));
        }
        if (blocks >= 2) {
            values.add(this.mMessage.getInt(new int[]{131, 150, 151, 152, 153}));
            values.add(this.mMessage.getInt(154, 158));
            values.add(this.mMessage.getInt(159, 163));
            values.add(this.mMessage.getInt(164, 168));
            values.add(this.mMessage.getInt(169, 173));
            values.add(this.mMessage.getInt(174, 178));
            values.add(this.mMessage.getInt(179, 183));
            values.add(this.mMessage.getInt(184, 188));
            values.add(this.mMessage.getInt(189, 193));
        }
        if (blocks >= 3) {
            values.add(this.mMessage.getInt(new int[]{194, 195, 218, 219, 220}));
            values.add(this.mMessage.getInt(221, 225));
            values.add(this.mMessage.getInt(226, 230));
            values.add(this.mMessage.getInt(231, 235));
            values.add(this.mMessage.getInt(236, 240));
            values.add(this.mMessage.getInt(241, 245));
            values.add(this.mMessage.getInt(246, 250));
        }
        if (blocks == 4) {
            values.add(this.mMessage.getInt(new int[]{251, 252, 253, 254, 278}));
            values.add(this.mMessage.getInt(279, 283));
            values.add(this.mMessage.getInt(284, 288));
            values.add(this.mMessage.getInt(289, 293));
            values.add(this.mMessage.getInt(294, 298));
            values.add(this.mMessage.getInt(299, 303));
            values.add(this.mMessage.getInt(304, 308));
            values.add(this.mMessage.getInt(309, 313));
            values.add(this.mMessage.getInt(314, 318));
            values.add(this.mMessage.getInt(319, 323));
        }
        StringBuilder sb = new StringBuilder();
        boolean figure = false;
        for (Integer value : values) {
            if (0 > value || value >= 32) continue;
            if (value == 28) {
                figure = false;
                continue;
            }
            if (value == 29) {
                figure = true;
                continue;
            }
            if (figure) {
                sb.append(TELEX_FIGURES[value]);
                continue;
            }
            sb.append(TELEX_LETTERS[value]);
        }
        return sb.toString();
    }

    public MPT1327Talkgroup getFromIdentifier() {
        if (this.mFromIdentifier == null) {
            this.mFromIdentifier = MPT1327Talkgroup.createFrom(this.getPrefix(), this.getIdent2());
        }
        return this.mFromIdentifier;
    }

    public MPT1327Talkgroup getToIdentifier() {
        if (this.mToIdentifier == null) {
            this.mToIdentifier = MPT1327Talkgroup.createTo(this.getPrefix(), this.getIdent1());
        }
        return this.mToIdentifier;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getToIdentifier());
            this.mIdentifiers.add(this.getFromIdentifier());
        }
        return this.mIdentifiers;
    }

    public static enum MPTMessageType {
        UNKN("Unknown"),
        GTC("GTC - Goto Channel"),
        ALH("ALH - Aloha"),
        ALHS("ALHS - Standard Data Excluded"),
        ALHD("ALHD - Simple Calls Excluded"),
        ALHE("ALHE - Emergency Calls Only"),
        ALHR("ALHR - Emergency or Registration"),
        ALHX("ALHX - Registration Excluded"),
        ALHF("ALHF - Fallback Mode"),
        ACK("ACK - Acknowledge"),
        ACKI("ACKI - More To Follow"),
        ACKQ("ACKQ - Call Queued"),
        ACKX("ACKX - Message Rejected"),
        ACKV("ACKV - Called Unit Unavailable"),
        ACKE("ACKE - Emergency"),
        ACKT("ACKT - Try On Given Address"),
        ACKB("ACKB - Call Back/Negative Ack"),
        AHOY("AHOY - General Availability Check"),
        AHYX("AHYX - Cancel Alert/Waiting Status"),
        AHYP("AHYP - Called Unit Presence Monitoring"),
        AHYQ("AHYQ - Status Message"),
        AHYC("AHYC - Short Data Message"),
        MARK("MARK - Control Channel Marker"),
        MAINT("MAINT - Call Maintenance Message"),
        CLEAR("CLEAR - Down From Allocated Channel"),
        MOVE("MOVE - To Specified Channel"),
        BCAST("BCAST - System Parameters"),
        SAMO("SAMO - Outbound Single Address"),
        SAMIS("SAMIS - Inbound Solicited Single Address"),
        SAMIU("SAMIU - Inbound Unsolicited Single Address"),
        HEAD_PLUS1("HEAD - 1 DATA CODEWORD"),
        HEAD_PLUS2("HEAD - 2 DATA CODEWORDS"),
        HEAD_PLUS3("HEAD - 3 DATA CODEWORDS"),
        HEAD_PLUS4("HEAD - 4 DATA CODEWORDS"),
        GTT("GTT - Go To Transaction"),
        SACK("SACK - Standard Data Selective Ack Header"),
        DACK_DAL("DACK - Data Ack + DAL"),
        DACK_DALG("DACK - Data Ack + DALG"),
        DACK_DALN("DACK - Data Ack + DALN"),
        DACK_GO("DACK - GO Fragment Transmit Invitation"),
        DACKZ("DACKZ - Data Ack For Expedited Data"),
        DACKD("DACKD - Data Ack For Standard Data"),
        DAHY("DAHY - Standard Data Ahoy"),
        DRQG("DRQG - Repeat Group Message"),
        DRQZ("DRQZ - Request Containing Expedited Data"),
        DAHYZ("DAHYZ - Expedited Data Ahoy"),
        DAHYX("DAHYX - Standard Data For Closing TRANS"),
        DRQX("DRQX - Request To Close A Transaction"),
        RLA("RLA - Repeat Last ACK"),
        SITH("SITH - Standard Data Address Codeword Data Item");

        private String mDescription;

        private MPTMessageType(String description) {
            this.mDescription = description;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String toString() {
            return this.getDescription();
        }

        public static MPTMessageType fromNumber(int number) {
            if (number < 256) {
                return GTC;
            }
            switch (number) {
                case 256: {
                    return ALH;
                }
                case 257: {
                    return ALHS;
                }
                case 258: {
                    return ALHD;
                }
                case 259: {
                    return ALHE;
                }
                case 260: {
                    return ALHR;
                }
                case 261: {
                    return ALHX;
                }
                case 262: {
                    return ALHF;
                }
                case 264: {
                    return ACK;
                }
                case 265: {
                    return ACKI;
                }
                case 266: {
                    return ACKQ;
                }
                case 267: {
                    return ACKX;
                }
                case 268: {
                    return ACKV;
                }
                case 269: {
                    return ACKE;
                }
                case 270: {
                    return ACKT;
                }
                case 271: {
                    return ACKB;
                }
                case 272: {
                    return AHOY;
                }
                case 274: {
                    return AHYX;
                }
                case 277: {
                    return AHYP;
                }
                case 278: {
                    return AHYQ;
                }
                case 279: {
                    return AHYC;
                }
                case 280: {
                    return MARK;
                }
                case 281: {
                    return MAINT;
                }
                case 282: {
                    return CLEAR;
                }
                case 283: {
                    return MOVE;
                }
                case 284: {
                    return BCAST;
                }
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 292: 
                case 293: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 300: 
                case 301: 
                case 302: 
                case 303: {
                    return SAMO;
                }
                case 304: 
                case 305: 
                case 306: 
                case 307: {
                    return HEAD_PLUS1;
                }
                case 308: 
                case 309: 
                case 310: 
                case 311: {
                    return HEAD_PLUS2;
                }
                case 312: 
                case 313: 
                case 314: 
                case 315: {
                    return HEAD_PLUS3;
                }
                case 316: 
                case 317: 
                case 318: 
                case 319: {
                    return HEAD_PLUS4;
                }
                case 320: 
                case 321: 
                case 322: 
                case 323: 
                case 324: 
                case 325: 
                case 326: 
                case 327: 
                case 328: 
                case 329: 
                case 330: 
                case 331: 
                case 332: 
                case 333: 
                case 334: 
                case 335: {
                    return GTT;
                }
                case 416: {
                    return DACK_DAL;
                }
                case 417: {
                    return DACK_DALG;
                }
                case 418: {
                    return DACK_DALN;
                }
                case 419: {
                    return DACK_GO;
                }
                case 420: {
                    return DACKZ;
                }
                case 421: {
                    return DACKD;
                }
                case 424: {
                    return DAHY;
                }
                case 426: {
                    return DRQG;
                }
                case 428: {
                    return DAHYZ;
                }
                case 430: {
                    return DAHYX;
                }
                case 440: 
                case 441: 
                case 442: 
                case 443: {
                    return SITH;
                }
            }
            return UNKN;
        }
    }

    public static enum SystemDefinition {
        UNKNOWN("UNKNOWN"),
        ANNOUNCE_CONTROL_CHANNEL("ANNOUNCE CONTROL CHANNEL"),
        WITHDRAW_CONTROL_CHANNEL("WITHDRAW CONTROL CHANNEL"),
        SPECIFY_CALL_MAINTENANCE_PARAMETERS("CALL MAINT PARAMETERS"),
        SPECIFY_REGISTRATION_PARAMETERS("REGISTRATION PARAMETERS"),
        BROADCAST_ADJACENT_SITE_CONTROL_CHANNEL_NUMBER("NEIGHBOR"),
        VOTE_NOW_ADVICE("VOTE NOW");

        private String mLabel;

        private SystemDefinition(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static SystemDefinition fromNumber(int number) {
            switch (number) {
                case 0: {
                    return ANNOUNCE_CONTROL_CHANNEL;
                }
                case 1: {
                    return WITHDRAW_CONTROL_CHANNEL;
                }
                case 2: {
                    return SPECIFY_CALL_MAINTENANCE_PARAMETERS;
                }
                case 3: {
                    return SPECIFY_REGISTRATION_PARAMETERS;
                }
                case 4: {
                    return BROADCAST_ADJACENT_SITE_CONTROL_CHANNEL_NUMBER;
                }
                case 5: {
                    return VOTE_NOW_ADVICE;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum IdentType {
        ALLI("SYSTEM-WIDE"),
        DIVERTI("DIVERT"),
        DNI("DATA NETWORK GATEWAY"),
        DUMMYI("DUMMY IDENT"),
        INCI("INCLUDE IN CALL"),
        IPFIXI("INTER-PREFIX"),
        PABXI("PABX GATEWAY"),
        PSTNGI("PSTN GATEWAY"),
        PSTNSI1("PSTN OR NETWORK 1"),
        PSTNSI2("PSTN OR NETWORK 2"),
        PSTNSI3("PSTN OR NETWORK 3"),
        PSTNSI4("PSTN OR NETWORK 4"),
        PSTNSI5("PSTN OR NETWORK 5"),
        PSTNSI6("PSTN OR NETWORK 6"),
        PSTNSI7("PSTN OR NETWORK 7"),
        PSTNSI8("PSTN OR NETWORK 8"),
        PSTNSI9("PSTN OR NETWORK 9"),
        PSTNSI10("PSTN OR NETWORK 10"),
        PSTNSI11("PSTN OR NETWORK 11"),
        PSTNSI12("PSTN OR NETWORK 12"),
        PSTNSI13("PSTN OR NETWORK 13"),
        PSTNSI14("PSTN OR NETWORK 14"),
        PSTNSI15("PSTN OR NETWORK 15"),
        REGI("REGISTRATION"),
        RESERVED("RESERVED"),
        SDMI("SHORT DATA MESSAGE"),
        SPARE("SPARE"),
        TSCI("SYSTEM CONTROLLER"),
        USER("COMMON-PREFIX IDENT"),
        UNKNOWN("UNKNOWN");

        private String mLabel;

        private IdentType(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static IdentType fromIdent(int ident) {
            switch (ident) {
                case 0: {
                    return DUMMYI;
                }
                case 8101: {
                    return PSTNGI;
                }
                case 8102: {
                    return PABXI;
                }
                case 8103: {
                    return DNI;
                }
                case 8121: {
                    return PSTNSI1;
                }
                case 8122: {
                    return PSTNSI2;
                }
                case 8123: {
                    return PSTNSI3;
                }
                case 8124: {
                    return PSTNSI4;
                }
                case 8125: {
                    return PSTNSI5;
                }
                case 8126: {
                    return PSTNSI6;
                }
                case 8127: {
                    return PSTNSI7;
                }
                case 8128: {
                    return PSTNSI8;
                }
                case 8129: {
                    return PSTNSI9;
                }
                case 8130: {
                    return PSTNSI10;
                }
                case 8131: {
                    return PSTNSI11;
                }
                case 8132: {
                    return PSTNSI12;
                }
                case 8133: {
                    return PSTNSI13;
                }
                case 8134: {
                    return PSTNSI14;
                }
                case 8135: {
                    return PSTNSI15;
                }
                case 8181: 
                case 8182: 
                case 8183: 
                case 8184: {
                    return RESERVED;
                }
                case 8185: {
                    return REGI;
                }
                case 8186: {
                    return INCI;
                }
                case 8187: {
                    return DIVERTI;
                }
                case 8188: {
                    return SDMI;
                }
                case 8189: {
                    return IPFIXI;
                }
                case 8190: {
                    return TSCI;
                }
                case 8191: {
                    return ALLI;
                }
            }
            if (1 <= ident && ident <= 8100) {
                return USER;
            }
            if (8104 <= ident && ident <= 8120 || 8136 <= ident && ident <= 8180) {
                return SPARE;
            }
            return UNKNOWN;
        }
    }

    public static enum Slots {
        SLOTS_0("RESERVED"),
        SLOTS_1("ADDRESS CODEWORD ONLY"),
        SLOTS_2("ADDRESS CODEWORD & 1-2 DATA CODEWORDS"),
        SLOTS_3("ADDRESS CODEWORD & 3-4 DATA CODEWORDS"),
        UNKNOWN("UNKNOWN");

        private String mLabel;

        private Slots(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static Slots fromNumber(int number) {
            switch (number) {
                case 0: {
                    return SLOTS_0;
                }
                case 1: {
                    return SLOTS_1;
                }
                case 2: {
                    return SLOTS_2;
                }
                case 3: {
                    return SLOTS_3;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Descriptor {
        DESC0("EXTENDED ADDRESSING INFORMATION", "ESN", "SINGLE SEGMENT TRANSACTIONS (SST) ONLY"),
        DESC1("PSTN DIALED DIGITS", "RESERVED", "N/A"),
        DESC2("PABX EXTENSION", "RESERVED", "N/A"),
        DESC3("N/A", "N/A", "N/A"),
        DESC4("N/A", "N/A", "FIRST MST SEGMENT OR SINGLE SST"),
        DESC5("N/A", "N/A", "SECOND MST SEGMENT OR SINGLE SST"),
        DESC6("N/A", "N/A", "THIRD MST SEGMENT OR SINGLE SST"),
        DESC7("RESERVED", "RESERVED", "FOURTH MST SEGMENT OR SINGLE SST"),
        UNKNOWN("UNKNOWN", "UNKNOWN", "UNKNOWN");

        private String mMode1Label;
        private String mMode2Label;
        private String mSDMLabel;

        private Descriptor(String mode1Label, String mode2Label, String sdmLabel) {
            this.mMode1Label = mode1Label;
            this.mMode2Label = mode2Label;
            this.mSDMLabel = sdmLabel;
        }

        public String getMode1Label() {
            return this.mMode1Label;
        }

        public String getMode2Label() {
            return this.mMode2Label;
        }

        public String getSDMLabel() {
            return this.mSDMLabel;
        }

        public static Descriptor fromNumber(int number) {
            switch (number) {
                case 0: {
                    return DESC0;
                }
                case 1: {
                    return DESC1;
                }
                case 2: {
                    return DESC2;
                }
                case 3: {
                    return DESC3;
                }
                case 4: {
                    return DESC4;
                }
                case 5: {
                    return DESC5;
                }
                case 6: {
                    return DESC6;
                }
                case 7: {
                    return DESC7;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum SDMFormat {
        MPT1327,
        MPT1343_BINARY,
        MPT1343_BCD,
        MPT1343_TELEX,
        MPT1343_ASCII,
        MPT1343_RESERVED,
        MPT1343_SPARE,
        MPT1343_COMMAND,
        MPT1343_MAP27,
        UNKNOWN;


        public static SDMFormat valueOf(boolean stf, int gfi) {
            if (stf) {
                switch (gfi) {
                    case 0: {
                        return MPT1343_BINARY;
                    }
                    case 1: {
                        return MPT1343_BCD;
                    }
                    case 2: {
                        return MPT1343_TELEX;
                    }
                    case 3: {
                        return MPT1343_ASCII;
                    }
                    case 4: {
                        return MPT1343_RESERVED;
                    }
                    case 5: {
                        return MPT1343_SPARE;
                    }
                    case 6: {
                        return MPT1343_COMMAND;
                    }
                    case 7: {
                        return MPT1343_MAP27;
                    }
                }
                return UNKNOWN;
            }
            return MPT1327;
        }
    }
}

