/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mpt1327;

import io.github.dsheirer.channel.state.ChangeChannelTimeoutEvent;
import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.mpt1327.MPT1327DecodeEvent;
import io.github.dsheirer.module.decode.mpt1327.MPT1327Message;
import io.github.dsheirer.module.decode.mpt1327.MPT1327TrafficChannelManager;
import io.github.dsheirer.module.decode.mpt1327.channel.MPT1327Channel;
import io.github.dsheirer.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPT1327DecoderState
extends DecoderState {
    private static final Logger mLog = LoggerFactory.getLogger(MPT1327DecoderState.class);
    private TreeSet<String> mIdents = new TreeSet();
    private HashMap<String, ArrayList<String>> mGroups = new HashMap();
    private String mSite;
    private int mChannelNumber;
    private Channel.ChannelType mChannelType;
    private long mFrequency = 0L;
    private long mCallTimeoutMilliseconds;
    private MPT1327TrafficChannelManager mMPT1327TrafficChannelManager;

    public MPT1327DecoderState(MPT1327TrafficChannelManager trafficChannelManager, Channel.ChannelType channelType, long callTimeoutMilliseconds) {
        this.mMPT1327TrafficChannelManager = trafficChannelManager;
        this.mChannelType = channelType;
        this.mCallTimeoutMilliseconds = callTimeoutMilliseconds;
    }

    public MPT1327DecoderState(Channel.ChannelType channelType, long callTimeoutMilliseconds) {
        this(null, channelType, callTimeoutMilliseconds);
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.MPT1327;
    }

    public Channel.ChannelType getChannelType() {
        return this.mChannelType;
    }

    @Override
    public void receive(IMessage message) {
        if (message.isValid() && message instanceof MPT1327Message) {
            MPT1327Message mpt = (MPT1327Message)message;
            switch (mpt.getMessageType()) {
                case ACK: {
                    this.mIdents.add(mpt.getFromID());
                    MPT1327Message.IdentType identType = mpt.getIdent1Type();
                    if (identType == MPT1327Message.IdentType.REGI) {
                        this.broadcast(this.getDecodeEvent(message, mpt, DecodeEventType.REGISTER, null));
                    } else {
                        this.broadcast(this.getDecodeEvent(message, mpt, DecodeEventType.RESPONSE, "ACK " + identType.getLabel()));
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL));
                    break;
                }
                case ACKB: 
                case ACKE: 
                case ACKI: 
                case ACKQ: 
                case ACKT: 
                case ACKV: 
                case ACKX: {
                    this.broadcast(this.getDecodeEvent(message, mpt, DecodeEventType.ACKNOWLEDGE, mpt.getMessageType().getDescription()));
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL));
                    break;
                }
                case AHYC: {
                    this.broadcast(this.getDecodeEvent(message, mpt, DecodeEventType.COMMAND, "Send Short Data Message"));
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL));
                    break;
                }
                case AHYQ: {
                    this.broadcast(this.getDecodeEvent(message, mpt, DecodeEventType.COMMAND, "Send Status Message"));
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL));
                    break;
                }
                case ALH: 
                case ALHD: 
                case ALHE: 
                case ALHF: 
                case ALHR: 
                case ALHS: 
                case ALHX: {
                    this.setSite(mpt.getSiteID());
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.START, State.CONTROL));
                    break;
                }
                case GTC: {
                    if (this.mMPT1327TrafficChannelManager != null) {
                        MutableIdentifierCollection ic = this.getUpdatedMutableIdentifierCollection(mpt);
                        this.mMPT1327TrafficChannelManager.processChannelGrant(mpt, ic);
                        break;
                    }
                    MPT1327Channel channel = MPT1327Channel.create(mpt.getChannel());
                    DecodeEvent decodeEvent = this.getDecodeEvent(message, mpt, DecodeEventType.CALL_DETECT, mpt.getMessage());
                    decodeEvent.setChannelDescriptor(channel);
                    this.broadcast(decodeEvent);
                    break;
                }
                case HEAD_PLUS1: 
                case HEAD_PLUS2: 
                case HEAD_PLUS3: 
                case HEAD_PLUS4: {
                    this.broadcast(this.getDecodeEvent(message, mpt, DecodeEventType.SDM, mpt.getMessage()));
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL));
                    break;
                }
                case CLEAR: {
                    this.mChannelNumber = mpt.getChannel();
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.END, State.FADE));
                    break;
                }
                case MAINT: {
                    this.getIdentifierCollection().update(mpt.getToIdentifier());
                    if (this.mChannelType != Channel.ChannelType.STANDARD) break;
                    this.broadcast(new ChangeChannelTimeoutEvent((Object)this, this.mChannelType, this.mCallTimeoutMilliseconds));
                    this.broadcast(this.getDecodeEvent(message, mpt, DecodeEventType.CALL_IN_PROGRESS, null));
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.START, State.CALL));
                    break;
                }
            }
        }
    }

    private DecodeEvent getDecodeEvent(IMessage message, MPT1327Message mpt, DecodeEventType decodeEventType, String details) {
        MutableIdentifierCollection ic = this.getUpdatedMutableIdentifierCollection(mpt);
        return MPT1327DecodeEvent.builder(decodeEventType, message.getTimestamp()).details(details).identifiers(ic).build();
    }

    private MutableIdentifierCollection getUpdatedMutableIdentifierCollection(MPT1327Message mpt) {
        MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
        ic.remove(IdentifierClass.USER);
        ic.update(mpt.getIdentifiers());
        return ic;
    }

    @Override
    public void reset() {
        super.reset();
        this.mIdents.clear();
        this.resetState();
    }

    @Override
    public void start() {
        if (this.mChannelType == Channel.ChannelType.TRAFFIC) {
            this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.START, State.CALL));
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void init() {
    }

    @Override
    protected void resetState() {
        super.resetState();
        if (this.mChannelType == Channel.ChannelType.STANDARD) {
            this.broadcast(new ChangeChannelTimeoutEvent((Object)this, this.mChannelType, 45000L));
        }
    }

    public String getSite() {
        return this.mSite;
    }

    public void setSite(String site) {
        if (!StringUtils.isEqual(this.mSite, site)) {
            this.mSite = site;
        }
    }

    public int getChannelNumber() {
        return this.mChannelNumber;
    }

    public void setChannelNumber(int channel) {
        if (this.mChannelNumber != channel) {
            this.mChannelNumber = channel;
        }
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Activity Summary - Decoder: MPT-1327\n");
        sb.append(this.DIVIDER1);
        sb.append("Site: ");
        if (this.mSite != null) {
            sb.append(this.mSite).append("\n");
        } else {
            sb.append("Unknown\n");
        }
        sb.append(this.DIVIDER2).append("Talkgroups: ");
        if (this.mGroups.isEmpty()) {
            sb.append("None\n");
        } else {
            ArrayList<String> talkgroups = new ArrayList<String>(this.mGroups.keySet());
            Collections.sort(talkgroups);
            for (String talkgroup : talkgroups) {
                sb.append("\n ").append(talkgroup);
                sb.append("\n");
                ArrayList<String> members = this.mGroups.get(talkgroup);
                Collections.sort(members);
                for (String member : members) {
                    sb.append("  >");
                    sb.append(member);
                    sb.append("\n");
                }
            }
        }
        sb.append(this.DIVIDER2).append("All Idents: ");
        if (this.mIdents.isEmpty()) {
            sb.append("None\n");
        } else {
            sb.append("\n");
            for (String ident : this.mIdents) {
                sb.append(ident);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.resetState();
                break;
            }
            case NOTIFICATION_SOURCE_FREQUENCY: {
                this.mFrequency = event.getFrequency();
                break;
            }
        }
    }
}

