/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mpt1327;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.mpt1327.MPT1327DecodeEvent;
import io.github.dsheirer.protocol.Protocol;

public class MPT1327ChannelGrantEvent
extends MPT1327DecodeEvent {
    public MPT1327ChannelGrantEvent(DecodeEventType decodeEventType, long timestamp) {
        super(decodeEventType, timestamp);
    }

    public static MPT1327ChannelGrantDecodeEventBuilder mpt1327Builder(DecodeEventType decodeEventType, long timeStart) {
        return new MPT1327ChannelGrantDecodeEventBuilder(decodeEventType, timeStart);
    }

    public static class MPT1327ChannelGrantDecodeEventBuilder {
        protected long mTimeStart;
        protected long mDuration;
        protected DecodeEventType mDecodeEventType;
        protected IdentifierCollection mIdentifierCollection;
        protected IChannelDescriptor mChannelDescriptor;
        protected String mDetails;

        public MPT1327ChannelGrantDecodeEventBuilder(DecodeEventType decodeEventType, long timeStart) {
            this.mDecodeEventType = decodeEventType;
            this.mTimeStart = timeStart;
        }

        public MPT1327ChannelGrantDecodeEventBuilder duration(long duration) {
            this.mDuration = duration;
            return this;
        }

        public MPT1327ChannelGrantDecodeEventBuilder end(long timestamp) {
            this.mDuration = timestamp - this.mTimeStart;
            return this;
        }

        public MPT1327ChannelGrantDecodeEventBuilder channel(IChannelDescriptor channelDescriptor) {
            this.mChannelDescriptor = channelDescriptor;
            return this;
        }

        public MPT1327ChannelGrantDecodeEventBuilder identifiers(IdentifierCollection identifierCollection) {
            this.mIdentifierCollection = identifierCollection;
            return this;
        }

        public MPT1327ChannelGrantDecodeEventBuilder details(String details) {
            this.mDetails = details;
            return this;
        }

        public MPT1327ChannelGrantEvent build() {
            MPT1327ChannelGrantEvent decodeEvent = new MPT1327ChannelGrantEvent(this.mDecodeEventType, this.mTimeStart);
            decodeEvent.setProtocol(Protocol.MPT1327);
            decodeEvent.setChannelDescriptor(this.mChannelDescriptor);
            decodeEvent.setDetails(this.mDetails);
            decodeEvent.setDuration(this.mDuration);
            decodeEvent.setIdentifierCollection(this.mIdentifierCollection);
            return decodeEvent;
        }
    }
}

