/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mdc1200;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.mdc1200.MDCMessage;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;

public class MDCMessageProcessor
implements Listener<CorrectedBinaryMessage> {
    private static int sMESSAGE_LENGTH = 112;
    private Broadcaster<IMessage> mBroadcaster = new Broadcaster();

    public void dispose() {
        this.mBroadcaster.dispose();
    }

    @Override
    public void receive(CorrectedBinaryMessage buffer) {
        this.deinterleave(buffer, 40);
        this.deinterleave(buffer, 192);
        MDCMessage message = new MDCMessage(buffer);
        this.mBroadcaster.receive(message);
    }

    public void addMessageListener(Listener<IMessage> listener) {
        this.mBroadcaster.addListener(listener);
    }

    public void removeMessageListener(Listener<IMessage> listener) {
        this.mBroadcaster.removeListener(listener);
    }

    private void removeNRZIEncoding(BinaryMessage buffer) {
        buffer.clear(0);
        for (int x = 1; x < buffer.size(); ++x) {
            if (buffer.get(x - 1) ^ buffer.get(x)) {
                buffer.set(x);
                continue;
            }
            buffer.clear(x);
        }
    }

    private void deinterleave(BinaryMessage buffer, int offset) {
        if (buffer.size() < sMESSAGE_LENGTH + offset) {
            throw new IllegalArgumentException("MDCMessageProcessor - cannot deinterleave message - message buffer too short");
        }
        BinaryMessage deinterleaved = new BinaryMessage(112);
        int deinterleavedPointer = 0;
        for (int column = 0; column < 16; ++column) {
            for (int row = 0; row < 7; ++row) {
                if (buffer.get(row * 16 + column + offset)) {
                    deinterleaved.set(deinterleavedPointer);
                }
                ++deinterleavedPointer;
            }
        }
        buffer.clear(offset, offset + sMESSAGE_LENGTH);
        for (int x = 0; x < sMESSAGE_LENGTH; ++x) {
            if (deinterleaved.get(x)) {
                buffer.set(x + offset);
                continue;
            }
            buffer.clear(x + offset);
        }
    }
}

