/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mdc1200;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.module.decode.mdc1200.MDCMessageType;
import io.github.dsheirer.module.decode.mdc1200.identifier.MDC1200Identifier;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MDCMessage
extends Message {
    private static int[] SYNC1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static int[] OPCODE = new int[]{47, 46, 45, 44, 43, 42, 41, 40};
    private static int ANI_FLAG = 40;
    private static int DIRECTION_FLAG = 45;
    private static int ACKNOWLEDGE_REQUIRED_FLAG = 46;
    private static int PACKET_TYPE_FLAG = 47;
    private static int EMERGENCY_FLAG = 48;
    private static int[] ARGUMENT = new int[]{49, 50, 51, 52, 53, 54};
    private static int BOT_EOT_FLAG = 55;
    private static int[] DIGIT_2 = new int[]{59, 58, 57, 56};
    private static int[] DIGIT_1 = new int[]{63, 62, 61, 60};
    private static int[] DIGIT_4 = new int[]{67, 66, 65, 64};
    private static int[] DIGIT_3 = new int[]{71, 70, 69, 68};
    private static int[] IDENTITY = new int[]{63, 62, 61, 60, 59, 58, 57, 56, 71, 70, 69, 68, 67, 66, 65, 64};
    private CorrectedBinaryMessage mMessage;
    private MDC1200Identifier mFromIdentifier;
    private List<Identifier> mIdentifiers;

    public MDCMessage(CorrectedBinaryMessage message) {
        this.mMessage = message;
    }

    public CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public MDC1200Identifier getFromIdentifier() {
        if (this.mFromIdentifier == null) {
            this.mFromIdentifier = MDC1200Identifier.createFrom(this.getMessage().getInt(IDENTITY));
        }
        return this.mFromIdentifier;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getFromIdentifier());
        }
        return this.mIdentifiers;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public PacketType getPacketType() {
        if (this.mMessage.get(PACKET_TYPE_FLAG)) {
            return PacketType.DATA;
        }
        return PacketType.CMND;
    }

    public Acknowledge getResponse() {
        if (this.mMessage.get(ACKNOWLEDGE_REQUIRED_FLAG)) {
            return Acknowledge.YES;
        }
        return Acknowledge.NO;
    }

    public Direction getDirection() {
        if (this.mMessage.get(DIRECTION_FLAG)) {
            return Direction.OUT;
        }
        return Direction.IN;
    }

    public int getOpcode() {
        return this.mMessage.getInt(OPCODE);
    }

    public int getArgument() {
        return this.mMessage.getInt(ARGUMENT);
    }

    public boolean isEmergency() {
        return this.mMessage.get(EMERGENCY_FLAG);
    }

    public boolean isANI() {
        return this.mMessage.get(ANI_FLAG);
    }

    public boolean isBOT() {
        return this.mMessage.get(BOT_EOT_FLAG);
    }

    public boolean isEOT() {
        return !this.mMessage.get(BOT_EOT_FLAG);
    }

    public MDCMessageType getMessageType() {
        switch (this.getOpcode()) {
            case 0: {
                if (this.isEmergency()) {
                    return MDCMessageType.EMERGENCY;
                }
            }
            case 1: {
                return MDCMessageType.ANI;
            }
        }
        return MDCMessageType.UNKNOWN;
    }

    public String pad(String value, int places, String padCharacter) {
        return StringUtils.rightPad((String)value, (int)places, (String)padCharacter);
    }

    public String format(int number, int decimalPlaces) {
        return StringUtils.leftPad((String)Integer.valueOf(number).toString(), (int)decimalPlaces, (char)'0');
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.MDC1200;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MDC1200 UNIT:").append(this.getFromIdentifier());
        if (this.isEmergency()) {
            sb.append(" **EMERGENCY**");
        }
        if (this.isBOT()) {
            sb.append(" BOT");
        }
        if (this.isEOT()) {
            sb.append(" EOT");
        }
        sb.append(" OPCODE:").append(this.format(this.getOpcode(), 2));
        sb.append(" ARG:").append(this.format(this.getArgument(), 3));
        sb.append(" TYPE:").append(this.getPacketType().toString());
        sb.append(" ACK:").append(this.getResponse().toString());
        sb.append(" DIR:").append(this.pad(this.getDirection().toString(), 3, " "));
        return sb.toString();
    }

    private static enum PacketType {
        CMND,
        DATA;

    }

    private static enum Acknowledge {
        YES,
        NO;

    }

    private static enum Direction {
        IN,
        OUT;

    }
}

