/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.osw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.message.osw.LtrNetOswMessage;
import java.util.Collections;
import java.util.List;

public class SystemIdle
extends LtrNetOswMessage {
    public SystemIdle(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.OSW_SYSTEM_IDLE;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC FAIL: ").append(CRCLTR.getCRCReason(this.mMessage, this.getMessageDirection())).append("] ");
        }
        sb.append("IDLE - AREA:").append(SystemIdle.getArea(this.getMessage()));
        sb.append(" LCN:").append(SystemIdle.getChannel(this.getMessage()));
        sb.append(" HOME:").append(SystemIdle.getHomeRepeater(this.getMessage()));
        sb.append(" GROUP:").append(SystemIdle.getGroup(this.getMessage()));
        sb.append(" FREE:").append(SystemIdle.getFree(this.getMessage()));
        sb.append(" MSG:").append(this.getMessage().toString());
        return sb.toString();
    }

    public int getChannel() {
        return SystemIdle.getChannel(this.getMessage());
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

