/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.osw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.identifier.LtrNetRadioIdentifier;
import io.github.dsheirer.module.decode.ltrnet.message.osw.LtrNetOswMessage;
import java.util.ArrayList;
import java.util.List;

public class RegistrationAccept
extends LtrNetOswMessage {
    private LtrNetRadioIdentifier mLtrNetRadioIdentifier;
    private List<Identifier> mIdentifiers;

    public RegistrationAccept(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.OSW_REGISTRATION_ACCEPT;
    }

    public LtrNetRadioIdentifier getUniqueID() {
        if (this.mLtrNetRadioIdentifier == null) {
            this.mLtrNetRadioIdentifier = LtrNetRadioIdentifier.createTo(this.getMessage().getInt(SIXTEEN_BITS));
        }
        return this.mLtrNetRadioIdentifier;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC FAIL: ").append(CRCLTR.getCRCReason(this.mMessage, this.getMessageDirection())).append("] ");
        }
        sb.append("REGISTRATION ACCEPT - RADIO UNIQUE ID: ").append(this.getUniqueID());
        sb.append(" MSG:").append(this.getMessage().toString());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getUniqueID());
        }
        return this.mIdentifiers;
    }
}

