/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.osw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.message.osw.LtrNetOswMessage;
import java.util.ArrayList;
import java.util.List;

public class OswCallStart
extends LtrNetOswMessage {
    private List<Identifier> mIdentifiers;

    public OswCallStart(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.OSW_CALL_START;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC FAIL: ").append(CRCLTR.getCRCReason(this.mMessage, this.getMessageDirection())).append("] ");
        }
        sb.append("CALL START TALKGROUP:").append(this.getTalkgroup().formatted());
        sb.append(" AREA:").append(OswCallStart.getArea(this.getMessage()));
        sb.append(" LCN:").append(OswCallStart.getChannel(this.getMessage()));
        sb.append(" FREE:").append(OswCallStart.getFree(this.getMessage()));
        sb.append(" MSG:").append(this.getMessage().toString());
        return sb.toString();
    }

    public int getChannel() {
        return OswCallStart.getChannel(this.getMessage());
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTalkgroup());
        }
        return this.mIdentifiers;
    }
}

