/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.isw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.esn.ESNIdentifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.message.isw.LtrNetIswMessage;
import io.github.dsheirer.module.decode.ltrnet.message.isw.RegistrationRequestEsnHigh;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;

public class RegistrationRequestEsnLow
extends LtrNetIswMessage {
    private RegistrationRequestEsnHigh mRegistrationRequestEsnHigh;
    private ESNIdentifier mESNIdentifier;
    private List<Identifier> mIdentifiers;

    public RegistrationRequestEsnLow(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.ISW_REGISTRATION_REQUEST_ESN_LOW;
    }

    public void setESNHighMessage(RegistrationRequestEsnHigh message) {
        if (message != null) {
            this.mRegistrationRequestEsnHigh = message;
        }
    }

    public boolean isCompleteEsn() {
        return this.mRegistrationRequestEsnHigh != null;
    }

    public ESNIdentifier getESN() {
        if (this.mESNIdentifier == null) {
            this.mESNIdentifier = ESNIdentifier.create((this.mRegistrationRequestEsnHigh != null ? this.mRegistrationRequestEsnHigh.getESNHigh() : "xxxx") + this.getESNLow(), Protocol.LTR_NET, Role.FROM);
        }
        return this.mESNIdentifier;
    }

    public String getESNLow() {
        int esnLow = this.getMessage().getInt(SIXTEEN_BITS);
        return String.format("%04X", esnLow & 0xFFFF);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ESN LOW: ").append(this.getESN());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getESN());
        }
        return this.mIdentifiers;
    }
}

