/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.isw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.message.LtrNetMessage;

public abstract class LtrNetIswMessage
extends LtrNetMessage {
    public LtrNetIswMessage(CorrectedBinaryMessage message, long timestamp) {
        super(message, MessageDirection.ISW, timestamp);
        int free;
        if (this.mCRC == CRC.FAILED_CRC && CRCLTR.getTransmittedChecksum(this.mMessage) == 127 && ((free = LtrNetIswMessage.getFree(this.getMessage())) == 31 || free == 23)) {
            this.mCRC = CRC.PASSED;
        }
    }

    public static LtrNetMessageType getMessageType(CorrectedBinaryMessage message) {
        int channel = LtrNetIswMessage.getChannel(message);
        if (channel == 31) {
            return LtrNetMessageType.ISW_CALL_END;
        }
        if (channel > 20) {
            switch (channel) {
                case 24: {
                    return LtrNetMessageType.ISW_UNIQUE_ID;
                }
                case 27: {
                    return LtrNetMessageType.ISW_REGISTRATION_REQUEST_ESN_LOW;
                }
                case 29: {
                    return LtrNetMessageType.ISW_REGISTRATION_REQUEST_ESN_HIGH;
                }
            }
        } else if (channel > 0) {
            int free = LtrNetIswMessage.getFree(message);
            switch (free) {
                case 21: {
                    return LtrNetMessageType.ISW_CALL_START;
                }
                case 23: {
                    return LtrNetMessageType.ISW_CALL_END;
                }
                case 31: {
                    return LtrNetMessageType.ISW_REQUEST_ACCESS;
                }
            }
        }
        return LtrNetMessageType.ISW_UNKNOWN;
    }
}

