/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.isw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.identifier.LtrNetRadioIdentifier;
import io.github.dsheirer.module.decode.ltrnet.message.isw.LtrNetIswMessage;
import java.util.ArrayList;
import java.util.List;

public class IswUniqueId
extends LtrNetIswMessage {
    private LtrNetRadioIdentifier mLtrNetRadioIdentifier;
    private List<Identifier> mIdentifiers;

    public IswUniqueId(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.ISW_UNIQUE_ID;
    }

    public LtrNetRadioIdentifier getUniqueID() {
        if (this.mLtrNetRadioIdentifier == null) {
            this.mLtrNetRadioIdentifier = LtrNetRadioIdentifier.createFrom(this.getMessage().getInt(SIXTEEN_BITS));
        }
        return this.mLtrNetRadioIdentifier;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RADIO UNIQUE ID: ").append(this.getUniqueID());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getUniqueID());
        }
        return this.mIdentifiers;
    }
}

